@if (count($roomInfos) == 0)
    <div class="row text-center">
        <div class="col bg-white py-5">
            <h3>{{ $keywords['No Room Found!'] ?? __('No Room Found!') }}</h3>
        </div>
    </div>
@else
    <div class="row">
        @foreach ($roomInfos as $roomInfo)
            <div class="col-md-6">
                <!-- Single Room -->
                <div class="single-room">
                    <a class="room-thumb d-block"
                        href="{{ route('room_details', [getParam(), 'slug' =>$roomInfo->slug]) }}">
                        <img class="lazy" data-src="{{ asset('assets/tenant/img/rooms/' . $roomInfo->featured_img) }}"
                            alt="room">
                        <div class="room-price">
                            <p>{{ dynamicPosition($currencyInfo->base_currency_symbol_position) == 'left' ? dynamicCurrency($currencyInfo->base_currency_symbol) : '' }}
                                {{ $roomInfo->rent }}
                                {{ dynamicPosition($currencyInfo->base_currency_symbol_position) == 'right' ? dynamicCurrency($currencyInfo->base_currency_symbol) : '' }}
                                / {{ $keywords['Night'] ?? __('Night') }}</p>
                        </div>
                    </a>

                    <div class="room-desc">
                            <div class="room-cat">
                                <a class="d-block p-0"
                                    href="{{ route('rooms', [getParam(), 'category' => $roomInfo->category_slug]) }}">{{ $roomInfo->category_name }}</a>
                            </div>
                        <h4>
                            <a
                                href="{{ route('room_details', [getParam(), 'slug' => $roomInfo->slug]) }}">
                                {{ strlen($roomInfo->title) > 45 ? mb_substr($roomInfo->title, 0, 45, 'utf-8') . '...' : $roomInfo->title }}</a>
                        </h4>
                        <p>
                            {{ strlen($roomInfo->summary) > 85 ? mb_substr($roomInfo->summary, 0, 85, 'utf-8') . '...' : $roomInfo->summary }}
                        </p>

                        <ul class="room-info">
                            <li><i class="far fa-bed"></i>{{ $roomInfo->bed }}
                                {{ $roomInfo->bed == 1 ? $keywords['Bed'] ?? __('Bed') : $keywords['Beds'] ?? __('Beds') }}
                            </li>
                            <li><i class="far fa-bath"></i>{{ $roomInfo->bath }}
                                {{ $roomInfo->bath == 1 ? $keywords['Bath'] ?? __('Bath') : $keywords['Baths'] ?? __('Baths') }}
                            </li>
                            @if (!empty($roomInfo->max_guests))
                                <li><i class="far fa-users"></i>{{ $roomInfo->max_guests }}
                                    {{ $roomInfo->max_guests == 1 ? $keywords['Guest'] ?? __('Guest') : $keywords['Guests'] ?? __('Guests') }}
                                </li>
                            @endif
                        </ul>
                    
                        @if ($userBs->room_rating_status == 1)
                            @php
                                $avgRating = \App\Models\User\RoomReview::where('room_id', $roomInfo->room_id)->avg(
                                    'rating',
                                );
                            @endphp
                            <div class="rate">
                                <div class="rating" style="width:{{ $avgRating * 20 }}%"></div>
                            </div>
                        @endif
                    </div>

                </div>
            </div>
        @endforeach
    </div>
@endif
<div class="row">
    <div class="col-12">
        {{ $roomInfos->appends(['category' => request()->input('category'), 'dates' => request()->input('dates'), 'beds' => request()->input('beds'), 'baths' => request()->input('baths'), 'guests' => request()->input('guests'), 'sort_by' => request()->input('sort_by'), 'rents' => request()->input('rents'), 'ammenities' => request()->input('ammenities')])->links() }}
    </div>
</div>
