<!DOCTYPE html>
<html lang="{{ $language->code }}">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title> {{ $keywords['ROOM BOOKING INVOICE'] ?? __('ROOM BOOKING INVOICE') }} || {{ @$user->company_name }} </title>
  <link rel="stylesheet" href="{{ asset('assets/tenant/css/design-pdf.css') }}">

  @php
    $position = $bookingInfo->currency_text_position;
    $currency = $bookingInfo->currency_text;
    $font_family = 'DejaVu Sans, serif';
    $color = '#' . $userBs->primary_color;
    $rtl = 'rtl';
    $unicode_bidi = 'bidi-override';
    $di_block = 'inline-block';
    $w_60 = '60%';
    $w_10 = '10%';
    $w_30 = '30%';
    $w_80 = '80%';
    $w_20 = '20%';
    $w_45 = '45%';
    $direction = $language->rtl = 1 ? 'rtl' : 'ltr';

  @endphp

  <style>
    body {
     
    }

    .rtl {
      unicode-bidi: "{{ $unicode_bidi }}" !important;
      direction: "{{ $rtl }}" !important;
    }

    span {
      display: "{{ $di_block }}"
    }

    .w_50 {
      width: "{{ $w_60 }}" !important;
    }

    .w_10 {
      width: "{{ $w_10 }}" !important;
    }

    .w_40 {
      width: "{{ $w_30 }}" !important;
    }

    .w_80 {
      width: "{{ $w_80 }}";
    }

    .w-20 {
      width: "{{ $w_20 }}";
    }

    .w_45 {
      width: "{{ $w_45 }}";
    }


    .invoice-header {
      background: rgba({{ hexToRgba($userBs->primary_color) }}, 0.2);
      padding: 20px 15px;
    }

    .tm_invoice_info_table {
      background: rgba({{ hexToRgba($userBs->primary_color) }}, 0.2);
    }

    .package-info-table thead {
      background: #{{ $userBs->primary_color }};
    }

    .bg-primary {
      background: #{{ $userBs->primary_color }};
    }

    .text-primary {
      color: #{{ $userBs->primary_color }};
    }
  </style>

</head>

<body>
  <div class="main">
    <div class="invoice-container">
      <div class="invoice-wrapper">
        <div class="invoice-area pb-30">
          <!-- invoice-header -->
          <div class="invoice-header clearfix mb-15">
            <div class="float-left">

              @if ($userBs->logo)
                <img src="{{ asset('assets/tenant/img/logo/' . $userBs->logo) }}" height="40"
                  class="d-inline-block ">
              @else
                <img src="{{ asset('assets/admin/img/noimage.jpg') }}" height="40" class="d-inline-block">
              @endif
            </div>
            <div class="text-right strong invoice-heading float-right">
              {{ $keywords['INVOICE'] ?? __('INVOICE') }}
            </div>
          </div>

          <!-- Title -->
          <div class="mb-15">
            <h1 class="text-primary text-center mb-0 pb-10">
              {{ $keywords['ROOM BOOKING INVOICE'] ?? __('ROOM BOOKING INVOICE') }}
            </h1>
          </div>

          <!-- invoice_info_table -->
          <div class="px-20 mb-25 clearfix tm_invoice_info_table">
            <table>
              <tbody>
                <tr>
                  <td>
                    <span><b> {{ $keywords['Payment Method'] ?? __('Payment Method') }}: </b>
                      {{ $bookingInfo->payment_method }}</span>
                  </td>
                  <td>
                    <span><b> {{ $keywords['Number'] ?? __('Booking Number') }}:</b>
                      #{{ $bookingInfo->booking_number }}
                    </span>
                  </td>
                  <td class="text-right">
                    <span><b> {{ $keywords['Date'] ?? __('Date') }}:</b>
                      {{ \Illuminate\Support\Carbon::parse($bookingInfo->created_at)->format('jS, M Y') }}</span>
                    </span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>

          <!-- order-info -->
          <div class="order-info clearfix px-15 mb-25">
            <div class="text-left float-left">
              <div class="strong">{{ $keywords['Bill to'] ?? __('Bill to') }}:</div>
              <div class="small">
                <strong>{{ $keywords['Customer Name'] ?? __('Customer Name') }}: </strong>
                <span class="{{ $direction }}" dir="{{ $direction }}">
                  {{ ucfirst($bookingInfo->customer_name) }}
                </span>
              </div>

              <div class="small">
                <strong>{{ $keywords['Customer Phone'] ?? __('Customer Phone') }}: </strong>
                <span class="{{ $direction }}" dir="{{ $direction }}">{{ $bookingInfo->customer_phone }}</span>
              </div>


              <div class="small">
                <strong>{{ $keywords['Email'] ?? __('Email') }}: </strong>
                <span class="{{ $direction }}" dir="{{ $direction }}">{{ $bookingInfo->customer_email }}</span>
              </div>

            </div>

            <div class="order-details float-right">
              <div class="text-right">
                <div class="strong">{{ $keywords['Order Details'] ?? __('Order Details') }}:</div>

                @if ($bookingInfo->discount > 0.0)
                  <div class="small"><strong>{{ $keywords['Discount'] ?? __('Discount') }}:
                    </strong>
                    {{ currencyTextPrice($bookingInfo->discount, $currency, $position) }}
                  </div>
                @endif

                <div class="small">
                  <strong>
                    {{ $keywords['Guest'] ?? __('Guest') }}:
                  </strong>
                  {{ $bookingInfo->guests }}
                </div>

                <div class=" small"><strong>{{ $keywords['Paid Amount'] ?? __('Paid Amount') }}:
                  </strong>
                  {{ currencyTextPrice($bookingInfo->grand_total, $currency, $position) }}
                  <div class="small">
                    <strong>
                      {{ $keywords['Payment Status'] ?? __('Payment Status') }}:
                    </strong>
                    @if ($bookingInfo->payment_status == 1)
                      {{ $keywords['Complete'] ?? __('Complete') }}
                    @else
                      {{ $keywords['Incomplete'] ?? __('Incomplete') }}
                    @endif
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!--package-info table -->
          <div class="package-info mb-15">
            <table class="text-left custom-bordered-table package-info-table">
              <thead>
                <tr>
                  <td class="text-left text-white small">
                    <strong>{{ $keywords['Room Type'] ?? __('Room Type') }}</strong>
                  </td>
                  <td class="tm_border_left text-center text-white small">
                    <strong> {{ $keywords['Check-In'] ?? __('Check-In') }}</strong>
                  </td>
                  <td class="tm_border_left text-center text-white small">
                    <strong> {{ $keywords['Check-Out'] ?? __('Check-Out') }}</strong>
                  </td>
                  <td class="tm_border_left text-center text-white small">
                    <strong> {{ $keywords['Price'] ?? __('Price') }}</strong>
                  </td>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>
                    <span class="{{ $direction }}" dir="{{ $direction }}">
                      {{ @$bookingInfo->hotelRoom->roomContent->where('language_id', $language->id)->first()->title }}
                    </span>
                  </td>
                  <td class="text-center">
                    {{ \Illuminate\Support\Carbon::parse($bookingInfo->arrival_date)->format('jS, M Y') }}
                  </td>
                  <td class="text-center">
                    {{ \Illuminate\Support\Carbon::parse($bookingInfo->departure_date)->format('jS, M Y') }}
                  </td>
                  <td class="text-center">
                    {{ currencyTextPrice($bookingInfo->actual_total, $currency, $position) }}
                  </td>
                </tr>
              </tbody>
            </table>
          </div>

          <!--invoice_footer -->
          <div class="tm_invoice_footer clearfix px-15">
            <div class="tm_right_footer float-right">
              <table>
                <tbody>
                  <tr>
                    <td class="fw-bold">{{ $keywords['Subtotal'] ?? __('Subtotal') }}</td>
                    <td class="text-right fw-bold">
                      {{ currencyTextPrice($bookingInfo->subtotal, $currency, $position) }}
                    </td>
                  </tr>
                  @if ($userBs->room_tax_status === 1)
                    <tr>
                      <td class="fw-bold">{{ $keywords['Tax'] ?? __('Tax') }}</td>
                      <td class="text-right fw-bold">
                        {{ currencyTextPrice($bookingInfo->tax, $currency, $position) }}
                      </td>
                    </tr>
                  @endif
                  @if ($userBs->room_fee_status === 1)
                    <tr>
                      <td class="fw-bold">{{ $keywords['Fee'] ?? __('Fee') }}</td>
                      <td class="text-right fw-bold">
                        {{ currencyTextPrice($bookingInfo->fee, $currency, $position) }}
                      </td>
                    </tr>
                  @endif
                  <tr class="bg-primary paid-tr">
                    <td class="fw-bold text-white">
                      {{ $keywords['Paid Amount'] ?? __('Paid Amount') }}</td>
                    <td class="text-right fw-bold text-white">
                      {{ currencyTextPrice($bookingInfo->grand_total, $currency, $position) }}
                    </td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>

          <!--Thanks & Regards -->
          <div class="mt-50">
            <div class="text-right regards">
              {{ $keywords['Thanks & Regards'] ?? __('Thanks & Regards') }},
            </div>
            <div class="text-right strong regards">
              <span class="{{ $direction }}" dir="{{ $direction }}">
                {{ @$user->company_name }}
              </span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
