<script>
    "use strict";

    var rtl = {{ $currentLanguageInfo->rtl }};
    var baseURL = "{!! url('/') !!}";
    var vapid_public_key = "{!! env('VAPID_PUBLIC_KEY') !!}";
</script>

{{-- modernizr js --}}
<script src="{{ asset('assets/user-front/js/modernizr-3.6.0.min.js') }}"></script>

{{-- jQuery --}}
<script src="{{ asset('assets/user-front/js/jquery.min.js') }}"></script>

{{-- popper js --}}
<script src="{{ asset('assets/user-front/js/popper.min.js') }}"></script>

{{-- bootstrap js --}}
<script src="{{ asset('assets/user-front/js/bootstrap.min.js') }}"></script>

{{-- jQuery-ui js --}}
<script src="{{ asset('assets/user-front/js/jquery-ui.min.js') }}"></script>

@if ($userBs->theme_version == 'theme_one' || $userBs->theme_version == 'theme_two')
    {{-- Plugins js --}}
    <script src="{{ asset('assets/tenant/js/plugins.min.js') }}"></script>
@endif

@if (in_array($userBs->theme_version, ['theme_three', 'theme_four', 'theme_five']))
    <!-- this work only index page -->
    @if (\Illuminate\Support\Facades\Route::currentRouteName() == 'front.user.detail.view')
        <!-- Date-range Picker JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/moment.min.js') }}"></script>
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/daterangepicker.js') }}"></script>
        <!-- Counter JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/jquery.counterup.min.js') }}"></script>
        <!-- Nice Select JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/jquery.nice-select.min.js') }}"></script>
        <!-- Magnific Popup JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/jquery.magnific-popup.min.js') }}"></script>
        <!-- Swiper Slider JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/swiper-bundle.min.js') }}"></script>
        <!-- Lazysizes -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/vanilla-lazyload.min.js') }}"></script>
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/lazysizes.min.js') }}"></script>
        <!-- AOS JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/aos.min.js') }}"></script>
        <!-- whatsapp -->
        <script src="{{ asset('assets/front/js/whatsapp.min.js') }}"></script>
        <!-- syotimer -->
        <script src="{{ asset('assets/front/js/jquery-syotimer.min.js') }}"></script>
        <!-- Mouse Hover JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/mouse-hover-move.js') }}"></script>
        <!-- Script JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/script.js') }}"></script>
    @else
        <script src="{{ asset('assets/tenant/js/plugins.min.js') }}"></script>
        <!-- Swiper Slider JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/swiper-bundle.min.js') }}"></script>
        <!-- AOS JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/vendors/aos.min.js') }}"></script>
        <!-- Script JS -->
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/script.js') }}"></script>
    @endif
@endif


    @yield('about_script')
    <!-- Main Common JS -->
    <script src="{{ asset('assets/user-front/js/main-common.js') }}"></script>
    
    @if ($userBs->theme_version == 'theme_three')
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/index-1.js') }}"></script>
    @elseif ($userBs->theme_version == 'theme_four')
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/index-2.js') }}"></script>
    @elseif ($userBs->theme_version == 'theme_five')
        <script src="{{ asset('assets/user-front/theme_3_4_5/js/index-3.js') }}"></script>
    @endif

    @if (($userBs->theme_version == 'theme_one' || $userBs->theme_version == 'theme_two') || !request()->routeIs('front.user.detail.view'))
        {{-- main js --}}
        <script src="{{ asset('assets/user-front/js/main.js') }}"></script>
    @endif

    @if (session()->has('success'))
        <script>
            "use strict";
            toastr['success']("{{ __(session('success')) }}");
        </script>
    @endif

@if (session()->has('error'))
    <script>
        "use strict";
        toastr['error']("{{ __(session('error')) }}");
    </script>
@endif

@if (session()->has('warning'))
    <script>
        "use strict";
        toastr['warning']("{{ __(session('warning')) }}");
    </script>
@endif



{{-- whatsapp init code --}}
@if ($userBs->is_whatsapp == 1)
    <script type="text/javascript">
        var whatsapp_popup = {{ $userBs->whatsapp_popup }};
        var whatsappImg = "{{ asset('assets/tenant/img/whatsapp.svg') }}";

        $(function() {
            $('#WAButton').floatingWhatsApp({
                phone: "{{ $userBs->whatsapp_number }}", //WhatsApp Business phone number
                headerTitle: "{{ $userBs->whatsapp_header_title }}", //Popup Title
                popupMessage: `{!! nl2br($userBs->whatsapp_popup_message) !!}`, //Popup Message
                showPopup: whatsapp_popup == 1 ? true : false, //Enables popup display
                buttonImage: '<img src="' + whatsappImg + '" />', //Button Image
                position: "right" //Position: left | right
            });
        });
    </script>
@endif

@if ($userBs->is_tawkto == 1)

    @php
        $directLink = str_replace('tawk.to', 'embed.tawk.to', $userBs->tawkto_chat_link);
        $directLink = str_replace('chat/', '', $directLink);
    @endphp
    <!--Start of Tawk.to Script-->
    <script type="text/javascript">
        "use strict";
        var Tawk_API = Tawk_API || {},
            Tawk_LoadStart = new Date();
        (function() {
            var s1 = document.createElement("script"),
                s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = '{{ $directLink }}';
            s1.charset = 'UTF-8';
            s1.setAttribute('crossorigin', '*');
            s0.parentNode.insertBefore(s1, s0);
        })();
    </script>

    <!--End of Tawk.to Script-->
@endif
