@extends('user-front.common.layout')

@section('pageHeading')
    {{ __('Home') }}
@endsection

@php
    $metaKeywords = !empty($seo->meta_keyword_home) ? $seo->meta_keyword_home : '';
    $metaDescription = !empty($seo->meta_description_home) ? $seo->meta_description_home : '';
    $langCheck = Session::get('user_lang');
@endphp

@section('meta-keywords', $metaKeywords)
@section('meta-description', $metaDescription)


@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $breadcrumbInfo->breadcrumb,
            'title' => $keywords['Payment Success'] ?? __('Payment Success'),
        ])
        <!-- Breadcrumb Section End -->
        {{-- - purchase success message start -- --}}
        <div class="purchase-message">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="purchase-success">
                            <div class="icon text-success"><i class="far fa-check-circle"></i></div>
                            <h2>{{ $keywords['Success'] ?? __('Success') . '!' }}</h2>
                            @if (request()->input('type') == 'offline')
                                <p>
                                    {{ $keywords['We have received your booking request.'] ?? __('We have received your booking request.') }}
                                </p>
                            @else
                                <p>{{ $keywords['Your transaction was successful.'] ?? __('Your transaction was successful.') }}
                                </p>
                            @endif

                            <p>
                                {{ $keywords['We have sent you a mail with an invoice.'] ?? __('We have sent you a mail with an invoice .') }}
                            </p>

                            @if (request()->input('type') == 'offline')
                                <p>
                                    {{ $keywords['You will be notified via mail once it is approved.'] ?? __('You will be notified via mail once it is approved.') }}
                                </p>
                            @endif
                            <p class="mt-4">{{ $keywords['Thank You.'] ?? __('Thank You.') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {{-- purchase success message end --}}
    </main>
@endsection
