        <!-- Start mobile menu -->
        <div class="mobile-menu">
            <div class="container">
                <div class="mobile-menu-wrapper"></div>
            </div>
        </div>
        <!-- End mobile menu -->

        <div class="main-responsive-nav">
            <div class="container">
                <!-- Mobile Logo -->
                @if (!is_null($userBs->logo))
                    <div class="logo">
                        <a href="{{ route('front.user.detail.view', getParam()) }}">
                            <img src="{{ asset(Constant::WEBSITE_LOGO . '/' . $userBs->logo) }}" alt="logo">
                        </a>
                    </div>
                @endif

                <!-- Menu toggle button -->
                <button class="menu-toggler" type="button">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>

        <div class="container">
            <div class="header-top pt-15">
                <div class="row align-items-center">
                    <div class="col-sm-6 col-md-7 col-lg-6">
                        <div class="header-left mb-15">
                            <ul class="list-unstyled d-flex align-items-center gap-3">
                                @if (!is_null($userBs->support_email))
                                    <li class="icon-start border-end pe-3">
                                        <a href="mailTo: {{ $userBs->support_email }}" target="_self"
                                            title=" {{ $userBs->support_email }}">
                                            <i class="fal fa-envelope"></i>
                                            {{ $userBs->support_email }}
                                        </a>
                                    </li>
                                @endif
                                @if (!is_null($userBs->support_contact))
                                    <li class="icon-start">
                                        <a href="tel:{{ $userBs->support_contact }}" target="_self"
                                            title="{{ $userBs->support_contact }}">
                                            <i class="fal fa-user-headset"></i>{{ $userBs->support_contact }}
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-5 col-lg-6 text-sm-end">
                        <div class="header-right mb-15">
                            <div class="social-link size-md">
                                @foreach ($socialMediaInfos as $socialLinkInfo)
                                    <a class="rounded-pill" href="{{ $socialLinkInfo->url }}" target="_blank" t><i
                                            class="{{ $socialLinkInfo->icon }}"></i></a>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="header-bottom px-4 bg-white">
                <div class="main-navbar">
                    <nav class="navbar navbar-expand-lg">
                        @if (!is_null($userBs->logo))
                            <a class="navbar-brand" href="{{ route('front.user.detail.view', getParam()) }}" target="_self" title="Link">
                                <img src="{{ asset(Constant::WEBSITE_LOGO . '/' . $userBs->logo) }}" alt="Logo">
                            </a>
                        @endif
                        <!-- Navigation items -->
                        @php
                            $links = json_decode($userMenus, true);
                        @endphp
                        <div class="collapse navbar-collapse">
                            <ul id="mainMenu" class="navbar-nav mobile-item mx-auto">
                                @foreach ($links as $link)
                                    @php
                                        $href = getUserHref($link, $currentLanguageInfo->id);
                                    @endphp

                                    @if (!array_key_exists('children', $link))
                                        {{-- - Level1 links which doesn't have dropdown menus - --}}
                                        <li class="nav-item"><a href="{{ $href }}"
                                                target="{{ $link['target'] }}"
                                                class="nav-link">{{ $link['text'] }}</a></li>
                                    @else
                                        <li class="nav-item">
                                            {{-- - Level1 links which has dropdown menus - --}}
                                            <a href="{{ $href }}" target="{{ $link['target'] }}"
                                                class="nav-link toggle">{{ $link['text'] }}</a>

                                            <ul class="menu-dropdown">
                                                {{-- START: 2nd level links --}}
                                                @foreach ($link['children'] as $level2)
                                                    @php
                                                        $l2Href = getUserHref($level2, $currentLanguageInfo->id);
                                                    @endphp

                                                    <li @if (array_key_exists('children', $level2)) class="nav-item" @endif>
                                                        <a href="{{ $l2Href }}" target="{{ $level2['target'] }}"
                                                            class="nav-link">{{ $level2['text'] }}</a>

                                                        @if (array_key_exists('children', $level2))
                                                            <ul class="menu-dropdown">
                                                                @foreach ($level2['children'] as $level3)
                                                                    @php
                                                                        $l3Href = getUserHref(
                                                                            $level3,
                                                                            $currentLanguageInfo->id,
                                                                        );
                                                                    @endphp
                                                                    <li class="nav-item"><a href="{{ $l3Href }}"
                                                                            target="{{ $level3['target'] }}"
                                                                            class="nav-link">{{ $level3['text'] }}</a>
                                                                    </li>
                                                                @endforeach
                                                            </ul>
                                                        @endif
                                                    </li>
                                                @endforeach
                                                {{-- END: 2nd level links --}}
                                            </ul>

                                        </li>
                                    @endif
                                @endforeach
                            </ul>
                        </div>

                        <div class="more-option mobile-item">
                            <div class="item">
                                    <form action="{{ route('front.user.change_language', getParam()) }}"
                                        method="GET">
                                        <div class="language">
                                            <select class="header-select" name="lang_code"
                                                onchange="this.form.submit()">
                                                @foreach ($allLanguageInfos as $languageInfo)
                                                    <option value="{{ $languageInfo->code }}"
                                                        {{ $languageInfo->code == $currentLanguageInfo->code ? 'selected' : '' }}>
                                                        {{ $languageInfo->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </form>
                            </div>
                            <div class="item">
                                <div class="dropdown">
                                    <button type="button" class="btn btn-sm btn-primary dropdown-toggle"
                                        data-bs-toggle="dropdown">{{ $keywords['Customer'] ?? __('Customer') }}</button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        @guest('customer')
                                            <a class="dropdown-item" href="{{ route('customer.login', getParam()) }}">
                                                {{ $keywords['Login'] ?? __('Login') }}
                                            </a>
                                            <a class="dropdown-item" href="{{ route('customer.signup', getParam()) }}">
                                                {{ $keywords['Signup'] ?? __('Signup') }}
                                            </a>
                                        @endguest
                                        @auth('customer')
                                            <a class="dropdown-item"
                                                href="{{ route('customer.dashboard', getParam()) }}">
                                                {{ $keywords['Dashboard'] ?? __('Dashboard') }}
                                            </a>
                                            <a class="dropdown-item" href="{{ route('customer.logout', getParam()) }}">
                                                {{ $keywords['Logout'] ?? __('Logout') }}
                                            </a>
                                        @endauth
                                    </div>
                                </div>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
