<footer class="footer-area bg-img z-1 lazyloaded"
    data-bg-image="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FOOTER_LOGO, $userBs->footer_bg_image, $userBs, 'assets/user-front/default-img/footer-bg-2.jpg') }}"
    style="background-image: url({{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FOOTER_LOGO, $userBs->footer_bg_image, $userBs, 'assets/user-front/default-img/footer-bg-2.jpg') }}); background-size: cover; background-position: center center; display: block;">
    <div class="overlay opacity-85"></div>
    @if ($sections->top_footer_section == 1)
        <div class="footer-top pt-100 pb-70">
            <div class="container">
                @php
                    $footerInfo = App\Models\User\FooterText::query()
                        ->where('user_id', $user->id)
                        ->where('language_id', $currentLanguageInfo->id)
                        ->first();
                @endphp
                <div class="row">
                    <div class="col-lg-4 col-md-4 col-sm-12">
                        <div class="footer-widget aos-init aos-animate" data-aos="fade-up" data-aos-delay="100">
                            <div class="navbar-brand">
                                @if (!is_null($userBs->footer_logo))
                                    <a href="{{ route('front.user.detail.view', getParam()) }}">
                                        <img src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FOOTER_LOGO, $userBs->footer_logo, $userBs) }}"
                                            class="lazy" alt="website logo">
                                    </a>
                                @endif
                            </div>
                            @if (!is_null($footerInfo))
                                <p>{{ $footerInfo->about_company }}</p>
                            @endif


                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-6">
                        <div class="footer-widget aos-init aos-animate" data-aos="fade-up" data-aos-delay="200">
                            <h5>{{ $keywords['Quick Links'] ?? __('Quick Links') }}</h5>
                            @php
                                $quickLinkInfos = App\Models\User\FooterQuickLink::query()
                                    ->where('user_id', $user->id)
                                    ->where('language_id', $currentLanguageInfo->id)
                                    ->orderBy('serial_number', 'ASC')
                                    ->get();
                            @endphp
                            @if (count($quickLinkInfos) == 0)
                                <h5 class="text-white">
                                    {{ $keywords['No Quick Link Found!'] ?? __('No Quick Link Found!') }}</h5>
                            @else
                                <ul class="footer-links">
                                    @foreach ($quickLinkInfos as $quickLinkInfo)
                                        <li><a
                                                href="{{ $quickLinkInfo->url }}">{{ $quickLinkInfo->title }}</a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-6">
                        @if (is_array($packagePermissions) && in_array('Blog', $packagePermissions))
                            <div class="footer-widget aos-init aos-animate" data-aos="fade-up" data-aos-delay="400">
                                <h5>{{ $keywords['Recent Blogs'] ?? __('Recent Blogs') }}</h5>
                                @php
                                    $latestBlogInfos = App\Models\User\Journal\Blog::query()
                                        ->join(
                                            'user_blog_informations',
                                            'user_blogs.id',
                                            '=',
                                            'user_blog_informations.blog_id',
                                        )
                                        ->where('user_blog_informations.language_id', '=', $currentLanguageInfo->id)
                                        ->where('user_blog_informations.user_id', '=', $user->id)
                                        ->select(
                                            'user_blogs.image',
                                            'user_blogs.created_at',
                                            'user_blog_informations.title',
                                            'user_blog_informations.slug',
                                            'user_blog_informations.blog_id',
                                        )
                                        ->orderByDesc('user_blogs.created_at')
                                        ->limit(3)
                                        ->get();
                                @endphp
                                @if (count($latestBlogInfos) == 0)
                                    <h5 class="text-white">
                                        {{ $keywords['No Post Found!'] ?? __('No Post Found!') }}
                                    </h5>
                                @else
                                    <ul class="footer-links">
                                        @foreach ($latestBlogInfos as $footerBlogInfo)
                                            <li>
                                                <h5 class="mb-1 ">
                                                    <a class="text-white"
                                                        href="{{ route('blog_details', [getParam(), 'slug' => $footerBlogInfo->slug]) }}">
                                                        {{ strlen($footerBlogInfo->title) > 40 ? mb_substr($footerBlogInfo->title, 0, 40, 'UTF-8') . '...' : $footerBlogInfo->title }}
                                                    </a>
                                                </h5>
                                                <span>{{ date_format(@$footerBlogInfo->created_at, 'F d, Y') }}</span>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if ($sections->copyright_section == 1)
        <div class="copy-right-area border-top">
            <div class="container">
                <div class="copy-right-content">
                    <div class="social-link mb-20">
                        @if ($socialMediaInfos->count() > 0)
                            @foreach ($socialMediaInfos as $socialLinkInfo)
                                <a class="rounded-pill" href="{{ $socialLinkInfo->url }}"><i
                                        class="{{ $socialLinkInfo->icon }}"></i></a>
                            @endforeach
                        @else
                            <h5 class="text-white">
                                {{ $keywords['No Social Link Found!'] ?? __('No Social Link Found!') }}</h5>
                        @endif

                    </div>
                    @if ($sections->copyright_section == 1)
                        <div>
                            <div class="summernote-content">
                                @if (!is_null($footerInfo))
                                    {!! replaceBaseUrl($footerInfo->copyright_text, 'summernote') !!}
                                @endif
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @endif
    </div>
</footer>
