<footer>
    <div class="container">
        @php
            $footerInfo = App\Models\User\FooterText::query()
                ->where('user_id', $user->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
        @endphp
        @if ($sections->top_footer_section == 1)
            <div class="footer-top">
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="widget footer-widget">
                            @if (!is_null($userBs->footer_logo))
                                <div class="footer-logo">
                                    <img data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FOOTER_LOGO, $userBs->footer_logo, $userBs) }}"
                                        class="lazy" alt="website logo">
                                </div>
                            @endif

                            @if (!is_null($footerInfo))
                                <p>{{ $footerInfo->about_company }}</p>
                            @endif

                            @if (count($socialMediaInfos) > 0)
                                <ul class="social-icons">
                                    @foreach ($socialMediaInfos as $socialLinkInfo)
                                        <li>
                                            <a href="{{ $socialLinkInfo->url }}"><i
                                                    class="{{ $socialLinkInfo->icon }}"></i></a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="widget footer-widget">
                            <h4 class="widget-title">{{ $keywords['Quick Links'] ?? __('Quick Links') }}</h4>
                            @php
                                $quickLinkInfos = App\Models\User\FooterQuickLink::query()
                                    ->where('user_id', $user->id)
                                    ->where('language_id', $currentLanguageInfo->id)
                                    ->orderBy('serial_number', 'ASC')
                                    ->get();
                            @endphp

                            @if (count($quickLinkInfos) == 0)
                                <h5 class="text-white">
                                    {{ $keywords['No Quick Link Found!'] ?? __('No Quick Link Found!') }}
                                </h5>
                            @else
                                <ul class="nav-widget clearfix">
                                    @foreach ($quickLinkInfos as $quickLinkInfo)
                                        <li><a href="{{ $quickLinkInfo->url }}">{{ $quickLinkInfo->title }}</a></li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                    </div>

                    <div class="col-lg-4">
                         @if (is_array($packagePermissions) && in_array('Blog', $packagePermissions))
                        <div class="widget footer-widget">
                            <h4 class="widget-title">{{ $keywords['Recent Posts'] ?? __('Recent Posts') }}</h4>
                            @php
                            $latestBlogInfos  =App\Models\User\Journal\Blog::query()->join('user_blog_informations', 'user_blogs.id', '=', 'user_blog_informations.blog_id')
                            ->where('user_blog_informations.language_id', '=', $currentLanguageInfo->id)
                            ->where('user_blog_informations.user_id', '=', $user->id)
                            ->select('user_blogs.image', 'user_blogs.created_at', 'user_blog_informations.title', 'user_blog_informations.slug', 'user_blog_informations.blog_id',)
                            ->orderByDesc('user_blogs.created_at')
                            ->limit(3)
                            ->get();
                            @endphp
                            @if (count($latestBlogInfos) == 0)
                                <h5 class="text-white">{{ $keywords['No Post Found!'] ?? __('No Post Found !') }}</h5>
                            @else
                                <ul class="recent-post">
                                    @foreach ($latestBlogInfos as $footerBlogInfo)
                                        <li>
                                            <h6>
                                                <a
                                                    href="{{ route('blog_details', [getParam(),'slug' => $footerBlogInfo->slug]) }}">
                                                    {{ strlen($footerBlogInfo->title) > 40 ? mb_substr($footerBlogInfo->title, 0, 40, 'UTF-8') . '...' : $footerBlogInfo->title }}
                                                </a>
                                            </h6>
                                            <span
                                                class="recent-post-date">{{ date_format($footerBlogInfo->created_at, 'F d, Y') }}</span>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        @endif

        @if ($sections->copyright_section == 1)
            <div class="footer-bottom">
                <div class="row text-center">

                    <div class="col-md-12">
                        @if (!is_null($footerInfo))
                            <p class="copy-right text-center">
                            <div class="summernote-content">
                                {!! replaceBaseUrl($footerInfo->copyright_text, 'summernote') !!}
                            </div>
                            </p>
                        @endif
                    </div>
                </div>
            </div>
        @endif
    </div>
</footer>
