@extends('user-front.common.layout')

@section('pageHeading')
   {{ $pageHeading->packages_page_title ?? ($keywords['Packages'] ?? __('Packages')) }}
@endsection

@php
    $metaKeywords = !empty($seo->packages_meta_keywords) ? $seo->packages_meta_keywords : '';
    $metaDescription = !empty($seo->packages_meta_description) ? $seo->packages_meta_description : '';
@endphp
@section('meta-keywords', $metaKeywords)
@section('meta-description', $metaDescription)

@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $breadcrumbInfo?->breadcrumb,
            'title' => $pageHeading->packages_page_title ?? ($keywords['Packages'] ?? __('Packages')),
        ])
        <!-- Breadcrumb Section End -->

        <section class="packages-area-v1 section-bg">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3">
                        <div class="packages-sidebar bg-white px-4 mb-30 py-2" id="packages-sidebar">
                            <div class="widget search-widget">
                                <h4 class="widget-title">{{ $keywords['Categories'] ?? __('Categories') }}</h4>
                                <div class="form_group">
                                    <ul class="categories">
                                        <li class="@if (empty(request()->input('category'))) active @endif"><a href="#"
                                                data-category_id="">{{ $keywords['All'] ?? __('All') }}</a></li>
                                        @foreach ($categories as $category)
                                            <li class="@if (request()->input('category') == $category->id) active @endif"><a href="#"
                                                    data-category_id="{{ $category->slug }}">{{ $category->name }}</a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>

                            <div class="widget search-widget">
                                <h4 class="widget-title">{{ $keywords['Search Here'] ?? __('Search Here') }}</h4>
                                <div class="form_group">
                                    <input type="text" id="searchInput"
                                        placeholder="{{ $keywords['Search By Package Name'] ?? __('Search By Package Name') }}"
                                        value="{{ !empty(request()->input('packageName')) ? request()->input('packageName') : '' }}">
                                </div>
                            </div>

                            <div class="widget location-widget">
                                <h4 class="widget-title">{{ $keywords['Location Search'] ?? __('Location Search') }}</h4>
                                <div class="form_group">
                                    <input type="text" id="locationSearchInput"
                                        placeholder="{{ $keywords['Search By Location'] ?? __('Search By Location') }}"
                                        value="{{ !empty(request()->input('locationName')) ? request()->input('locationName') : '' }}">
                                </div>
                            </div>

                            <div class="widget sortby-widget">
                                <h4 class="widget-title">{{ $keywords['Days'] ?? __('Days') }}</h4>
                                <div class="form_group">
                                    <select id="days" class="nice-select">
                                        <option selected value="">{{ $keywords['All'] ?? __('All') }}</option>

                                        @for ($i = 0; $i < $maxDays; $i++)
                                            <option value="{{ $i + 1 }}"
                                                {{ request()->input('daysValue') == $i + 1 ? 'selected' : '' }}>
                                                {{ __('Up to') }}
                                                {{ $i + 1 }}
                                                {{ $i + 1 == 1 ? $keywords['Day'] ?? __('Day') : $keywords['Days'] ?? __('Days') }}
                                            </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>

                            <div class="widget sortby-widget">
                                <h4 class="widget-title">{{ $keywords['Persons'] ?? __('Persons') }}</h4>
                                <div class="form_group">
                                    <select id="persons" class="nice-select">
                                        <option selected value="">{{ $keywords['All'] ?? __('All') }}</option>
                                        @for ($i = 0; $i < $maxPersons; $i++)
                                            <option value="{{ $i + 1 }}"
                                                {{ request()->input('personsValue') == $i + 1 ? 'selected' : '' }}>
                                                {{ $i + 1 }}
                                                {{ $i + 1 == 1 ? $keywords['Person & More'] ?? __('Person & More') : $keywords['Persons & More'] ?? __('Persons & More') }}
                                            </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>

                            <div class="widget sortby-widget">
                                <h4 class="widget-title">{{ $keywords['Sort By'] ?? __('Sort By') }}</h4>
                                <div class="form_group">
                                    <select id="sortType" class="nice-select">
                                        <option value="new-packages"
                                            {{ request()->input('sortValue') == 'new-packages' ? 'selected' : '' }}>
                                            {{ $keywords['New Packages'] ?? __('New Packages') }}</option>
                                        <option value="old-packages"
                                            {{ request()->input('sortValue') == 'old-packages' ? 'selected' : '' }}>
                                            {{ $keywords['Old Packages'] ?? __('Old Packages') }}</option>
                                        <option value="price-asc"
                                            {{ request()->input('sortValue') == 'price-asc' ? 'selected' : '' }}>
                                            {{ $keywords['Price: Ascending'] ?? __('Price: Ascending') }}</option>
                                        <option value="price-desc"
                                            {{ request()->input('sortValue') == 'price-desc' ? 'selected' : '' }}>
                                            {{ $keywords['Price: Descending'] ?? __('Price: Descending') }}</option>
                                        <option value="max-persons-asc"
                                            {{ request()->input('sortValue') == 'max-persons-asc' ? 'selected' : '' }}>
                                            {{ $keywords['Maximum Persons: Ascending'] ?? __('Maximum Persons: Ascending') }}
                                        </option>
                                        <option value="max-persons-desc"
                                            {{ request()->input('sortValue') == 'max-persons-desc' ? 'selected' : '' }}>
                                            {{ $keywords['Maximum Persons: Descending'] ?? __('Maximum Persons: Descending') }}
                                        </option>
                                        <option value="days-asc"
                                            {{ request()->input('sortValue') == 'days-asc' ? 'selected' : '' }}>
                                            {{ $keywords['Number of Days: Ascending'] ?? __('Number of Days: Ascending') }}
                                        </option>
                                        <option value="days-desc"
                                            {{ request()->input('sortValue') == 'days-desc' ? 'selected' : '' }}>
                                            {{ $keywords['Number of Days: Descending'] ?? __('Number of Days: Descending') }}
                                        </option>
                                    </select>
                                </div>
                            </div>

                            <div class="widget price_ranger_widget">
                                <h4 class="widget-title">{{ $keywords['Filter By Price'] ?? __('Filter By Price') }}</h4>
                                <div id="slider-range"></div>
                                <label for="amount">{{ $keywords['Price'] ?? __('Price') . ' :' }}</label>
                                <input type="text" id="amount" readonly>
                            </div>

                            @if ($userBs->package_rating_status == 1)
                                <div class="widget">
                                    <h4 class="widget-title">{{ $keywords['Ratings'] ?? __('Ratings') }}</h4>
                                    <div class="input-wrap">
                                        <ul class="list-group custom-radio">
                                            <li class="d-flex justify-content-start align-items-center gap-2 mb-1">
                                                <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio6"
                                                    value="" checked>
                                                <label class="form-radio-label" for="radio6">
                                                    <div class="product-ratings text-xsm">
                                                        <span>{{ $keywords['All'] ?? __('All') }}</span>
                                                    </div>
                                                </label>
                                            </li>
                                            <li class="d-flex justify-content-start align-items-center gap-2 mb-1">
                                                <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio1" value="5">
                                                <label class="form-radio-label" for="radio1">
                                                    <div class="rate">
                                                        <div class="rating" style="width:100%"></div>
                                                    </div>
                                                </label>
                                            </li>
                                            <li class="d-flex justify-content-start align-items-center gap-2 mb-1">
                                                <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio2" value="4">
                                                <label class="form-radio-label" for="radio2">
                                                    <div class="rate">
                                                        <div class="rating" style="width:80%"></div>
                                                    </div>
                                                </label>
                                            </li>
                                            <li class="d-flex justify-content-start align-items-center gap-2 mb-1">
                                                <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio3" value="3">

                                                <label class="form-radio-label" for="radio3">
                                                    <div class="rate">
                                                        <div class="rating" style="width:60%"></div>
                                                    </div>
                                                </label>
                                            </li>
                                            <li class="d-flex justify-content-start align-items-center gap-2 mb-1">
                                                <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio4" value="2">

                                                <label class="form-radio-label" for="radio4">
                                                    <div class="rate">
                                                        <div class="rating" style="width:40%"></div>
                                                    </div>
                                                </label>
                                            </li>
                                            <li class="d-flex justify-content-start align-items-center gap-2 mb-1">
                                                <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio5" value="1">
                                                <label class="form-radio-label" for="radio5">
                                                    <div class="rate">
                                                        <div class="rating" style="width:20%"></div>
                                                    </div>
                                                </label>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            @endif

                            <div class="widget">
                                <button type="submit" class="btn filled-btn btn-block p-2 w-100" id="reset_all_btn">
                                    <i class="fal fa-sync-alt"></i>
                                    {{ $keywords['Reset All'] ?? __('Reset All') }}
                                </button>
                            </div>

                        </div>
                        {{-- Ads Section --}}
                        @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
                            @if (!empty(showAd(1)))
                                <div class="text-center mt-0 d-none d-md-block">
                                    {!! showAd(1) !!}
                                </div>
                            @endif
                        @endif
                    </div>

                    <div class="col-lg-9">
                        @if (count($packageInfos) == 0)
                            <div class="row text-center">
                                <div class="bg-white py-5">
                                    <h3 class="text-center">{{ $keywords['No Package Found!'] ?? __('No Package Found!') }}</h3>
                                </div>
                            </div>
                        @else
                            <div class="packages-wrapper search-container">
                                @includeif('user-front.common.package.list_view')
                            </div>
                            @includeif('user-front.common.package.skeleton')
                        @endif

                        {{-- Ads Section --}}
                        @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
                            @if (!empty(showAd(3)))
                                <div class="text-center mt-5">
                                    {!! showAd(3) !!}
                                </div>
                            @endif
                        @endif
                    </div>
                </div>
            </div>
        </section>

        {{-- search form start --}}
        <form class="d-none" action="{{ route('packages', getParam()) }}" method="GET" id="searchForm">

            <input type="hidden" id="categoryKey" name="category" value="{{ request()->input('category') }}">

            <input type="hidden" name="sidebar_search" value="1">
            <input type="hidden" id="searchKey" name="packageName" value="{{ request()->input('packageName') }}">

            <input type="hidden" id="daysKey" name="daysValue" value="{{ request()->input('daysValue') }}">

            <input type="hidden" id="personsKey" name="personsValue" value="{{ request()->input('personsValue') }}">

            <input type="hidden" id="sortKey" name="sortValue" value="{{ request()->input('sortValue') }}">

            <input type="hidden" id="locationKey" name="locationName" value="{{ request()->input('locationName') }}">

            <input type="hidden" id="minPriceKey" name="minPrice" value="{{ request()->input('minPrice') }}">

            <input type="hidden" id="maxPriceKey" name="maxPrice" value="{{ request()->input('maxPrice') }}">

            <input type="hidden" id="ratingsKey" name="ratings" value="{{ request()->input('ratings') }}">

            <button type="submit" id="submitBtn"></button>
        </form>
        {{-- search form end --}}
    </main>
@endsection

@section('script')
    <script>
        "use strict";
        // get the currency symbol position and currency symbol
        var searchUrl = "{{ route('packages', getParam()) }}";
        var currency_info = {!! json_encode($currencyInfo) !!};
        var minprice = {!! htmlspecialchars($minPrice) !!};
        var maxprice = {!! htmlspecialchars($maxPrice) !!};
        var priceValues = [{{ !empty(request()->input('minPrice')) ? request()->input('minPrice') : $minPrice }},
            {{ !empty(request()->input('maxPrice')) ? request()->input('maxPrice') : $maxPrice }}
        ];
    </script>
    <script src="{{ asset('assets/user-front/js/packages.js') }}"></script>
@endsection
