@extends('user-front.common.layout')

@section('pageHeading')
    {{ $keywords['Package Details'] ?? __('Package Details') }}
@endsection

@php
    $metaKeys = !empty($details->meta_keywords) ? $details->meta_keywords : '';
    $metaDesc = !empty($details->meta_description) ? $details->meta_description : '';
@endphp

@section('meta-keywords', $metaKeys)
@section('meta-description', $metaDesc)

@section('og-title', Str::limit(convertUtf8($details->title), 70))
@section('og-description', Str::limit(strip_tags(replaceBaseUrl($details->description)), 200))

@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $breadcrumbInfo?->breadcrumb,
            'title' => $keywords['Package Details'] ?? __('Package Details'),
            'top_title' => convertUtf8($details->title),
        ])
        <!-- Breadcrumb Section End -->

        <section class="packages-details-area">
            <div class="container details-wrapper">
                {{-- show error message for attachment --}}
                @error('attachment')
                    <div class="row">
                        <div class="col">
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <strong>{{ $message }}</strong>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        </div>
                    </div>
                @enderror

                {{-- show error message for package review --}}
                @error('rating')
                    <div class="row">
                        <div class="col">

                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <strong>{{ $message }}</strong>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        </div>
                    </div>
                @enderror
                @error('comment')
                    <div class="row">
                        <div class="col">
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <strong>{{ $message }}</strong>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        </div>
                    </div>
                @enderror

                <div class="row">
                    <div class="col-lg-8">
                        <div class="packages-details-wrapper">

                            <div class="gallery-wrap box-wrap">
                                <div class="packages-big-slider">
                                    @php
                                        $sliderImgs = json_decode($details->package->slider_imgs);
                                    @endphp
                                    @foreach ($sliderImgs as $image)
                                        <div class="single-item">
                                            <a href="{{ asset('assets/tenant/img/packages/slider_images/' . $image) }}"
                                                class="gallery-single">
                                                <img src="{{ asset('assets/tenant/img/packages/slider_images/' . $image) }}"
                                                    alt="image">
                                            </a>
                                        </div>
                                    @endforeach
                                </div>

                                <div class="packages-thumb-slider">
                                    @foreach ($sliderImgs as $thumbImg)
                                        <div class="single-item">
                                            <img src="{{ asset('assets/tenant/img/packages/slider_images/' . $thumbImg) }}"
                                                alt="image">
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <p id="package-id" class="d-none">{{ $details->package_id }}</p>

                            <div class="discription-box box-wrap">
                                <h4 class="title">{{ convertUtf8($details->title) }}</h4>
                                <div class="summernote-content">{!! replaceBaseUrl($details->description, 'summernote') !!}</div>
                            </div>

                            @if (count($plans) > 0)
                                <div class="schedule-wrapp box-wrap">
                                    @if ($details->package->plan_type == 'daywise')
                                        <h4 class="title">
                                            {{ $keywords['Detailed Day-wise Itinerary'] ?? __('Detailed Day-wise Itinerary') }}
                                        </h4>

                                        @foreach ($plans as $plan)
                                            <div class="single-schedule">
                                                <div class="icon">
                                                    <i class="far fa-calendar-alt"></i>
                                                </div>
                                                <div class="content">
                                                    <h4>{{ $keywords['Day'] ?? __('Day') . '-' . $plan->day_number . ' : ' . $plan->title }}
                                                    </h4>
                                                    <div class="summernote-content">
                                                        {!! replaceBaseUrl($plan->plan, 'summernote') !!}
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @elseif ($details->package->plan_type == 'timewise')
                                        <h4 class="title">{{ __('Detailed Time-wise Itinerary') }}</h4>
                                        @foreach ($plans as $plan)
                                            <div class="single-schedule">
                                                <div class="icon">
                                                    <i class="far fa-clock"></i>
                                                </div>
                                                <div class="content">
                                                    <h4>{{ $plan->start_time . ' - ' . $plan->end_time . ' : ' . $plan->title }}
                                                    </h4>
                                                    <div class="summernote-content">
                                                        {!! replaceBaseUrl($plan->plan, 'summernote') !!}
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                            @endif

                            @if (count($locations) > 0)
                                <div class="places-box box-wrap">
                                    <h4 class="title">
                                        {{ $keywords['Places Will Be Covered'] ?? __('Places Will Be Covered') }}</h4>
                                    @foreach ($locations as $location)
                                        <a href="#" data-bs-toggle="modal"
                                            title="{{ $keywords['Click here to see in map'] ?? __('Click here to see in map') }}"
                                            data-bs-target="#locationModal{{ $location->id }}">{{ $location->name }}</a>

                                        <!-- Location Modal -->
                                        @if (!empty($location->latitude) && !empty($location->longitude))
                                            <div class="modal fade" id="locationModal{{ $location->id }}" tabindex="-1"
                                                role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">
                                                                {{ $location->name . ' ' . $keywords['on Map'] ?? __('on Map') }}
                                                            </h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                                aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body p-0">
                                                            <iframe width="100%" height="400" frameborder="0"
                                                                scrolling="no" marginheight="0" marginwidth="0"
                                                                src="//maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q={{ $location->latitude }},%20{{ $location->longitude }}+(My%20Business%20Name)&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            @endif

                            @if ($details->package->pricing_type != 'negotiable')
                                <div
                                    class="review-area box-wrap {{ $status->package_rating_status == 0 ? 'd-none' : '' }}">
                                    <h4 class="title">{{ $keywords['Reviews'] ?? __('Reviews') }}</h4>

                                    @if (count($reviews) == 0)
                                        <div class="py-4 bg-light mb-2">
                                            <h5 class="text-center mb-3">
                                                {{ $keywords['This Package Has No Review Yet .'] ?? __('This Package Has No Review Yet.') }}
                                            </h5>
                                        </div>
                                    @else
                                        <ul class="review-list">
                                            @foreach ($reviews as $review)
                                                <li>
                                                    @php
                                                        $customer = $review->customer()->first();

                                                    @endphp

                                                    <div class="review-user">
                                                        <img class="lazy"
                                                            data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_TENANT_CUSTOMER_IMAGE, $customer->image, $userBs, 'assets/tenant/img/customer.jpg') }}"
                                                            alt="user image">
                                                    </div>

                                                    <div class="review-desc">
                                                        <div class="rate mb-2">
                                                            <div class="rating" style="width:{{ $review->rating * 20 }}%">
                                                            </div>
                                                        </div>
                                                        <h6>{{ $customer->first_name . ' ' . $customer->last_name }} <span
                                                                class="review-date">
                                                                {{ date('d-m-Y', strtotime($review->updated_at)) }}</span>
                                                        </h6>

                                                        <p>{{ $review->comment }}</p>
                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                            @endif

                            @if ($status->package_rating_status == 1)
                                @guest('customer')
                                    <h4>
                                        <a
                                            href="{{ route('customer.login', [getParam(), 'redirectPath' => 'package_details']) }}">
                                            {{ $keywords['Login'] ?? __('Login') }}
                                        </a>
                                        {{ $keywords['To Give Your Review.'] ?? __('To Give Your Review.') }}
                                    </h4>
                                @endguest

                                @auth('customer')
                                    @if ($details->package->pricing_type != 'negotiable')
                                        <div class="review-form box-wrap">
                                            <h4 class="title">{{ $keywords['Give Your Review'] ?? __('Give Your Review') }}
                                            </h4>
                                            <form
                                                action="{{ route('package.store_review', [getParam(), 'id' => $details->package_id]) }}"
                                                method="POST">
                                                @csrf
                                                <div class="row">
                                                    <div class="col-12">
                                                        <div class="mb-25">
                                                            <div class="review-content">
                                                                <ul class="review-value review-1">
                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="1">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>
                                                                </ul>

                                                                <ul class="review-value review-2">
                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="2">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>

                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="2">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>
                                                                </ul>

                                                                <ul class="review-value review-3">
                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="3">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>

                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="3">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>

                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="3">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>
                                                                </ul>

                                                                <ul class="review-value review-4">
                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="4">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>

                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="4">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>

                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="4">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>

                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="4">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>
                                                                </ul>

                                                                <ul class="review-value review-5">
                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="5">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>

                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="5">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>

                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="5">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>

                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="5">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>

                                                                    <li>
                                                                        <a class="cursor-pointer" data-ratingVal="5">
                                                                            <i class="far fa-star"></i>
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <input type="hidden" id="ratingId" name="rating">

                                                    <div class="col-12">
                                                        <div class="input-wrap text-area">
                                                            <textarea placeholder="{{ $keywords['Review'] ?? __('Review') }}" name="comment">{{ old('comment') }}</textarea>
                                                            <i class="far fa-pencil"></i>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <button type="submit"
                                                            class="btn filled-btn">{{ $keywords['Submit'] ?? __('Submit') }}</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    @endif
                                @endauth
                            @endif
                        </div>
                    </div>

                    @php
                        $position = dynamicPosition($currencyInfo->base_currency_symbol_position);
                        $symbol = dynamicCurrency($currencyInfo->base_currency_symbol);
                    @endphp

                    <div class="col-lg-4">
                        <div class="packages-sidebar">
                            <div class="widget information-widget">
                                <h4 class="widget-title">{{ $keywords['Information'] ?? __('Information') }}</h4>
                                <ul class="list">
                                    @if ($details->package->pricing_type == 'negotiable')
                                        <li><strong>{{ $keywords['Price'] ?? __('Price') }}</strong>:
                                            {{ $keywords[strtoupper($details->package->pricing_type)] ?? __(strtoupper($details->package->pricing_type)) }}
                                        </li>
                                    @else
                                        <li><strong>{{ $keywords['Price'] ?? __('Price') }}</strong> :
                                            {{ $position == 'left' ? $symbol : '' }}{{ $details->package->package_price }}{{ $position == 'right' ? $symbol : '' }}
                                            ({{ $keywords[strtoupper($details->package->pricing_type)] ?? __(strtoupper($details->package->pricing_type)) }})
                                        </li>
                                    @endif
                                    <li><strong>{{ $keywords['Number of Days'] ?? __('Number of Days') }}</strong> :
                                        {{ $details->package->number_of_days }}</li>
                                    <li><strong>{{ $keywords['Maximum Persons'] ?? __('Maximum Persons') }}</strong> :
                                        {{ $details->package->max_persons != null ? $details->package->max_persons : '-' }}
                                    </li>
                                </ul>
                                @if ($packageRating->package_rating_status == 1)
                                    <div class="rate">
                                        <div class="rating" style="width:{{ $avgRating * 20 }}%"></div>
                                    </div>
                                @endif
                            </div>

                            <div
                                class="widget booking-widget {{ $details->package->pricing_type == 'negotiable' ? 'd-none' : '' }}">
                                <h4 class="widget-title">{{ $keywords['Book Package'] ?? __('Book Package') }}</h4>

                                @if (Auth::guard('customer')->check() == false && $status->package_guest_checkout_status == 1)
                                    <div class="alert alert-warning">
                                        {{ $keywords['You are now booking as a guest. if you want to log in before booking, then please'] ?? __('You are now booking as a guest. if you want to log in before booking, then please') }}
                                        <a
                                            href="{{ route('customer.login', [getParam(), 'redirectPath' => 'package_details']) }}">{{ $keywords['Click Here'] ?? __('Click Here') }}</a>
                                    </div>
                                @endif

                                <form action="{{ route('package_booking', getParam()) }}" method="POST"
                                    enctype="multipart/form-data" id="web-payment">
                                    @csrf
                                    <input type="hidden" name="package_id" value="{{ $details->package_id }}">

                                    <div class="form_group">
                                        @guest('customer')
                                            <input type="text"
                                                placeholder="{{ $keywords['Full Name'] ?? __('Full Name') }}"
                                                name="customer_name" value="{{ old('customer_name') }}" required>
                                        @endguest

                                        @auth('customer')
                                            @php
                                                if (
                                                    !empty(Auth::guard('customer')->user()->first_name) ||
                                                    !empty(Auth::guard('customer')->user()->last_name)
                                                ) {
                                                    $fname =
                                                        Auth::guard('customer')->user()->first_name .
                                                        ' ' .
                                                        Auth::guard('customer')->user()->last_name;
                                                } else {
                                                    $fname = '';
                                                }
                                            @endphp
                                            <input type="text"
                                                placeholder="{{ $keywords['Full Name'] ?? __('Full Name') }}"
                                                value="{{ old('customer_name') ?? $fname }}" name="customer_name" required>
                                        @endauth
                                        @error('customer_name')
                                            <p class="mt-2 ml-2 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="form_group">

                                        @guest('customer')
                                            <input type="text"
                                                placeholder="{{ $keywords['Phone Number'] ?? __('Phone Number') }}"
                                                name="customer_phone" value="{{ old('customer_phone') }}" required>
                                        @endguest

                                        @auth('customer')
                                            <input type="text"
                                                placeholder="{{ $keywords['Phone Number'] ?? __('Phone Number') }}"
                                                value="{{ old('customer_phone') ?? Auth::guard('customer')->user()->contact_number }}"
                                                name="customer_phone" required>
                                        @endauth
                                        @error('customer_phone')
                                            <p class="mt-2 ml-2 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="form_group">
                                        @guest('customer')
                                            <input type="email"
                                                placeholder="{{ $keywords['Email Address'] ?? __('Email Address') }}"
                                                name="customer_email" value="{{ old('customer_email') }}"
                                                value="{{ old('customer_email') }}" required>
                                        @endguest

                                        @auth('customer')
                                            <input type="email"
                                                placeholder="{{ $keywords['Email Address'] ?? __('Email Address') }}"
                                                name="customer_email" value="{{ Auth::guard('customer')->user()->email }}"
                                                value="{{ old('customer_email') }}" required>
                                        @endauth
                                        @error('customer_email')
                                            <p class="mt-2 ml-2 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="form_group">
                                        <input type="number"
                                            placeholder="{{ $keywords['Number of Visitors'] ?? __('Number of Visitors') }}"
                                            name="visitors" value="{{ old('visitors') }}" required>
                                        @error('visitors')
                                            <p class="mt-2 ml-2 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="form_group h-50">
                                        <select name="paymentType" id="payment-gateways" class="nice-select">
                                            <option selected value="">
                                                {{ $keywords['Select Payment Gateway'] ?? __('Select Payment Gateway') }}
                                            </option>
                                            @foreach ($onlineGateways as $onlineGateway)
                                                <option value="{{ $onlineGateway->keyword }}">
                                                    {{ $onlineGateway->name }}
                                                </option>
                                            @endforeach

                                            @if (!empty($offlineGateways))
                                                @foreach ($offlineGateways as $offlineGateway)
                                                    <option value="{{ $offlineGateway['id'] }}">
                                                        {{ $offlineGateway['name'] }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                        @error('paymentType')
                                            <p class="mt-1 ml-2 mb-5 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="row d-none" id="tab-stripe">
                                        <div class="col-md-12">
                                            <div class="form-group mb-3">
                                                <div id="stripe-element" class="mb-2">

                                                    <!-- A Stripe Element will be inserted here. -->
                                                </div>
                                            </div>
                                            <p class="text-danger" id="stripe-errors"></p>
                                        </div>

                                    </div>

                                    {{-- START: Authorize.net Card Details Form --}}
                                    <div class="d-none" id="tab-anet">
                                        <div class="row py-3">
                                            <div class="col-lg-6">
                                                <div class="form-group mb-3">
                                                    <input class="form-control" type="text" id="anetCardNumber"
                                                        placeholder="{{ $keywords['Card Number'] ?? __('Card Number') }}"
                                                        disabled />
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-3">
                                                <div class="form-group">
                                                    <input class="form-control" type="text" id="anetExpMonth"
                                                        placeholder="{{ $keywords['Expire Month'] ?? __('Expire Month') }}"
                                                        disabled />
                                                </div>
                                            </div>
                                            <div class="col-lg-6 ">
                                                <div class="form-group">
                                                    <input class="form-control" type="text" id="anetExpYear"
                                                        placeholder="{{ $keywords['Expire Year'] ?? __('Expire Year') }}"
                                                        disabled />
                                                </div>
                                            </div>
                                            <div class="col-lg-6 ">
                                                <div class="form-group">
                                                    <input class="form-control" type="text" id="anetCardCode"
                                                        placeholder="{{ $keywords['Card Code'] ?? __('Card Code') }}"
                                                        disabled />
                                                </div>
                                            </div>
                                            <input type="hidden" name="opaqueDataValue" id="opaqueDataValue" disabled />
                                            <input type="hidden" name="opaqueDataDescriptor" id="opaqueDataDescriptor"
                                                disabled />
                                            <ul id="anetErrors" class="dis-none"></ul>
                                        </div>
                                    </div>
                                    {{-- END: Authorize.net Card Details Form --}}

                                    <div class="d-none my-3 px-2" id="gateway-description"></div>

                                    <div class="d-none mb-3 px-2" id="gateway-instruction"></div>

                                    <div class="d-none mb-4 pl-2" id="gateway-attachment">
                                        <input type="file" name="attachment">
                                    </div>
                                    <div class="mb-2 {{ $errors->has('paymentType') ? 'mt-5' : '' }}">
                                        <div class="coupon-code-buttons">
                                            <input type="text" id="coupon-code"
                                                placeholder="{{ $keywords['Enter Your Coupon'] ?? __('Enter Your Coupon') }}">
                                            <button type="button" class="btn filled-btn" onclick="applyCoupon(event)"
                                                style="padding: 0px 15px;">
                                                {{ $keywords['Apply'] ?? __('Apply') }}
                                            </button>
                                        </div>
                                    </div>
                                    <div class="price-option-table mt-4">
                                        <ul>
                                            <li class="single-price-option">
                                                <span class="title">
                                                    {{ $keywords['Price'] ?? __('Price') }}
                                                    <span class="amount">
                                                        {{ $position == 'left' ? $symbol : '' }}
                                                        <span id="rent-price">
                                                            {{ number_format($details->package->package_price, 2) }}
                                                        </span>
                                                        {{ $position == 'right' ? $symbol : '' }}
                                                    </span>
                                                </span>
                                            </li>
                                            <li class="single-price-option">
                                                <span class="title">
                                                    {{ $keywords['Discount'] ?? __('Discount') }}
                                                    <span class="text-danger">
                                                        (<i class="fas fa-minus"></i>)
                                                    </span>
                                                    <span class="amount">
                                                        {{ $position == 'left' ? $symbol : '' }}
                                                        <span id="discount-amount">0.00</span>
                                                        {{ $position == 'right' ? $symbol : '' }}
                                                    </span>
                                                </span>
                                            </li>
                                            <li class="single-price-option">
                                                <span class="title">
                                                    {{ $keywords['Subtotal'] ?? __('Subtotal') }}
                                                    <span class="amount">
                                                        {{ $position == 'left' ? $symbol : '' }}
                                                        <span id="subtotal-amount">
                                                            {{ number_format($details->package->package_price, 2) }}
                                                        </span>
                                                        {{ $position == 'right' ? $symbol : '' }}
                                                    </span>
                                                </span>
                                            </li>
                                            @if ($userBs->package_tax_status == 1)
                                                @php
                                                    $tax =
                                                        ($details->package->package_price * $userBs->package_tax) / 100;
                                                @endphp
                                                <li class="single-price-option">
                                                    <span class="title">
                                                        {{ $keywords['Tax'] ?? __('Tax') }}
                                                        ({{ $userBs->package_tax }}%)
                                                        <span class="text-success">
                                                            (<i class="fas fa-plus"></i>)
                                                        </span>
                                                        <span class="amount">
                                                            {{ $position == 'left' ? $symbol : '' }}
                                                            <span id="tax-amount">
                                                                {{ number_format($tax, 2) }}
                                                            </span>
                                                            {{ $position == 'right' ? $symbol : '' }}
                                                        </span>
                                                    </span>
                                                </li>
                                            @endif

                                            @if ($userBs->package_fee_status == 1)
                                                <li class="single-price-option">
                                                    <span class="title">
                                                        {{ $keywords['Fee'] ?? __('Fee') }}
                                                        <span class="text-success">
                                                            (<i class="fas fa-plus"></i>)
                                                        </span>
                                                        <span class="amount">
                                                            {{ $position == 'left' ? $symbol : '' }}
                                                            <span id="fee-amount">
                                                                {{ number_format($userBs->package_fee, 2) }}
                                                            </span>
                                                            {{ $position == 'right' ? $symbol : '' }}
                                                        </span>
                                                    </span>
                                                </li>
                                            @endif

                                            <li class="single-price-option">
                                                @php
                                                    $package_fee =
                                                        $userBs->package_fee_status == 1 ? $userBs->package_fee : 0.0;
                                                    $tax_price = $userBs->package_tax_status == 1 ? $tax : 0.0;
                                                    $total =
                                                        $details->package->package_price + $package_fee + $tax_price;

                                                @endphp
                                                <span class="title">
                                                    {{ $keywords['Total'] ?? __('Total') }}
                                                    <span class="amount">
                                                        {{ $position == 'left' ? $symbol : '' }}
                                                        <span id="total-amount">
                                                            {{ number_format($total, 2) }}
                                                        </span>
                                                        {{ $position == 'right' ? $symbol : '' }}
                                                    </span>
                                                </span>
                                            </li>
                                        </ul>
                                    </div>

                                    <div class="form_group mt-4">
                                        <button class="btn filled-btn d-inline-block" id="web-payment"
                                            form="web-payment">{{ $keywords['Book Now'] ?? __('Book Now') }}</button>
                                    </div>
                                </form>
                            </div>
                            @if (!is_null($details->package->email) || !is_null($details->package->phone))
                                <div class="widget information-widget">
                                    <h4 class="widget-title">{{ $keywords['Help & Support'] ?? __('Help & Support') }}
                                    </h4>
                                    <ul class="list">
                                        @if (!is_null($details->package->phone))
                                            <li><strong>{{ $keywords['Phone'] ?? __('Phone') }}</strong>:
                                                {{ $details->package->phone }}</li>
                                        @endif
                                        @if (!is_null($details->package->email))
                                            <li><strong>{{ $keywords['Email'] ?? __('Email') }}</strong>:
                                                {{ $details->package->email }}</li>
                                        @endif
                                    </ul>
                                </div>
                            @endif

                            <div class="widget share-widget">
                                <h4 class="widget-title">
                                    {{ $keywords['Share This Package'] ?? __('Share This Package') }}</h4>
                                <ul class="social-icons">
                                    @include('user-front.common.share-socail-media')
                                </ul>
                            </div>

                            @if (count($latestPackages) > 0)
                                <div class="widget latest-package-widget">
                                    <h4 class="widget-title">
                                        {{ $keywords['Related Packages'] ?? __('Related Packages') }}
                                    </h4>

                                    @foreach ($latestPackages as $latestPackage)
                                        <div class="packages-item">
                                            <div class="post-thumbnail">
                                                <img class="lazy"
                                                    data-src="{{ asset('assets/tenant/img/packages/' . $latestPackage->package->featured_img) }}"
                                                    alt="image">
                                            </div>

                                            <div class="entry-content">
                                                <h3 class="title"><a
                                                        href="#">{{ strlen($latestPackage->title) > 45 ? mb_substr($latestPackage->title, 0, 45, 'UTF-8') . '...' : $latestPackage->title }}</a>
                                                </h3>
                                                <p>
                                                    {{ strlen(strip_tags($latestPackage->description)) > 50 ? substr(strip_tags($latestPackage->description), 0, 50) . '...' : strip_tags($latestPackage->description) }}
                                                </p>
                                                <a href="{{ route('package_details', [getParam(), 'slug' => $latestPackage->slug]) }}"
                                                    class="btn">{{ $keywords['view package'] ?? __('view package') }}</a>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    @php
        $exiting_price_show = false;
    @endphp
    @if (Session::has('package_booking_id_visitors') && !empty(old('visitors')))
        @php
            $package_booking_id_visitors = 'package_id_' . $details->package_id . '_visitors_' . old('visitors');
            if (Session::get('package_booking_id_visitors') == $package_booking_id_visitors) {
                $exiting_price_show = true;
            }
        @endphp
    @endif
@endsection

@section('script')
    <script>
        "use strict";

        var offlineGateways = {!! json_encode($offlineGateways) !!};
        var pricingType = '{{ $details->package->pricing_type }}';
        var initialPrice = '{{ $details->package->package_price }}';
        var stripe_key = "{{ $stripe_key ?? '' }}";
        var getUser = {!! getUser() !!};
        var tax_status = "{{ $userBs->package_tax_status }}";
        var package_tax = "{{ $userBs->package_tax_status == 1 ? $userBs->package_tax : 0 }}";
        var package_fee = "{{ $userBs->package_fee_status == 1 ? $userBs->package_fee : 0 }}";
    </script>

    <script src="{{ asset('assets/user-front/js/package-details.js') }}"></script>

    @php
        if (!is_null($anet->information)) {
            $anerInfo = $anet->convertAutoData();
            $anetTest = $anerInfo['sandbox_check'];

            if ($anetTest == 1) {
                $anetSrc = 'https://jstest.authorize.net/v1/Accept.js';
            } else {
                $anetSrc = 'https://js.authorize.net/v1/Accept.js';
            }
        } else {
            $anetSrc = '';
        }
    @endphp

    @if (!empty($stripe_key))
        <script src="https://js.stripe.com/v3/"></script>
    @endif
    @if (!is_null($anet->information))
        <script>
            "use strict";
            var clientKey = "{{ $anerInfo['public_key'] }}";
            var loginId = "{{ $anerInfo['login_id'] }}";
        </script>
        <script type="text/javascript" src="{{ $anetSrc }}" charset="utf-8"></script>
    @endif
    @if (!is_null($anet->information) || !empty($stripe_key))
        <script src="{{ asset('assets/tenant/js/anet_stripe.js') }}"></script>
    @endif

    @if (isset($exiting_price_show) &&  $exiting_price_show == true)
        <script>
            showExitingPrice()
        </script>
    @endif

@endsection
