 @forelse ($packageInfos as $packageInfo)
     <div class="row package-item mb-30 align-items-center">
         <figure class="package-img col-md-2 col-xs-12">
             <a href="{{ route('package_details', [getParam(), $packageInfo->slug]) }}">
                 <img class="lazy" data-src="{{ asset('assets/tenant/img/packages/' . $packageInfo->featured_img) }}"
                     alt="img">
             </a>
         </figure>

         <div class="package-details col-md-6 col-xs-12 border-right">
             <h5 class="package-title mb-2">
                 <a
                     href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}">{{ strlen($packageInfo->title) > 70 ? mb_substr($packageInfo->title, 0, 70, 'utf-8') . '...' : $packageInfo->title }}</a>
             </h5>
             <ul class="package-list-group list-unstyled">
                 @if ($packageInfo->pricing_type != 'negotiable')
                     <li><span><i
                                 class="fas fa-comment-dollar"></i><strong>{{ $keywords['Package Price'] ?? __('Package Price') }}:</strong>
                             {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}
                             {{ $packageInfo->package_price }}
                             {{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                             ({{  $keywords[strtoupper("$packageInfo->pricing_type")]  ??  __(strtoupper("$packageInfo->pricing_type"))  }})
                            </span>
                        </li>
                 @else
                     <li><span><i
                                 class="fas fa-comment-dollar"></i><strong>{{ $keywords['Package Price'] ?? __('Package Price') }}:</strong>
                             {{ $keywords['NEGOTIABLE'] ?? __('NEGOTIABLE') }}</span></li>
                 @endif

                 <li><span><i
                             class="fas fa-calendar-alt"></i><strong>{{ $keywords['Number of Days'] ?? __('Number of Days') }}:</strong>
                         {{ $packageInfo->number_of_days }}</span></li>

                 <li><span><i
                             class="fas fa-users"></i><strong>{{ $keywords['Maximum Persons'] ?? __('Maximum Persons') }}:</strong>
                         {{ $packageInfo->max_persons != null ? $packageInfo->max_persons : '-' }}</span></li>
             </ul>
         </div>

         <div class="col-md-4 col-xs-12 text-center">
             <h6 class="price">
                 @if ($packageInfo->pricing_type != 'negotiable')
                     {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}
                     {{ $packageInfo->package_price }}
                     {{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                     ({{  $keywords[strtoupper("$packageInfo->pricing_type")]  ??  __(strtoupper("$packageInfo->pricing_type"))  }}) 
                 @else
                     {{ $keywords['NEGOTIABLE'] ?? __('NEGOTIABLE') }}
                 @endif
             </h6>
             <div class="ratings d-flex justify-content-center mb-1">
                 @if ($packageRating->package_rating_status == 1)
                     @php
                         $avgRating = \App\Models\User\PackageReview::where(
                             'package_id',
                             $packageInfo->package_id,
                         )->avg('rating');
                     @endphp
                     <div class="rate">
                         <div class="rating" style="width:{{ $avgRating * 20 }}%"></div>
                     </div>
                 @endif
             </div>
             <a href="{{ route('package_details', [getParam(),'slug' => $packageInfo->slug]) }}"
                 class="btn-text">
                 {{ $keywords['View More'] ?? __('View More') }}
             </a>
         </div>
     </div>
 @empty
     <div class="row text-center">
         <div class="col py-5 bg-light">
             <h3>{{ $keywords['No Package Found!'] ?? __('No Package Found!') }}</h3>
         </div>
     </div>
 @endforelse
 <div class="row">
     <div class="col-12">
         {{ $packageInfos->appends(['packageName' => request()->input('packageName'), 'daysValue' => request()->input('daysValue'), 'personsValue' => request()->input('personsValue'), 'sortValue' => request()->input('sortValue'), 'locationName' => request()->input('locationName'), 'minPrice' => request()->input('minPrice'), 'maxPrice' => request()->input('maxPrice')])->links() }}
     </div>
 </div>
