<!DOCTYPE html>
<html @if ($currentLanguageInfo->rtl == 1) dir="rtl" @endif>

<head>
    {{-- required meta tags --}}
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <meta name="description" content="@yield('meta-description')">
    <meta name="keywords" content="@yield('meta-keywords')">


    {{-- og tag --}}
    <meta property="og:image" itemprop="image" content="@yield('og-image')">
    <meta property="og:image:type" content="image/jpg">
    <meta property="og:image:width" content="1024">
    <meta property="og:image:height" content="1024">
    <meta property="og:type" content="website">
    <meta property="og:title" content="@yield('og-title')">
    <meta property="og:description" content="@yield('og-description')">

    <link rel="canonical" href="{{ canonicalUrl() }}">
    {{-- csrf-token for ajax request --}}
    <meta name="csrf-token" content="{{ csrf_token() }}">

    {{-- title --}}
    <title>@yield('pageHeading') | {{ $userBs->website_title }}</title>

    {{-- fav icon --}}
    <link rel="shortcut icon" type="image/png" href="{{ asset('assets/tenant/img/favicon/' . $userBs->favicon) }}">

    {{-- include styles --}}
    @includeIf('user-front.common.partials.styles')

    <!------google adsense----------->
    @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
        @if (!empty($userBs->google_adsense_publisher_id))
            <script async
                src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client={{ $userBs->google_adsense_publisher_id }}"
                crossorigin="anonymous"></script>
        @endif
    @endif
    <!------google adsense----------->
    @yield('styles')
    @php
        $primaryColor = $userBs->primary_color;
        $secondaryColor = $userBs->secondary_color;

        // check, whether color has '#' or not, will return 0 or 1
        if (!function_exists('checkColorCode')) {
            function checkColorCode($color)
            {
                return preg_match('/^#[a-f0-9]{6}/i', $color);
            }
        }

        // if, primary color value does not contain '#', then add '#' before color value
        if (isset($primaryColor) && checkColorCode($primaryColor) == 0) {
            $primaryColor = '#' . $primaryColor;
        }

        if (isset($secondaryColor) && checkColorCode($secondaryColor) == 0) {
            $secondaryColor = '#' . $secondaryColor;
        }

        // change decimal point into hex value for opacity
        if (!function_exists('rgb')) {
            function rgb($color = null)
            {
                if (!$color) {
                    echo '';
                }
                $hex = htmlspecialchars($color);
                [$r, $g, $b] = sscanf($hex, '#%02x%02x%02x');
                echo "$r, $g, $b";
            }
        }
    @endphp

    <style>
        :root {
            --color-primary: {{ $primaryColor }};
            --color-primary-rgb: {{ rgb(htmlspecialchars($primaryColor)) }};
            --color-secondary: {{ $secondaryColor }};
            --color-secondary-rgb: {{ rgb(htmlspecialchars($secondaryColor)) }};
        }
    </style>
</head>

<body class="{{ $userBs->theme_version }}">
    {{-- preloader start --}}
    @if ($userBs->preloader_status == 1)
        <div class="loader" id="preLoader">
            @if ($userBs->preloader)
                <img class="lazy" data-src="{{ asset(Constant::WEBSITE_FAVICON . '/' . $userBs->preloader) }}"
                    alt="">
            @endif
        </div>
    @endif
    {{-- preloader end --}}

    {{-- header start --}}
    <header
        class="@if ($userBs->theme_version == 'theme_two') home-two
      @elseif($userBs->theme_version == 'theme_three') header-area header-1 
      @elseif($userBs->theme_version == 'theme_four') header-area header-2 
      @elseif($userBs->theme_version == 'theme_five') header-area header-3 @endif"
      @if (in_array($userBs->theme_version, ['theme_three', 'theme_four', 'theme_five']) &&  request()->routeIs('front.user.detail.view')) data-aos="fade-down" @endif>

        {{-- include header-nav --}}

        @if ($userBs->theme_version == 'theme_one')
            @includeIf('user-front.common.partials.header.header-top-v1')
            @includeIf('user-front.common.partials.header.header-nav-v1')
        @endif

        @if ($userBs->theme_version == 'theme_two')
            {{-- include header-top --}}
            @includeIf('user-front.common.partials.header.header-top-v2')
            @includeIf('user-front.common.partials.header.header-nav-v2')
        @endif

        @if ($userBs->theme_version == 'theme_three')
            {{-- include header --}}
            @includeIf('user-front.common.partials.header.header_v3')
        @endif

        @if ($userBs->theme_version == 'theme_four')
            {{-- include header --}}
            @includeIf('user-front.common.partials.header.header_v4')
        @endif

        @if ($userBs->theme_version == 'theme_five')
            {{-- include header --}}
            @includeIf('user-front.common.partials.header.header_v5')
        @endif

    </header>
    {{-- header end --}}

    @yield('content')

    {{-- back to top start --}}
  @if (in_array($userBs->theme_version, ['theme_one', 'theme_two']))
    <div class="back-top">
        <a href="#" class="back-to-top">
            <i class="far fa-angle-up"></i>
        </a>
    </div>
    @endif
     @if (in_array($userBs->theme_version, ['theme_three', 'theme_four', 'theme_five']))
    <div class="go-top"><i class="fal fa-angle-up"></i></div>
    @endif

    {{-- back to top end --}}


    {{-- include footer --}}
    @if (in_array($userBs->theme_version, ['theme_three', 'theme_four', 'theme_five']))
        @includeIf('user-front.common.partials.footer.footer_v2')
    @endif

    @if (in_array($userBs->theme_version, ['theme_one', 'theme_two']))
        @includeIf('user-front.common.partials.footer.footer')
    @endif

    {{-- Popups start --}}
    @includeif('user-front.common.partials.popups')
    {{-- Popups end --}}

    {{-- WhatsApp Chat Button --}}
    <div id="WAButton"></div>

    {{-- Cookie alert dialog start --}}
    @if (!empty($userBe) && $userBe->cookie_alert_status == 1)
        <div class="cookie">
            @include('cookie-consent::index')
        </div>
    @endif
    {{-- Cookie alert dialog end --}}

    {{-- include scripts --}}
    @includeIf('user-front.common.partials.scripts')

    {{-- additional script --}}
    @yield('script')
</body>

</html>
