 <section class="hero-banner hero-banner-2">
     <div class="container-fluid">
         <div class="swiper home-slider" id="home-slider-2">
             <div class="swiper-wrapper">
                 @forelse ($sliders as $slider)
                     <div class="swiper-slide text-center" data-aos="fade-up">
                         <div class="banner-content">
                             <h1 class="title color-white mb-25" data-animation="animate__fadeInUp" data-delay=".1s">
                                 {{ convertUtf8($slider->title) }}</h1>
                             <p class="text" data-animation="animate__fadeInUp" data-delay=".2s">
                                 {{ convertUtf8($slider->subtitle) }}</p>
                         </div>
                     </div>
                 @empty
                     <div class="swiper-slide text-center" data-aos="fade-up">
                         <div class="banner-content">
                             <h1 class="title color-white mb-25" data-animation="animate__fadeInUp" data-delay=".1s">
                                 {{ $keywords['Welcome to Hotelia'] ?? __('Welcome to Hotelia') }}

                             </h1>
                             <p class="text" data-animation="animate__fadeInUp" data-delay=".2s">
                                 {{ $keywords['Luxury Living'] ??__('Luxury Living') }}
                             </p>
                         </div>
                     </div>
                 @endforelse
             </div>
         </div>
         @if ($sections->search_section == 1)
             <div class="banner-filter-form mt-40 mx-auto" data-aos="fade-up" data-aos-delay="100">
                 <div class="form-wrapper p-30 radius-lg">
                     <form action="{{ route('packages', getparam()) }}" method="GET">
                         <div class="row align-items-center gx-xl-3">
                             <div class="col-lg-10">
                                 <div class="row">
                                     <div class="col-lg-5 col-md-3 col-sm-5">
                                         <div class="form-group border-end">
                                             <label for="location" class="font-sm">{{ $keywords['Location'] ?? __('Location') }}</label>
                                             <div class="form-block">
                                                 <div class="icon color-white"><i class="fas fa-map-marker-alt"></i>
                                                 </div>
                                                 <select class="niceselect" id="location" name="locationName">
                                                     <option selected value="">{{ $keywords['Choose Location'] ??__('Choose Location') }}
                                                     </option>
                                                     @foreach ($package_locations as $locations)
                                                         <option value="{{ $locations->name }}">{{ $locations->name }}
                                                         </option>
                                                     @endforeach
                                                 </select>
                                             </div>
                                         </div>
                                     </div>
                                     <div class="col-lg-5 col-md-3 col-sm-5">
                                         <div class="form-group border-end">
                                             <label for="guest" class="font-sm">{{ $keywords['Days'] ?? __('Days') }}</label>
                                             <div class="form-block">
                                                 <div class="icon color-white"><i class="fas fa-calendar"></i></div>
                                                 <select id="days" name="daysValue" class="niceselect">
                                                     <option selected value="">{{ $keywords['Choose Day'] ?? __('Choose Day') }}</option>
                                                     @for ($i = 0; $i < $maxDays; $i++)
                                                         <option value="{{ $i + 1 }}"
                                                             {{ request()->input('daysValue') == $i + 1 ? 'selected' : '' }}>
                                                             {{ $keywords['Up to'] ?? __('Up to') }}
                                                             {{ $i + 1 }}
                                                             {{ $i + 1 == 1 ? $keywords['Day'] ??__('Day') :  $keywords['Days'] ?? __('Days') }}</option>
                                                     @endfor
                                                 </select>
                                             </div>
                                         </div>
                                     </div>
                                     <div class="col-lg-2 col-md-2 col-sm-2">
                                         <div class="form-group">
                                             <label for="guest" class="font-sm">{{ $keywords['Persons'] ?? __('Persons') }}</label>
                                             <div class="form-block">
                                                 <div class="icon color-white"><i class="fas fa-user-friends"></i></div>
                                                 <select class="niceselect" id="guest" name="personsValue">
                                                     <option selected value="">{{ $keywords['Choose Person'] ??__('Choose Person') }}</option>
                                                     @for ($i = 1; $i <= $numOfGuest; $i++)
                                                         <option value="{{ $i }}">{{ $i }}
                                                         </option>
                                                     @endfor
                                                 </select>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                             </div>
                             <div class="col-lg-2 col-sm-3 text-end">
                                 <button type="submit" class="btn btn-icon bg-primary color-white radius-md"
                                     aria-label="Search">
                                     <i class="fal fa-search"></i>
                                 </button>
                             </div>
                         </div>
                     </form>
                 </div>
             </div>
         @endif
         <div class="swiper-pagination position-static mt-40" id="home-slider-2-pagination" data-aos="fade-up"
             data-aos-delay="100"></div>
     </div>

     @if (count($sliders) != 0)
         <div class="swiper home-img-slider" id="home-img-slider-2">
             <div class="swiper-wrapper">
                 @foreach ($sliders as $slider)
                     <div class="swiper-slide">
                         <div class="lazyload bg-img"
                             data-bg-image="{{ asset(Constant::WEBSITE_HERO_SLIDER_IMAGE .'/' . $slider->img) }}"></div>
                     </div>
                 @endforeach
             </div>
         </div>
     @else
         <div class="swiper home-img-slider" id="home-img-slider-2">
             <div class="swiper-wrapper">
                 <div class="swiper-slide">
                     <div class="lazyload bg-img"
                         data-bg-image="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_HERO_SLIDER_IMAGE, null, $userBs, 'assets/user-front/default-img/banner-slider-3.jpg') }}">
                     </div>
                 </div>
             </div>
         </div>
     @endif
 </section>
