@extends('user-front.common.layout')

@section('pageHeading')
   {{  $pageHeading->gallery_page_title ?? ($keywords['Gallery'] ?? __('Gallery')) }}
@endsection

@php
    $metaKeywords = !empty($seo->gallery_meta_keywords) ? $seo->gallery_meta_keywords : '';
    $metaDescription = !empty($seo->gallery_meta_description) ? $seo->gallery_meta_description : '';
@endphp
@section('meta-keywords', $metaKeywords)
@section('meta-description', $metaDescription)

@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $breadcrumbInfo?->breadcrumb,
            'title' =>  $pageHeading->gallery_page_title ?? ($keywords['Gallery'] ?? __('Gallery')) ,
        ])
        <!-- Breadcrumb Section End -->

        <!-- Gallery Start -->
        <section class="gallery-wrap section-padding section-bg">
            <div class="container">
                <!-- if category is null then no gallery is available -->
                @if (count($categories) == 0 || count($galleryInfos) == 0)
                    <div class="bg-white py-5">
                        <h3 class="text-center">{{ $keywords['No Gallery Found!'] ?? __('No Gallery Found!') }}</h3>
                    </div>
                @else
                    <div class="gallery-filter text-center">
                        <ul class="list-inline">
                            <li class="active" data-filter="*">{{ $keywords['Show All'] ?? __('Show All') }}</li>
                            @foreach ($categories as $category)
                                @php
                                    $filterValue = '.' . strtolower($category->name);

                                    if (str_contains($filterValue, ' ')) {
                                        $filterValue = str_replace(' ', '-', $filterValue);
                                    }
                                @endphp

                                <li data-filter="{{ $filterValue }}">{{ convertUtf8($category->name) }}</li>
                            @endforeach
                        </ul>
                    </div>

                    <div class="gallery-items">
                        <div class="row gallery-filter-items">
                            @foreach ($galleryInfos as $galleryInfo)
                                <!-- Single Item -->
                                @php
                                    $galleryCategory = $galleryInfo->galleryCategory()->first();
                                    $categoryName = strtolower($galleryCategory->name);

                                    if (str_contains($categoryName, ' ')) {
                                        $categoryName = str_replace(' ', '-', $categoryName);
                                    }
                                @endphp

                                <div class="col-lg-4 col-md-6 col-sm-6 {{ $categoryName }}">
                                    <a class="gallery-item lazy bg-light d-block"
                                        href="{{ asset('assets/tenant/img/gallery-image/' . $galleryInfo->gallery_img) }}"
                                        data-bg="{{ asset('assets/tenant/img/gallery-image/' . $galleryInfo->gallery_img) }}">
                                        <div class="gallery-content">
                                            <h3>{{ convertUtf8($galleryInfo->title) }}</h3>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                        {{-- Ads Section --}}
                        @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
                            @if (!empty(showAd(3)))
                                <div class="d-flex justify-content-center align-items-center mt-0">
                                    {!! showAd(3) !!}
                                </div>
                            @endif
                        @endif
                    </div>
                @endif
            </div>
        </section>
        <!-- Gallery End -->
    </main>
@endsection
