@extends('user-front.common.layout')

@section('pageHeading')
    {{ $pageHeading->faq_page_title ?? ($keywords['FAQ'] ?? __('FAQ')) }}
@endsection

@php
    $metaKeywords = !empty($seo->faqs_meta_keywords) ? $seo->faqs_meta_keywords : '';
    $metaDescription = !empty($seo->faqs_meta_description) ? $seo->faqs_meta_description : '';
@endphp
@section('meta-keywords', $metaKeywords)
@section('meta-description', $metaDescription)

@section('content')
    <!-- Breadcrumb Section Start -->
    @includeIf('user-front.common.partials.breadcrumb', [
        'breadcrumb' => $breadcrumbInfo?->breadcrumb,
        'title' => $pageHeading->faq_page_title ?? ($keywords['FAQ'] ?? __('FAQ')),
    ])
    <!-- Breadcrumb Section End -->

    <!-- FAQ Start -->
    <section class="wcu-section section-padding section-bg">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 {{ count($faqs) == 0 ? 'col-lg-12' : '' }}">
                    <!-- Section Title -->
                    <div class="section-title">
                        @if (!is_null($secHeading))
                            <span class="title-top">{{ convertUtf8($secHeading->faq_section_title) }}</span>
                            <h1>{{ convertUtf8($secHeading->faq_section_subtitle) }}</h1>
                        @endif
                    </div>
                    @if (count($faqs) == 0)
                        <div class="bg-white py-5 mb-5">
                            <h3 class="text-center">{{ $keywords['No FAQ Found!'] ?? __('No FAQ Found!') }}</h3>
                        </div>
                    @else
                        <div class="feature-accordion accordion" id="faqAccordion">
                            @foreach ($faqs as $faq)
                                <div class="card">
                                    <div class="card-header">
                                        <button type="button" class="{{ $loop->first ? 'active-accordion' : '' }}"
                                            data-bs-toggle="collapse" data-bs-target="{{ '#faq' . $faq->id }}">
                                            {{ $faq->question }}
                                            <span class="open-icon"><i class="far fa-eye-slash"></i></span>
                                            <span class="close-icon"><i class="far fa-eye"></i></span>
                                        </button>
                                    </div>

                                    <div id="{{ 'faq' . $faq->id }}" class="collapse {{ $loop->first ? 'show' : '' }}"
                                        data-bs-parent="#faqAccordion">
                                        <div class="card-body">{{ $faq->answer }}</div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>

                <div class="col-lg-6">
                    @if (!empty($secHeading->faq_section_image))
                        <div class="feature-accordion-img text-right">
                            @if (!is_null($secHeading))
                                <img class="lazy"
                                    data-src="{{ asset('assets/tenant/img/faq_section/' . $secHeading->faq_section_image) }}"
                                    alt="image">
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ End -->

    {{-- Ads Section --}}
    @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
        @if (!empty(showAd(3)))
            <div class="d-flex justify-content-center align-items-center mt-0 mb-3">
                {!! showAd(3) !!}
            </div>
        @endif
    @endif

@endsection
