        @extends('user-front.common.layout')

        @section('pageHeading')
          {{ $pageHeading->edit_profile_page_title ?? ($keywords['Edit Profile'] ?? __('Edit Profile')) }}
        @endsection

        @php
          $metaKeys = !empty($seo->home_meta_keywords) ? $seo->home_meta_keywords : '';
          $metaDesc = !empty($seo->home_meta_description) ? $seo->home_meta_description : '';
        @endphp

        @section('meta-keywords', "$metaKeys")
        @section('meta-description', "$metaDesc")

        @section('content')
          <!-- Breadcrumb Section Start -->
          @includeIf('user-front.common.partials.breadcrumb', [
              'breadcrumb' => $bgImg->breadcrumb,
              'title' =>
                  $pageHeading->edit_profile_page_title ?? ($keywords['Edit Profile'] ?? __('Edit Profile')),
          ])
          <!-- Breadcrumb Section End -->

          <!-- Start User Edit-Profile Section -->
          <section class="user-dashboard section-bg">
            <div class="container">
              <div class="row">
                @includeIf('user-front.common.customer.common.side-navbar')

                <div class="col-lg-9">
                  <div class="row">
                    <div class="col-lg-12">
                      <div class="user-profile-details bg-white">
                        <div class="account-info">
                          <div class="title">
                            <h4>{{ $keywords['Edit Profile'] ?? __('Edit Profile') }}</h4>
                          </div>

                          <div class="edit-info-area">
                            <form action="{{ route('customer.update_profile', getParam()) }}" method="POST"
                              enctype="multipart/form-data">
                              @csrf
                              <div class="upload-img">
                                <div class="file-upload-area">
                                  <div class="file-edit">
                                    <input type='file' id="imageUpload" name="image">
                                    <label for="imageUpload"></label>
                                  </div>
                                  <div class="file-preview showImage">
                                    <div id="imagePreview">
                                      <img class="lazyload img-to-bg"
                                        src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_TENANT_CUSTOMER_IMAGE, $authUser->image, $userBs, 'assets/tenant/img/customer.jpg') }}">
                                    </div>
                                  </div>
                                </div>
                                <div id="errorMsg"></div>
                              </div>


                              @error('image')
                                <p class="mb-3 text-danger">{{ $message }}</p>
                              @enderror

                              <div class="row">
                                <div class="col-lg-6">
                                  <input type="text" class="form_control"
                                    placeholder="{{ $keywords['First Name'] ?? __('First Name') }}" name="first_name"
                                    value="{{ $authUser->first_name }}">
                                  @error('first_name')
                                    <p class="mb-3 text-danger">{{ $message }}</p>
                                  @enderror
                                </div>

                                <div class="col-lg-6">
                                  <input type="text" class="form_control"
                                    placeholder="{{ $keywords['Last Name'] ?? __('Last Name') }}" name="last_name"
                                    value="{{ $authUser->last_name }}">
                                  @error('last_name')
                                    <p class="mb-3 text-danger">{{ $message }}</p>
                                  @enderror
                                </div>

                                <div class="col-lg-6">
                                  <input type="email" class="form_control"
                                    placeholder="{{ $keywords['Email'] ?? __('Email') }}" value="{{ $authUser->email }}"
                                    readonly>
                                </div>

                                <div class="col-lg-6">
                                  <input type="text" class="form_control"
                                    placeholder="{{ $keywords['Contact Number'] ?? __('Contact Number') }}"
                                    name="contact_number" value="{{ $authUser->contact_number }}">
                                  @error('contact_number')
                                    <p class="mb-3 text-danger">{{ $message }}</p>
                                  @enderror
                                </div>

                                <div class="col-lg-6">
                                  <input type="text" class="form_control"
                                    placeholder="{{ $keywords['City'] ?? __('City') }}" name="city"
                                    value="{{ $authUser->city }}">
                                  @error('city')
                                    <p class="mb-3 text-danger">{{ $message }}</p>
                                  @enderror
                                </div>

                                <div class="col-lg-6">
                                  <input type="text" class="form_control"
                                    placeholder="{{ $keywords['State'] ?? __('State') }}" name="state"
                                    value="{{ $authUser->state }}">
                                </div>

                                <div class="col-lg-6">
                                  <textarea class="form_control" placeholder="{{ $keywords['Address'] ?? __('Address') }}" name="address">{{ $authUser->address }}</textarea>
                                  @error('address')
                                    <p class="mb-3 text-danger">{{ $message }}</p>
                                  @enderror
                                </div>

                                <div class="col-lg-6">
                                  <input type="text" class="form_control"
                                    placeholder="{{ $keywords['Country'] ?? __('Country') }}" name="country"
                                    value="{{ $authUser->country }}">
                                  @error('country')
                                    <p class="mb-3 text-danger">{{ $message }}</p>
                                  @enderror
                                </div>



                                <div class="col-lg-12">
                                  <div class="form-button">
                                    <button
                                      class="theme-btn">{{ $keywords['Update Profile'] ?? __('Update Profile') }}</button>
                                  </div>
                                </div>
                              </div>
                            </form>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>
          <!-- End User Edit-Profile Section -->
        @endsection
