@extends('user-front.common.layout')

@section('pageHeading')
  {{ $pageHeading->dashboard_page_title ?? ($keywords['Dashboard'] ?? __('Dashboard')) }}
@endsection

@php
  $metaKeys = !empty($seo->home_meta_keywords) ? $seo->home_meta_keywords : '';
  $metaDesc = !empty($seo->home_meta_description) ? $seo->home_meta_description : '';
@endphp

@section('meta-keywords', "$metaKeys")
@section('meta-description', "$metaDesc")


@section('content')
  @includeIf('user-front.common.partials.breadcrumb', [
      'breadcrumb' => $bgImg->breadcrumb,
      'title' => $pageHeading->dashboard_page_title ?? ($keywords['Dashboard'] ?? __('Dashboard')),
  ])

  <!-- Start User Dashboard Section -->
  <section class="user-dashboard section-bg">
    <div class="container">
      <div class="row">
        @includeIf('user-front.common.customer.common.side-navbar')

        <div class="col-lg-9">
          <div class="row">
            <div class="col-lg-12">
              <div class="user-profile-details bg-white mb-30">
                <div class="account-info">
                  <div class="title">
                    <h4>{{ $keywords['Account Information'] ?? __('Account Information') }}</h4>
                  </div>

                  <div class="main-info">
                    <ul class="list">
                      @if ($authUser->first_name != null && $authUser->last_name != null)
                        <li><strong>{{ $keywords['Name'] ?? __('Name') }} {{ ':' }}</strong></li>
                      @endif

                      <li><strong>{{ $keywords['Username'] ?? __('Username') }} {{ ':' }}</strong></li>

                      <li><strong>{{ $keywords['Email'] ?? __('Email') }} {{ ':' }}</strong></li>

                      @if ($authUser->contact_number != null)
                        <li><strong>{{ $keywords['Phone'] ?? __('Phone') }} {{ ':' }}</strong></li>
                      @endif

                      @if ($authUser->address != null)
                        <li><strong>{{ $keywords['Address'] ?? __('Address') }} {{ ':' }}</strong></li>
                      @endif

                      @if ($authUser->city != null)
                        <li><strong>{{ $keywords['City'] ?? __('City') }} {{ ':' }}</strong></li>
                      @endif

                      @if ($authUser->state != null)
                        <li><strong>{{ $keywords['State'] ?? __('State') }} {{ ':' }}</strong></li>
                      @endif

                      @if ($authUser->country != null)
                        <li><strong>{{ $keywords['Country'] ?? __('Country') }} {{ ':' }}</strong></li>
                      @endif
                    </ul>
                    <ul class="list">
                      @if ($authUser->first_name != null && $authUser->last_name != null)
                        <li>{{ $authUser->first_name . ' ' . $authUser->last_name }}</li>
                      @endif

                      <li>{{ $authUser->username }}</li>
                      <li>{{ $authUser->email }}</li>

                      @if ($authUser->contact_number != null)
                        <li>{{ $authUser->contact_number }}</li>
                      @endif

                      @if ($authUser->address != null)
                        <li>{{ $authUser->address }}</li>
                      @endif

                      @if ($authUser->city != null)
                        <li>{{ $authUser->city }}</li>
                      @endif

                      @if ($authUser->state != null)
                        <li>{{ $authUser->state }}</li>
                      @endif

                      @if ($authUser->country != null)
                        <li>{{ $authUser->country }}</li>
                      @endif
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-6">
              <div class="card card-box box-1 mb-3">
                <div class="card-info">
                  <h2 class="text-white mb-2"><strong>{{ $totalRoomBooking }}</strong></h2>
                  <h5>{{ $keywords['Total Room Bookings'] ?? __('Total Room Bookings') }}</h5>
                </div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="card card-box box-2">
                <div class="card-info">
                  <h2 class="text-white mb-2"><strong>{{ $totalPackageBooking }} </strong></h2>
                  <h5>{{ $keywords['Total Package Bookings'] ?? __('Total  Package Bookings') }}</h5>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- End User Dashboard Section -->
@endsection
