@extends('user-front.common.layout')

@section('pageHeading')
  {{ $pageHeading->change_password_page_title ?? ($keywords['Change Password'] ?? __('Change Password')) }}
@endsection
@php
  $metaKeys = !empty($seo->home_meta_keywords) ? $seo->home_meta_keywords : '';
  $metaDesc = !empty($seo->home_meta_description) ? $seo->home_meta_description : '';
@endphp

@section('meta-keywords', "$metaKeys")
@section('meta-description', "$metaDesc")

@section('content')
  @includeIf('user-front.common.partials.breadcrumb', [
      'breadcrumb' => $bgImg->breadcrumb,
      'title' =>
          $pageHeading->change_password_page_title ?? ($keywords['Change Password'] ?? __('Change Password')),
  ])

  <!-- Start Change Password Section -->
  <section class="user-dashboard section-bg">
    <div class="container">
      <div class="row">
        @includeIf('user-front.common.customer.common.side-navbar')

        <div class="col-lg-9">
          <div class="row">
            <div class="col-lg-12">
              <div class="user-profile-details bg-white">
                <div class="account-info">
                  <div class="title">
                    <h4>{{ $keywords['Change Password'] ?? __('Change Password') }}</h4>
                  </div>

                  <div class="edit-info-area">
                    <form action="{{ route('customer.update_password', getParam()) }}" method="POST">
                      @csrf
                      <div class="row">
                        <div class="col-lg-12">
                          <input type="password" class="form_control"
                            placeholder="{{ $keywords['Current Password'] ?? __('Current Password') }}"
                            name="current_password">
                          @error('current_password')
                            <p class="mb-3 text-danger">{{ $message }}</p>
                          @enderror
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-lg-12">
                          <input type="password" class="form_control"
                            placeholder="{{ $keywords['New Password'] ?? __('New Password') }}" name="new_password">
                          @error('new_password')
                            <p class="mb-3 text-danger">{{ $message }}</p>
                          @enderror
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-lg-12">
                          <input type="password" class="form_control"
                            placeholder="{{ $keywords['Confirm New Password'] ?? __('Confirm New Password') }}"
                            name="new_password_confirmation">
                          @error('new_password_confirmation')
                            <p class="mb-3 text-danger">{{ $message }}</p>
                          @enderror
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-lg-12">
                          <div class="form-button">
                            <button class="theme-btn">{{ $keywords['Submit'] ?? __('Submit') }}</button>
                          </div>
                        </div>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- End Change Password Section -->
@endsection
