@extends('user-front.common.layout')

@section('pageHeading')
  {{ $pageHeading->signup_page_title ?? ($keywords['Signup'] ?? __('Signup')) }}
@endsection

@php
  $metaKeys = !empty($seo->sign_up_meta_keywords) ? $seo->sign_up_meta_keywords : '';
  $metaDesc = !empty($seo->sign_up_meta_description) ? $seo->sign_up_meta_description : '';
@endphp

@section('meta-keywords', "$metaKeys")
@section('meta-description', "$metaDesc")

@section('content')
  <main>
    <!-- Breadcrumb Section Start -->
    @includeIf('user-front.common.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => $pageHeading->signup_page_title ?? ($keywords['Signup'] ?? __('Signup')),
    ])
    <!-- Breadcrumb Section End -->

    <!-- Signup Area Start -->
    <div class="user-area-section">
      <div class="container">
        <div class="row gx-lg-5 justify-content-center align-items-center">
          <div class="col-lg-6">
            <div class="user-content mt-4">
              <div class="mb-40 text-center">
                <h2 class="mb-1">{{ $userBe->signup_page_title }}</h2>
                <p>{{ $userBe->signup_page_subtitle }}</p>
              </div>
              <form action="{{ route('customer.signup_submit', getParam()) }}" method="POST">
                @csrf
                <div class="input-box">

                  <label for="username">{{ $keywords['Username'] ?? __('Username') }} <span>**</span></label>
                  <div class="form-group">
                    <input type="text" name="username" id="username" placeholder="{{ $keywords['Username'] ?? __('Username') }}"
                      value="{{ old('username') }}">
                    <span class="icon">
                      <i class="fal fa-user"></i>
                    </span>
                  </div>
                  @error('username')
                    <p class="mt-1 ml-2 text-danger">{{ $message }}</p>
                  @enderror
                </div>

                <div class="input-box">
                  <label for="email">{{ $keywords['Email Address'] ?? __('Email Address') }} <span>**</span> </label>
                  <div class="form-group">
                    <input type="email" id="email" name="email" placeholder="{{ $keywords['Email Address'] ?? __('Email Address') }}"
                      value="{{ old('email') }}">
                    <span class="icon">
                      <i class="fal fa-envelope"></i>
                    </span>
                  </div>
                  @error('email')
                    <p class="mt-1 ml-2 text-danger">{{ $message }}</p>
                  @enderror
                </div>

                <div class="input-box">
                  <label for="password">{{ $keywords['Password'] ?? __('Password') }} <span>**</span> </label>
                  <div class="form-group">
                    <input type="password" id="password" placeholder="" name="password"
                      value="{{ old('password') }}">
                    <span class="icon">
                      <i class="fal fa-lock"></i>
                    </span>
                    <span class="show-password-field" toggle="#password">
                      <i class="show-icon"></i>
                    </span>
                  </div>
                  @error('password')
                    <p class="mt-1 ml-2 text-danger">{{ $message }}</p>
                  @enderror
                </div>

                <div class="input-box">
                  <label for="confirm-password">{{ $keywords['Confirm Password'] ?? __('Confirm Password') }}
                    <span>**</span> </label>
                  <div class="form-group">
                    <input type="password" id="confirm-password" name="password_confirmation"
                      placeholder="" value="{{ old('password_confirmation') }}">
                    <span class="icon">
                      <i class="fal fa-lock"></i>
                    </span>
                    <span class="show-password-field" toggle="#password">
                      <i class="show-icon"></i>
                    </span>
                  </div>
                  @error('password_confirmation')
                    <p class="mt-1 ml-2 text-danger">{{ $message }}</p>
                  @enderror
                </div>

                @if ($userBs->google_recaptcha_status == 1)
                  <div class="d-block mb-4">
                    {!! NoCaptcha::renderJs() !!}
                    {!! NoCaptcha::display() !!}
                    @if ($errors->has('g-recaptcha-response'))
                      @php
                        $errmsg = $errors->first('g-recaptcha-response');
                      @endphp
                      <p class="text-danger mb-0 mt-2">{{ __("$errmsg") }}</p>
                    @endif
                  </div>
                @endif

                <button type="submit"
                  class="btn w-100 theme-btn">{{ $keywords['Signup'] ?? __('Sign Up') }}</button>
              </form>
              <div class="d-block mt-3 mb-4">
                <p class="text-center">
                  {{ $keywords['Already Have A Account?'] ?? __('Already Have A Account?') }}
                  <strong>
                    <a href="{{ route('customer.login', getParam()) }}">
                      {{ $keywords['Login'] ?? __('Login') }}</a>
                  </strong>
                </p>
              </div>
            </div>
          </div>

          <div class="col-lg-6">
            <div class="image">
              <img class="lazy"
                data-src="{{ !empty($userBe->signup_page_image) ? asset('assets/tenant/img/' . $userBe->signup_page_image) : asset('assets/user-front/img/login.svg') }}"
                alt="">
            </div>
          </div>

        </div>
      </div>
    </div>
    <!-- Signup Area End -->
  </main>
@endsection
