@extends('user-front.common.layout')

@section('pageHeading')
  {{ $pageHeading->reset_password_page_title ?? ($keywords['Reset Password'] ?? __('Reset Password')) }}
@endsection

@section('content')
  @includeIf('user-front.common.partials.breadcrumb', [
      'breadcrumb' => $bgImg->breadcrumb,
      'title' => $pageHeading->reset_password_page_title ?? ($keywords['Reset Password'] ?? __('Reset Password')),
  ])

  <!--====== Reset Password Part Start ======-->
  <div class="user-area-section pt-120 pb-120">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-6">
          <div class="user-content">
            <form action="{{ route('customer.reset_password_submit', getParam()) }}" method="POST">
              @csrf
              <input type="hidden" name="pass_token" value="{{ request('pass_token') }}">
              <div class="input-box">
                <label>{{ $keywords['password'] ?? __('Password') }} <span>**</span></label>
                <input type="password" class="form_control" name="password">
                @error('password')
                  <p class="text-danger mb-3">{{ $message }}</p>
                @enderror
              </div>

              <div class="input-box">
                <button type="submit" class="btn btn-dark">{{ $keywords['Submit'] ?? __('Submit') }}</button>
              </div>
            </form>
          </div>
        </div>
        <div class="col-lg-6">

        </div>
      </div>
    </div>
  </div>
  <!--====== Reset Password Part End ======-->
@endsection
