@extends('user-front.common.layout')

@section('pageHeading')
  {{ $pageHeading->login_page_title ?? ($keywords['Login'] ?? __('Login')) }}
@endsection

@php
  $metaKeys = !empty($seo->login_meta_keywords) ? $seo->login_meta_keywords : '';
  $metaDesc = !empty($seo->login_meta_description) ? $seo->login_meta_description : '';
@endphp

@section('meta-keywords', "$metaKeys")
@section('meta-description', "$metaDesc")

@section('content')
  <main>
    <!-- Breadcrumb Section Start -->
    @includeIf('user-front.common.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => $pageHeading->login_page_title ?? ($keywords['Login'] ?? __('Login')),
    ])
    <!-- Breadcrumb Section End -->

    <div class="user-area-section">
      <div class="container">
        <div class="row gx-lg-5 justify-content-center align-items-center">
          <div class="col-lg-6">

            <div class="user-content">
              <div class="mb-40 text-center">
                <h2 class="mb-1">{{ $userBe->login_page_title }}</h2>
                <p>{{ $userBe->login_page_subtitle }}</p>
              </div>
              <form action="{{ route('customer.login_submit', getParam()) }}" method="POST">
                @csrf
                <div class="input-box">
                  <label>{{ $keywords['Email Address'] ?? __('Email Address') }} <span>**</span></label>
                  <div class="form-group">
                    <input type="email" name="email"
                      placeholder="{{ $keywords['Email Address'] ?? __('Email Address') }}" value="{{ old('email') }}">
                    <span class="icon">
                      <i class="fal fa-envelope"></i>
                    </span>
                  </div>
                  @error('email')
                    <p class="mt-1 ml-2 text-danger">{{ $message }}</p>
                  @enderror
                </div>
                <input type="hidden" name="user_id" value="{{ $user->id }}">
                <div class="input-box">
                  <label>{{ $keywords['Password'] ?? __('Password') }} <span>**</span></label>
                  <div class="form-group">
                    <input type="password" name="password" placeholder=""
                      id="password" value="{{ old('password') }}">
                    <span class="icon">
                      <i class="fal fa-lock"></i>
                    </span>
                    <span class="show-password-field" toggle="#password">
                      <i class="show-icon"></i>
                    </span>
                  </div>

                  @error('password')
                    <p class="mt-1 ml-2 text-danger">{{ $message }}</p>
                  @enderror
                </div>

                <div class="mb-30 d-flex gap-10 align-items-center flex-wrap justify-content-between">
                  @if ($userBs->google_recaptcha_status == 1)
                    <div class="d-inline-block">
                      {!! NoCaptcha::renderJs() !!}
                      {!! NoCaptcha::display() !!}
                      @if ($errors->has('g-recaptcha-response'))
                        @php
                          $errmsg = $errors->first('g-recaptcha-response');
                        @endphp
                        <p class="text-danger mb-0 mt-1">{{ __("$errmsg") }}</p>
                      @endif
                    </div>
                  @endif
  
                  <div >
                    <a href="{{ route('customer.forget_password', getParam()) }}">
                      {{ $keywords['Lost your password?'] ?? __('Lost your password?') }}
                    </a>
                  </div>
                </div>
                <button type="submit" class="btn w-100 theme-btn">
                  {{ $keywords['Login'] ?? __('Login') }}
                </button>
                <div class="underline position-relative"><span>{{ $keywords['OR'] ?? __('OR') }}</span></div>
                @if ($userBs->google_login_status == 1)
                  <div class="social-logins">
                    <div class="btn-group btn-group-toggle d-flex">
                      <a class="btn py-2 google-login-btn" href="{{ route('customer.google_login', getParam()) }}">
                        <i class="fab fa-google {{ $currentLanguageInfo->direction == 0 ? 'me-2' : 'ml-2' }}"></i>
                        {{ $keywords['Login via Google'] ?? __('Login via Google') }}
                      </a>
                    </div>
                  </div>
                @endif
              </form>
              <div class="d-block mt-3 mb-4">
                <p class="text-center">{{ $keywords['Don’t Have An Account?'] ?? __('Don’t Have An Account?') }} <strong>
                    <a href="{{ route('customer.signup', getParam()) }}">
                      {{ $keywords['Create'] ?? __('Create') }}</a>
                  </strong>
                </p>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="image">
              <img class="lazy"
                data-src="{{ !empty($userBe->login_page_image) ? asset('assets/tenant/img/' . $userBe->login_page_image) : asset('assets/user-front/img/login-2.svg') }}"
                alt="">
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>
@endsection
