@extends('user-front.common.layout')

@section('pageHeading')
    {{ $pageHeading->forget_password_page_title ?? ($keywords['Forget Password'] ?? __('Forget Password')) }}
@endsection

@php
    $metaKeywords = !empty($seo->forget_password_meta_keywords) ? $seo->forget_password_meta_keywords : '';
    $metaDescription = !empty($seo->forget_password_meta_description) ? $seo->forget_password_meta_description : '';
@endphp
@section('meta-keywords', $metaKeywords)
@section('meta-description', $metaDescription)

@section('content')
    @includeIf('user-front.common.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => $pageHeading->forget_password_page_title ?? ($keywords['Forget Password'] ?? __('Forget Password')),
    ])

    <!--====== Forget Password Part Start ======-->
    <div class="user-area-section pt-120 pb-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="user-content">
                        <form action="{{ route('customer.mail_for_forget_password', getParam()) }}" method="POST">
                            @csrf
                            <div class="input-box">
                                <label>{{ $keywords['Email Address'] ?? __('Email Address') }} {{ '**' }}</label>
                                <input type="email" class="form_control" name="email" value="{{ old('email') }}">
                                @error('email')
                                    <p class="text-danger mb-3">{{ $message }}</p>
                                @enderror
                            </div>

                            @if ($userBs->google_recaptcha_status == 1)
                                <div class="d-block mb-4">
                                    {!! NoCaptcha::renderJs() !!}
                                    {!! NoCaptcha::display() !!}
                                    @if ($errors->has('g-recaptcha-response'))
                                        @php
                                            $errmsg = $errors->first('g-recaptcha-response');
                                        @endphp
                                        <p class="text-danger mb-0 mt-2">{{ __("$errmsg") }}</p>
                                    @endif
                                </div>
                            @endif

                            <div class="input-box">
                                <button type="submit" class="btn btn-dark">
                                  {{ $keywords['Submit'] ?? __('Submit') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--====== Forget Password Part End ======-->
@endsection
