@extends('user-front.common.layout')

@section('pageHeading')
        {{ $pageHeading->contact_page_title ?? ($keywords['Contact'] ?? __('Contact')) }}
@endsection
@php
    $metaKeywords = !empty($seo->contact_meta_keywords) ? $seo->contact_meta_keywords : '';
    $metaDescription = !empty($seo->contact_meta_description) ? $seo->contact_meta_description : '';
@endphp
@section('meta-keywords', $metaKeywords)
@section('meta-description', $metaDescription)

@section('og-title', Str::limit(convertUtf8($pageHeading?->contact_page_title), 70))

@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $breadcrumbInfo?->breadcrumb,
            'title' => $pageHeading->contact_page_title ?? ($keywords['Contact'] ?? __('Contact')),
        ])
        <!-- Breadcrumb Section End -->

        <!-- Contact Information Start -->

        @if(!empty($userBs->address) || !empty($userBs->support_email) || !empty($userBs->support_contact)  )
        <section class="contact-info-section">
            <div class="container">
                <div class="contact-info-boxes">
                    <div class="row">
                        @if (!empty($userBs->address))
                            <div class="col-lg-4 col-md-6">
                                <div class="contact-info-box">
                                    <div class="contact-icon">
                                        <i class="far fa-map-marker-alt"></i>
                                    </div>
                                    <h4>{{ $keywords['Address'] ?? __('Address') }}</h4>
                                    <p>{{ $userBs->address }}</p>
                                </div>
                            </div>
                        @endif

                        @if (!empty($userBs->support_email))
                            <div class="col-lg-4 col-md-6">
                                <div class="contact-info-box">
                                    <div class="contact-icon">
                                        <i class="far fa-envelope-open"></i>
                                    </div>
                                    <h4>{{ $keywords['Email'] ?? __('Email') }}</h4>
                                    <p>{{ $userBs->support_email }}</p>
                                </div>
                            </div>
                        @endif

                        @if (!empty($userBs->support_contact))
                            <div class="col-lg-4 col-md-6 mx-auto">
                                <div class="contact-info-box">
                                    <div class="contact-icon">
                                        <i class="far fa-phone"></i>
                                    </div>
                                    <h4>{{ $keywords['Phone'] ?? __('Phone') }}</h4>
                                    <p>{{ $userBs->support_contact }}</p>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </section>
        @endif
        <!-- Contact Information End -->

        <!-- Send Mail Form Start -->
        @if ($sections->testimonials_section == 1)
        <section class="contact-form pt-60 pb-100">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-10">
                        <div class="contact-form-wrap">
                            <h2 class="form-title">{{ $keywords['Send A Message'] ?? __('Send A Message') }}</h2>
                            <form action="{{ route('contact.send_mail', getParam()) }}" method="POST">
                                @csrf
                                <div class="row">
                                    <div class="col-md-4 col-12">
                                        <div class="mb-4">
                                            <div class="input-wrap mb-0">
                                                <input type="text" placeholder="{{ $keywords['Full Name'] ?? __('Full Name') }}"
                                                    name="full_name">
                                                <i class="far fa-user-alt"></i>
                                            </div>
                                            @error('full_name')
                                                <p class="mb-0 ml-3 text-danger">{{ $message }}</p>
                                            @enderror
                                        </div>
                                    </div>
        
                                    <div class="col-md-4 col-12">
                                        <div class="mb-4">
                                            <div class="input-wrap mb-0">
                                                <input type="email"
                                                    placeholder="{{ $keywords['Email Address'] ?? __('Email Address') }}"
                                                    name="email">
                                                <i class="far fa-envelope"></i>
                                            </div>
                                            @error('email')
                                                <p class="mb-0 ml-3 text-danger">{{ $message }}</p>
                                            @enderror
                                        </div>
                                    </div>
        
                                    <div class="col-md-4 col-12">
                                        <div class="mb-4">
                                            <div class="input-wrap mb-0">
                                                <input type="text"
                                                    placeholder="{{ $keywords['Email Subject'] ?? __('Email Subject') }}"
                                                    name="subject">
                                                <i class="far fa-pencil"></i>
                                            </div>
                                            @error('subject')
                                                <p class="mb-0 ml-3 text-danger">{{ $message }}</p>
                                            @enderror
                                        </div>
                                    </div>
        
                                    <div class="col-12">
                                        <div class="mb-4">
                                            <div class="input-wrap mb-0 text-area">
                                                <textarea placeholder="{{ $keywords['Write Message'] ?? __('Write Message') }}" name="message"></textarea>
                                                <i class="fas fa-paper-plane"></i>
                                            </div>
                                            @error('message')
                                                <p class="mb-0 ml-3 text-danger">{{ $message }}</p>
                                            @enderror
                                        </div>
                                    </div>
        
                                    @if ($userBs->google_recaptcha_status == 1)
                                        <div class="col-12 text-center">
                                            <div class="d-block mb-4">
                                                {!! NoCaptcha::renderJs() !!}
                                                {!! NoCaptcha::display() !!}
                                                @if ($errors->has('g-recaptcha-response'))
                                                    @php
                                                        $errmsg = $errors->first('g-recaptcha-response');
                                                    @endphp
                                                    <p class="text-danger mb-0 mt-2">{{ __("$errmsg") }}</p>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
        
                                    <div class="col-12 text-center">
                                        <button type="submit" class="btn filled-btn">
                                            {{ $keywords['Send'] ?? __('Send') }} <i class="far fa-long-arrow-right"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        @endif
        <!-- Send Mail Form End -->

        <!-- Map Start -->
        @if (!empty($userBs->latitude) && !empty($userBs->longitude))
            <section class="contact-map">
                <iframe width="100%" height="500" frameborder="0" scrolling="no" marginheight="0" marginwidth="0"
                    src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q={{ $userBs->latitude }},%20{{ $userBs->longitude }}+(My%20Business%20Name)&amp;t=&amp;z=10&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
            </section>
        @endif
        <!-- Map End -->

        {{-- Ads Section --}}
        @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
            @if (!empty(showAd(3)))
                <div class="d-flex justify-content-center align-items-center mt-4 mb-3">
                    {!! showAd(3) !!}
                </div>
            @endif
        @endif
    </main>
@endsection
