@extends('user-front.common.layout')

@section('pageHeading')
{{ $keywords['Blog'] ?? __('Blog') }}
@endsection

@php
  $metaKeywords = !empty($seo->blogs_meta_keywords) ? $seo->blogs_meta_keywords : '';
  $metaDescription = !empty($seo->blogs_meta_description) ? $seo->blogs_meta_description : '';
@endphp
@section('meta-keywords', "$metaKeywords")
@section('meta-description', "$metaDescription")

@section('content')
  <main>
    <!-- Breadcrumb Section Start -->
    @includeIf('user-front.common.partials.breadcrumb', ['breadcrumb' => $breadcrumbInfo?->breadcrumb, 'title' =>$pageHeading?->blog_page_title ])
    <!-- Breadcrumb Section End -->

    <!-- All Blogs Section Start -->
    
    <section class="blog-wrapper section-padding section-bg">
      <div class="container">
        <div class="row">
          <div class="col-lg-8">
            @if (count($blogInfos) == 0)
                <div class="bg-white py-5">
                    <h3 class="text-center">{{ $keywords['No Post Found!'] ?? __('No Post Found!') }}</h3>
                </div>
            @else
              <div class="post-loop">
                @foreach ($blogInfos as $blogInfo)
                {{-- @dd($blogInfo) --}}
                  <!-- Single Blog -->
                  <div class="single-blog-wrap">
                    <div class="post-thumbnail">
                      <img class="lazy" data-src="{{ asset('assets/tenant/img/blogs/' . $blogInfo->image) }}" alt="image">
                    </div>

                    <div class="post-desc">
                      <ul class="blog-meta list-inline">
                        @php
                          $date = \Carbon\Carbon::parse($blogInfo->created_at);
                        @endphp
                        <li><a href="#"><i class="far fa-calendar-alt"></i>{{ date_format($date, 'F d, Y') }}</a></li>
                      </ul>
                      <h3>
                        <a href="{{ route('blog_details', [getParam(),'slug' => $blogInfo->slug]) }}">{{ convertUtf8($blogInfo->title) }}</a>
                      </h3>

                      <a href="{{ route('blog_details', [getParam(), 'slug' => $blogInfo->slug]) }}" class="btn filled-btn">
                        {{$keywords['View Post'] ?? __('View Post') }} <i class="far fa-long-arrow-right"></i>
                      </a>
                    </div>
                  </div>
                @endforeach
              </div>

              <!-- Pagination Wrap -->
              {{$blogInfos->appends(['term' => request()->input('term'), 'category' => request()->input('category')])->links()}}
            @endif
          </div>

          @includeIf('user-front.common.blog.blog_sidebar')
        </div>
      </div>
    </section>
    <!-- All Blogs Section End -->
  </main>
@endsection
