<div class="col-lg-4">
    <!-- Sidebar Area -->
    <div class="sidebar-wrap">
        <div class="widget search-widget">
            <h4 class="widget-title">{{ $keywords['Search Here'] ?? __('Search Here') }}</h4>
            <form action="{{ route('blogs', getParam()) }}" method="GET">
                <input type="hidden" name="category" value="{{ request()->input('category') }}">
                <input type="text" name="term"
                    placeholder="{{ $keywords['Search By Post Title'] ?? __('Search By Post Title') }}..."
                    value="{{ request()->input('term') }}">
                <button><i class="far fa-search"></i></button>
            </form>
        </div>

        <div class="widget category-widget">
            <h4 class="widget-title">{{ $keywords['Category'] ?? __('Category') }}</h4>
            @if (count($blogCategories) == 0)
                <h4>{{ $keywords['No Post Category Found!'] ?? __('No Post Category Found!') }}</h4>
            @else
                <ul>
                    <li class="@if (empty(request()->input('category'))) active @endif"><a
                            href="{{ route('blogs', getParam()) }}">{{ $keywords['All'] ?? __('All') }}</a></li>
                    @foreach ($blogCategories as $blogCategory)
                        <li class="@if ($blogCategory->slug == request()->input('category')) active @endif"><a
                                href="{{ route('blogs', [getParam(), 'category' => $blogCategory->slug]) }}">{{ $blogCategory->name }}
                            </a></li>
                    @endforeach
                </ul>
            @endif
        </div>

        <div class="widget recent-news">
            <h4 class="widget-title">{{ $keywords['Latest Posts'] ?? __('Latest Posts') }}</h4>
            @if (count($recentBlogs) == 0)
        <h4>{{ $keywords['No Latest Post Found!'] ?? __('No Post Found !') }}</h4>
            @else
                <ul>
                    @foreach ($recentBlogs as $recentBlog)
                        <li>
                            <div class="recent-post-img">
                                <img class="lazy"
                                    data-src="{{ asset('assets/tenant/img/blogs/' . $recentBlog->image) }}"
                                    alt="image">
                            </div>
                            <div class="recent-post-desc">
                                <h6 class="lc-2">
                                    <a
                                        href="{{ route('blog_details', [getParam(),'slug' => $recentBlog->slug]) }}">
                                        {{ $recentBlog->title}}
                                    </a>
                                </h6>
                                <span
                                    class="date">{{ date_format(date_create($recentBlog->created_at), 'F d, Y') }}</span>
                            </div>
                        </li>
                    @endforeach
                </ul>
            @endif
        </div>

        {{-- Ads Section --}}
        @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
            @if (!empty(showAd(1)))
                <div class="text-center mt-0">
                    {!! showAd(1) !!}
                </div>
            @endif
        @endif

    </div>
</div>
