@extends('user-front.common.layout')

@section('pageHeading')
 {{ $keywords['Blog Details'] ?? __('Blog Details') }}
@endsection

@php
    $metaKeys = !empty($details->meta_keywords) ? $details->meta_keywords : '';
    $metaDesc = !empty($details->meta_description) ? $details->meta_description : '';
@endphp

@section('meta-keywords', $metaKeys)
@section('meta-description',$metaDesc)
@section('og-title', Str::limit(convertUtf8($details->title), 70))
@section('og-description',  Str::limit(strip_tags(replaceBaseUrl($details->content)), 200))

@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $breadcrumbInfo?->breadcrumb,
            'title' => $keywords['Post Details'] ?? __('Post Details'),
            'top_title' => convertUtf8($details->title),
        ])
        <!-- Breadcrumb Section End -->

        <section class="blog-details-wrapper section-padding section-bg">
            <div class="container">
                <div class="row">
                    <!-- Blog Details Section Start -->
                    <div class="col-lg-8">
                        <div class="post-details">
                            <div class="entry-header">
                                <div class="post-thumb">
                                    <img class="lazy"
                                        data-src="{{ asset('assets/tenant/img/blogs/' . $details->blog->image) }}"
                                        alt="image">
                                </div>
                               
                                <ul class="entry-meta list-inline">
                                    <li><a href="#"><i class="far fa-calendar-alt"></i>{{ date_format($details->blog->created_at, 'F d, Y') }}</a>
                                    </li>
                                </ul>
                                <h2 class="entry-title">{{ convertUtf8($details->title) }}</h2>
                            </div>

                            <div class="entry-content">
                                <div class="summernote-content">{!! replaceBaseUrl($details->content, 'summernote') !!}</div>
                            </div>

                            <div class="entry-footer d-flex justify-content-md-between">
                                <ul class="social-share list-inline">
                                    <li class="title">{{ $keywords['Share'] ?? __('Share') }}</li>
                                    <li><a href="//www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}"><i
                                                class="fab fa-facebook-f"></i></a></li>
                                    <li><a
                                            href="//twitter.com/intent/tweet?text=my share text&amp;url={{ urlencode(url()->current()) }}"><i
                                                class="fab fa-twitter"></i></a></li>
                                    <li><a href="//plus.google.com/share?url={{ urlencode(url()->current()) }}"><i
                                                class="fab fa-google-plus-g"></i></a></li>
                                    <li><a
                                            href="//www.linkedin.com/shareArticle?mini=true&amp;url={{ urlencode(url()->current()) }}&amp;title={{ convertUtf8($details->title) }}"><i
                                                class="fab fa-linkedin-in"></i></a></li>
                                    <li><a href="//api.whatsapp.com/send?text={{ urlencode(url()->current()) }}"
                                            class="whatsapp"><i class="fab fa-whatsapp"></i></a></li>
                                </ul>
                            </div>
                        </div>

                        <div id="disqus_thread"></div>

                    </div>
                    <!-- Blog Details Section End -->
                    @includeIf('user-front.common.blog.blog_sidebar')
                </div>
            </div>
        </section>

    </main>
@endsection

@section('scripts')
    <script>
        "use strict";
        var shortName = "{{ $userBs->disqus_shortname }}";
    </script>
    <script src="{{ asset('assets/user-front/js/blog.js') }}"></script>
@endsection
