@extends('user-front.common.layout')
@section('about_style')
    {{-- slick css --}}
    <link rel="stylesheet" href="{{ asset('assets/tenant/css/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/tenant/css/slick-theme.css') }}">
@endsection
@section('pageHeading')
        {{ $pageHeading->about_page_title ?? ($keywords['About'] ?? __('About')) }}
@endsection

@section('meta-description', !empty($seo) ? $seo->about_meta_description : '')
@section('meta-keywords', !empty($seo) ? $seo->about_meta_keywords : '')

@section('og-title', Str::limit(convertUtf8($secHeading->about_page_about_section_title), 70))
@section('og-description', Str::limit(strip_tags(replaceBaseUrl($secHeading->about_page_about_section_text)), 200))
@php
     $additional_section_status = json_decode($sections->about_additional_section_status, true);
@endphp
@section('content')
    <!-- Breadcrumb Section Start -->
    @includeIf('user-front.common.partials.breadcrumb', [
        'breadcrumb' => $breadcrumbInfo?->breadcrumb,
        'title' => $pageHeading->about_page_title ?? ($keywords['About'] ?? __('About')),
    ])
    <!-- Breadcrumb Section End -->

    @if($sections->about_info_section == 1)
    <section class="pt-100 pb-120">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="mb-30">
                        <h2 class="mb-30">{{ $secHeading->about_page_about_section_title }}</h2>
                        <p class="mb-50 fw-medium">
                            {{ $secHeading->about_page_about_section_text }}
                        </p>

                        <div class="row">
                            @foreach ($counterInfos as $counterInfo)
                                <div class="col-sm-6">
                                    <div class="rome-info-card-item mb-20">
                                        <div class="rome-info-icon mb-20">
                                            <i class="{{ $counterInfo->icon }}"></i>
                                        </div>
                                        <h3 class="mb-10">{{ $counterInfo->amount }}</h3>
                                        <span class="mb-0">{{ $counterInfo->title }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                </div>

                <div class="col-lg-6">
                    <div class="about-image">
                        <img class="ls-is-cached lazy"
                            src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_ABOUT_US_SECTION_IMAGE, $secHeading->about_page_about_section_image, $userBs, 'assets/user-front/default-img/intro-image.jpg') }}"
                            alt="about-image">
                    </div>
                </div>

            </div>
        </div>
    </section>
    @endif


    @if (count($after_about_info) > 0)
        @foreach ($after_about_info as $cusAboutInfo)
            @if (isset($additional_section_status[$cusAboutInfo->id]))
                @if ($additional_section_status[$cusAboutInfo->id] == 1)
                    @php
                        $cusAboutInfoContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusAboutInfo->id],
                        ])->first();
                    @endphp
                    @includeIf('user-front.common.about-additional-section', [
                        'data' => $cusAboutInfoContent,
                        'possition' => $cusAboutInfo->possition,
                    ]);
                @endif
            @endif
        @endforeach
    @endif

    @if($sections->about_facility_section == 1)
    <section class="">
        <div class="container">
            <div class="row gx-lg-4">
                <div class="col-lg-7">
                    <div class="about-image radius-sm mb-30">
                        <img class="ls-is-cached lazy"
                            src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FACILITY_SECTION_IMAGE, $secHeading->about_page_facility_section_image, $userBs, 'assets/user-front/default-img/facility-image.jpg') }}"
                            alt="about-image">
                    </div>
                </div>
                <div class="col-lg-5">
                    <h2 class="mb-40">{{ $secHeading->about_page_facility_section_title }}</h2>
                    <div class="about-list-item-area">
                        @foreach ($facilities as $facility)
                            <div class="about-list-item">
                                <div class="about-list-item-img">
                                    <i class="{{ $facility->facility_icon }}"></i>
                                </div>
                                <div class="content">
                                    <h3 class="mb-2">{{ $facility->facility_title }}</h3>
                                    <p class="mb-0 about-list-item-txt fw-medium">
                                        {{ $facility->facility_text }}
                                    </p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    @endif

    @if (count($after_facility) > 0)
        @foreach ($after_facility as $cusfacilitySec)
            @if (isset($additional_section_status[$cusfacilitySec->id]))
                @if ($additional_section_status[$cusfacilitySec->id] == 1)
                    @php
                        $cusfacilitySecContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusfacilitySec->id],
                        ])->first();
                        $has_testimonal = true;
                    @endphp
                    @includeIf('user-front.common.about-additional-section', [
                        'data' => $cusfacilitySecContent,
                        'possition' => $cusfacilitySec->possition,
                    ]);
                @endif
            @endif
        @endforeach
    @endif

   @if($sections->about_testimonial_section == 1)
    <section class="section-testimonial pt-120">
        <div class="container">
            <div class="row gx-50">
                <div class="col-lg-6">
                    <div class="section-heading mb-lg-40 mb-30 pe-lg-120">
                        <h2 class="mb-lg-30 mb-20 sec-title-anim">{{ $secHeading->about_page_testimonial_section_title }}
                        </h2>
                        <p class="mb-0 text-anim">{{ $secHeading->about_page_testimonial_section_text }}</p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <!-- testimonial-slide-item -->
                    @foreach ($testimonials as $testimonial)
                        <div class="testimonial-slide-item mb-30">
                            <div
                                class="testimonial-slide-header d-flex flex-wrap justify-content-between align-items-center gap-sm-30 gap-14">
                                <div class="testimonial-author-info">
                                    <div class="image">
                                        <img src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_TESTIMONIAL_CLIENT_IMAGE, $testimonial->image, $userBs, 'assets/user-front/default-img/customer.jpg') }}"
                                            alt="testimonial">
                                    </div>
                                    <div>
                                        <h6 class="small author-name font-family-inter mb-1">
                                            <a href="#">
                                                {{ $testimonial->name }}
                                            </a>
                                        </h6>
                                        <p class="mb-0 small fw-medium  designation">
                                            {{ $testimonial->designation }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="testimonial-content">
                                <img class="img-fluid quote-icon" src="{{ asset('assets/user-front/img/quote.svg') }}"
                                    alt="quote">
                                <p class="small desc fw-medium mb-0">
                                    {{ $testimonial->comment }}
                                </p>
                            </div>
                        </div>
                        @if ($loop->first)
                            @break
                        @endif
                    @endforeach

                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="testimonial-slide-style2">
                        @foreach ($testimonials as $testimonial)
                            @if ($loop->index > 0)
                                <div class="testimonial-slide-item mb-30">
                                    <div
                                        class="testimonial-slide-header d-flex flex-wrap justify-content-between align-items-center gap-sm-30 gap-14">
                                        <div class="testimonial-author-info">
                                            <div class="image">
                                                <img src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_TESTIMONIAL_CLIENT_IMAGE, $testimonial->image, $userBs, 'assets/user-front/default-img/customer.jpg') }}"
                                                    alt="testimonial">
                                            </div>
                                            <div>
                                                <h6 class="small author-name font-family-inter mb-1">
                                                    <a href="#">
                                                        {{ $testimonial->name }}
                                                    </a>
                                                </h6>
                                                <p class="mb-0 small fw-medium  designation">
                                                    {{ $testimonial->designation }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="testimonial-content">
                                        <img class="img-fluid quote-icon"
                                            src="{{ asset('assets/user-front/img/quote.svg') }}" alt="quote">
                                        <p class="small desc fw-medium mb-0">
                                            {{ $testimonial->comment }}
                                        </p>
                                    </div>
                                </div>
                            @endif
                        @endforeach

                    </div>
                </div>
            </div>
        </div>
    </section>
    @endif

    @if (count($after_testimonial) > 0)
        @foreach ($after_testimonial as $cusTestimonialSec)
            @if (isset($additional_section_status[$cusTestimonialSec->id]))
                @if ($additional_section_status[$cusTestimonialSec->id] == 1)
                    @php
                        $cusTestimonialSecContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusTestimonialSec->id],
                        ])->first();
                        $has_testimonal = true;
                    @endphp
                    @includeIf('user-front.common.about-additional-section', [
                        'data' => $cusTestimonialSecContent,
                        'possition' => $cusTestimonialSec->possition,
                    ]);
                @endif
            @endif
        @endforeach
    @endif

    {{-- Ads Section --}}
    @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
        @if (!empty(showAd(3)))
            <div class="d-flex justify-content-center align-items-center mt-0 mb-3">
                {!! showAd(3) !!}
            </div>
        @endif
    @endif

@endsection
@section('about_script')
    <script src="{{ asset('assets/tenant/js/slick.min.js') }}"></script>
@endsection
