@extends('front.layout')

@section('pagename')
  - {{ __('Pricing') }}
@endsection

@section('meta-description', !empty($seo) ? $seo->pricing_meta_description : '')
@section('meta-keywords', !empty($seo) ? $seo->pricing_meta_keywords : '')

@section('breadcrumb-title', !empty($heading) ? $heading->pricing_title : __('Pricing'))
@section('breadcrumb-link', !empty($heading) ? $heading->pricing_title : __('Pricing'))


@section('content')
  <!-- Pricing Start -->
  <section class="pricing-area pb-90 pt-90">
    <div class="container">
      <div class="row">
        @if (count($terms) > 0)
          <div class="col-12">
            @if (count($terms) > 1)
              <div class="nav-tabs-navigation text-center" data-aos="fade-up">
                <ul class="nav nav-tabs">
                  @foreach ($terms as $term)
                    <li class="nav-item">
                      <button class="nav-link {{ $loop->first ? 'active' : '' }}" data-bs-toggle="tab"
                        data-bs-target="#{{ __("$term") }}" type="button">{{ __("$term") }}</button>
                    </li>
                  @endforeach
                </ul>
              </div>
            @endif
            <div class="tab-content">
              @foreach ($terms as $term)
                <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }} " id="{{ __("$term") }}">
                  <div class="row">
                    @php
                      $packages = \App\Models\Package::where('status', '1')->where('term', strtolower($term))->get();
                    @endphp
                    @foreach ($packages as $package)
                      @php
                        $pFeatures = json_decode($package->features);

                      @endphp
                      <div class="col-md-6 col-lg-4">
                        <div class="card mb-30 {{ $package->recommended == '1' ? 'active' : '' }}" data-aos="fade-up"
                          data-aos-delay="200">
                          <div class="d-flex align-items-center">
                            <div class="icon blue"><i class="{{ $package->icon }}"></i></div>
                            <div class="label">
                              <h3>{{ $package->title }}</h3>

                              @if ($package->recommended == '1')
                                <span>{{ __('Recommended') }}</span>
                              @endif
                            </div>
                          </div>
                          <p class="text"></p>
                          <div class="d-flex align-items-center">

                            <span
                              class="price">{{ $package->price != 0 && $be->base_currency_symbol_position == 'left' ? $be->base_currency_symbol : '' }}{{ $package->price == 0 ? __('Free') : $package->price }}{{ $package->price != 0 && $be->base_currency_symbol_position == 'right' ? $be->base_currency_symbol : '' }}</span>
                            <span class="period">/ {{ __("$package->term") }}</span>


                          </div>
                          <h5>{{ __('Whats Included') }}</h5>
                          <ul class="item-list list-unstyled p-0 toggle-list" data-toggle-list="amenitiesToggle"
                            data-toggle-show="3">

                            @includeIf('front.partials.pricing.domains')
                            @includeIf('front.partials.pricing.hotel_rooms')
                            @includeIf('front.partials.pricing.tour_packages')
                            @includeIf('front.partials.pricing.languages')
                            @includeIf('front.partials.pricing.blog')
                            @includeIf('front.partials.pricing.custom_page')
                            @includeIf('front.partials.pricing.advertisement')
                            @includeIf('front.partials.pricing.support_ticket')
                            @includeIf('front.partials.pricing.qr_builder')

                          </ul>
                          <span class="show-more mb-30" data-toggle-btn="toggleListBtn"> {{ __('Show More') }}+</span>

                          <div class="d-flex align-items-center">
                            @if ($package->is_trial == '1' && $package->price != 0)
                              <a href="{{ route('front.register.view', ['status' => 'trial', 'id' => $package->id]) }}"
                                class="btn secondary-btn">{{ __('Trial') }}</a>
                            @endif
                            @if ($package->price == 0)
                              <a href="{{ route('front.register.view', ['status' => 'regular', 'id' => $package->id]) }}"
                                class="btn primary-btn">{{ __('Signup') }}</a>
                            @else
                              <a href="{{ route('front.register.view', ['status' => 'regular', 'id' => $package->id]) }}"
                                class="btn primary-btn">{{ __('Purchase') }}</a>
                            @endif
                          </div>
                        </div>
                      </div>
                    @endforeach
                  </div>
                </div>
              @endforeach
            </div>
          </div>
        @else
          <div class="bg-light text-center py-5 d-block w-100">
            <h3>{{ __('No Pricing Plan Found!') }}</h3>
          </div>

        @endif
      </div>
    </div>

  </section>
  <!-- Pricing End -->
@endsection
