@extends('front.layout')

@section('pagename')
  - {{ __('Home') }}
@endsection

@section('meta-description', !empty($seo) ? $seo->home_meta_description : '')
@section('meta-keywords', !empty($seo) ? $seo->home_meta_keywords : '')
@php
  $additional_section_status = json_decode($bs->additional_section_status, true);
@endphp
@section('content')

  <!-- Home Start-->
  @if ($bs->home_section == 1)
    <section id="home" class="home-banner"
      style="background-image: url({{ $be->hero_img ? asset('assets/front/img/' . $be->hero_img) : asset('assets/front/img/banner_1.png') }})">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-6 col-xl-8">
            <div class="content mb-30" data-aos="fade-down">
              <span class="subtitle">{{ $be->hero_section_title }}</span>
              <h1 class="title">{{ $be->hero_section_subtitle }}</h1>
              <p class="text">{{ $be->hero_section_text }}</p>
              <div class="content-botom">
                @if ($be->hero_section_button_url)
                  <a href="{{ $be->hero_section_button_url }}"
                    class="btn primary-btn anim-btn">{{ $be->hero_section_button_text }}</a>
                @endif
              </div>
            </div>
          </div>

          <div class="col-lg-6">
            <div class="home-banner-image">
              <img src="{{ $be->hero_img_right ? asset('assets/front/img/' . $be->hero_img_right) : asset('assets/front/img/banner_2.png') }}" alt="Hero Image">
            </div>
          </div>


        </div>
      </div>
    </section>
  @endif
  <!-- Home End -->

  <!-- After hero Section -->
  @if (count($after_hero) > 0)
    @foreach ($after_hero as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();

          @endphp
          {{-- @dd($cusHeroContent) --}}
          @includeIf('front.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
        @endif
      @endif
    @endforeach
  @endif

  <!-- partner Start  -->
  @if ($bs->partners_section == 1)
    <section class="sponsor pt-120">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-xl-6 col-lg-8">
            <div class="section-title text-center" data-aos="fade-up">
              <span class="subtitle">{{ $bs->partner_title }} </span>
              <h2 class="title">{{ $bs->partner_subtitle }}</span></h2>
            </div>
          </div>
          <div class="col-12">
            <div class="swiper sponsor-slider">
              <div class="swiper-wrapper text-center">
                @foreach ($partners as $partner)
                  <div class="swiper-slide">
                    <a href="{{ $partner->url }}" target="_blank" class="sponsor-single-item" data-aos="fade-up"
                      data-aos-delay="100">
                      <div class="sponsor-img">
                        <img class="lazyload lazy-image"
                          data-src="{{ asset('assets/front/img/partners/' . $partner->image) }}" alt="Sponsor">
                      </div>
                    </a>
                  </div>
                @endforeach
              </div>
              <div class="swiper-pagination" data-aos="fade-up"></div>
            </div>
          </div>
        </div>
      </div>
    </section>
  @endif
  <!-- partner End -->

  <!-- After partner Section -->
  @if (count($after_partner) > 0)
    @foreach ($after_partner as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();

          @endphp
          {{-- @dd($cusHeroContent) --}}
          @includeIf('front.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
        @endif
      @endif
    @endforeach
  @endif

  <!-- Work Process Start -->
  @if ($bs->process_section == 1)
    <section class="store-area pt-110 pb-100">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="section-title d-md-flex align-items-center justify-content-between mw-100" data-aos="fade-up"
              data-aos-delay="100">
              <h2 class="title">{{ $bs->work_process_title }}</span></h2>
            </div>
          </div>
          <div class="col-12">
            <div class="row justify-content-center">
              @foreach ($processes as $process)
                <div class="col-sm-6 col-lg-6 col-xl-3" data-aos="fade-up">
                  <div class="card store-single-item">
                    <span class="number">{{ $loop->index + 1 }}</span>
                    <div class="card-icon">
                      <i class="{{ $process->icon }}" alt="Icon"></i>
                    </div>
                    <div class="card-content">
                      <a>
                        <h3 class="card-title"> {{ $process->title }}</h3>
                      </a>
                      <p class="card-text">{{ $process->text }}</p>
                    </div>
                  </div>
                </div>
              @endforeach
            </div>
          </div>
        </div>
      </div>

    </section>
  @endif


  <!-- After work Process Section -->
  @if (count($after_work_process) > 0)
    @foreach ($after_work_process as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();

          @endphp
          @includeIf('front.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
        @endif
      @endif
    @endforeach
  @endif
  <!-- Work Process End -->

  <!-- Template Start -->
  @if ($bs->template_section == 1)
    <section class="template-area pt-120 pb-70 bg-light">
      <div class="container">

        <div class="row">
          <div class="col-12">
            <div class="section-title text-center" data-aos="fade-up">
              <span class="subtitle">{{ $bs->preview_templates_title }}</span>
              <h2 class="title"> {{ $bs->preview_templates_subtitle }}</h2>
            </div>
          </div>
          <div class="col-12">
            <div class="row justify-content-center">
              @foreach ($templates as $template)
                <div class="col-lg-4 col-sm-6" data-aos="fade-up" data-aos-delay="50">
                  <div class="card text-center mb-50">
                    <div class="card-image">
                      <a target="_blank" href="{{ detailsUrl($template) }}" class="lazy-container">
                        <img class="lazyload lazy-image"
                          data-src="{{ asset('assets/front/img/template-previews/' . $template->template_img) }}"
                          alt="Demo Image" />
                      </a>
                      <!-- hover Show -->
                      <div class="hover-show">
                        <a target="_blank" href="{{ detailsUrl($template) }}" target="_self" class="btn-icon rounded-circle"
                          title="View Details" >
                          <i class="fal fa-link"></i>
                        </a>
                      </div>
                    </div>
                    <!-- Card Title -->
                    <h3 class="card-title text-capitalize ">
                      <a target="_blank" title="Theme One" href="{{ detailsUrl($template) }}" target="_blank">
                         {{ str_replace('_',' ',@$template->basic_setting->theme_version) }}
                      </a>
                    </h3>

                  </div>
                </div>
              @endforeach
            </div>
          </div>
        </div>
      </div>
      <!-- Bg Overlay -->
      <img class="bg-overlay" src="{{ asset('assets/front/img/shadow-bg-1.png') }}" alt="Bg">
    </section>
  @endif
  <!-- Template End -->


  <!-- After Template Section -->
  @if (count($after_template) > 0)
    @foreach ($after_template as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();

          @endphp
          {{-- @dd($cusHeroContent) --}}
          @includeIf('front.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
        @endif
      @endif
    @endforeach
  @endif
  <!--  Template End -->


  <!-- Features Start -->
  @if ($bs->intro_section == 1)
    <section class="choose-area pt-120 pb-90">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-5">
            <div class="choose-content mb-30" data-aos="fade-right">
              <span class="subtitle">{{ $bs->intro_title }}</span>
              <h2 class="title">{{ $bs->intro_subtitle }}</h2>
              <p class="text">{!! nl2br($bs->intro_text) !!} </p>

              <div class="content-botom d-flex gap-3 align-items-center">
                @if ($bs->intro_section_button_url)
                  <a href="{{ $bs->intro_section_button_url }}" class="btn anim-btn primary-btn"
                    target="_blank">{{ $bs->intro_section_button_text }}
                  </a>
                @endif
                @if ($bs->intro_section_video_url)
                  <a href="{{ $bs->intro_section_video_url }}" class="btn video-btn youtube-popup">
                    <i class="fas fa-play"></i>
                  </a>
                @endif
              </div>

            </div>
          </div>
          <div class="col-lg-7">
            <div class="row">
              @foreach ($features as $feature)
                <div class="col-lg-4 col-sm-6" data-aos="fade-up">
                  <div class="card">
                    <div class="card-icon">
                      <img class="lazyload lazy-image"
                        data-src="{{ asset('assets/front/img/feature/' . $feature->icon) }}" alt="Icon">
                    </div>
                    <div class="card-content">
                      <a href="#">
                        <h6 class="card-title">{{ $feature->title }}</h6>
                      </a>
                      <p class="card-text">{{ $feature->text }}</p>
                    </div>
                  </div>
                </div>
              @endforeach
            </div>
          </div>
        </div>
      </div>

    </section>
  @endif
  <!-- Features End -->

  <!-- After Features Section -->
  @if (count($after_features) > 0)
    @foreach ($after_features as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();

          @endphp
          @includeIf('front.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
        @endif
      @endif
    @endforeach
  @endif
  <!-- End Features End -->

  <!-- Pricing Start -->
  @if ($bs->pricing_section == 1)
    <section class="pricing-area pb-90">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="section-title text-center" data-aos="fade-up">
              <span class="subtitle">{{ $bs->pricing_title }}</span>
              <h2 class="title">{{ $bs->pricing_subtitle }}</h2>
            </div>
          </div>
          <div class="col-12">
            @if (count($terms) > 1)
              <div class="nav-tabs-navigation text-center" data-aos="fade-up">
                <ul class="nav nav-tabs">
                  @foreach ($terms as $term)
                    <li class="nav-item">
                      <button class="nav-link {{ $loop->first ? 'active' : '' }}" data-bs-toggle="tab"
                        data-bs-target="#{{ __("$term") }}" type="button">{{ __("$term") }}</button>
                    </li>
                  @endforeach
                </ul>
              </div>
            @endif
            <div class="tab-content">
              @foreach ($terms as $term)
                <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }} " id="{{ __("$term") }}">
                  <div class="row">
                    @php
                      $packages = \App\Models\Package::where('status', '1')
                          ->where('featured', '1')
                          ->where('term', strtolower($term))
                          ->get();
                    @endphp
                    @foreach ($packages as $package)
                      @php
                        $pFeatures = json_decode($package->features);

                      @endphp
                      <div class="col-md-6 col-lg-4">
                        <div class="card mb-30 {{ $package->recommended == '1' ? 'active' : '' }}" data-aos="fade-up"
                          data-aos-delay="200">
                          <div class="d-flex align-items-center">
                            <div class="icon blue"><i class="{{ $package->icon }}"></i></div>
                            <div class="label">
                              <h3>{{ $package->title }}</h3>

                              @if ($package->recommended == '1')
                                <span>{{ __('Recommended') }}</span>
                              @endif
                            </div>
                          </div>
                          <p class="text"></p>
                          <div class="d-flex align-items-center">

                            <span
                              class="price">{{ $package->price != 0 && $be->base_currency_symbol_position == 'left' ? $be->base_currency_symbol : '' }}{{ $package->price == 0 ? 'Free' : $package->price }}{{ $package->price != 0 && $be->base_currency_symbol_position == 'right' ? $be->base_currency_symbol : '' }}</span>
                            <span class="period">/ {{ __("$package->term") }}</span>


                          </div>
                          <h5>{{ __('Whats Included') }}</h5>
                          <ul class="item-list list-unstyled p-0 toggle-list" data-toggle-list="amenitiesToggle"
                            data-toggle-show="3">

                            @includeIf('front.partials.pricing.domains')
                            @includeIf('front.partials.pricing.hotel_rooms')
                            @includeIf('front.partials.pricing.tour_packages')
                            @includeIf('front.partials.pricing.languages')
                            @includeIf('front.partials.pricing.blog')
                            @includeIf('front.partials.pricing.custom_page')
                            @includeIf('front.partials.pricing.support_ticket')
                            @includeIf('front.partials.pricing.qr_builder')


                          </ul>
                          <span class="show-more mb-30" data-toggle-btn="toggleListBtn">Show More+</span>

                          <div class="d-flex align-items-center">
                            @if ($package->is_trial == '1' && $package->price != 0)
                              <a href="{{ route('front.register.view', ['status' => 'trial', 'id' => $package->id]) }}"
                                class="btn secondary-btn">{{ __('Trial') }}</a>
                            @endif
                            @if ($package->price == 0)
                              <a href="{{ route('front.register.view', ['status' => 'regular', 'id' => $package->id]) }}"
                                class="btn primary-btn">{{ __('Signup') }}</a>
                            @else
                              <a href="{{ route('front.register.view', ['status' => 'regular', 'id' => $package->id]) }}"
                                class="btn primary-btn">{{ __('Purchase') }}</a>
                            @endif


                          </div>
                        </div>
                      </div>
                    @endforeach

                  </div>
                </div>
              @endforeach

            </div>
          </div>
        </div>
      </div>
      <!-- Bg Overlay -->
      <img class="bg-overlay" src="{{ asset('assets/front/img/shadow-bg-1.png') }}" alt="Bg">
    </section>
  @endif
  <!-- Pricing End -->



  <!-- After pricing Section -->
  @if (count($after_pricing) > 0)
    @foreach ($after_pricing as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();

          @endphp
          @includeIf('front.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
        @endif
      @endif
    @endforeach
  @endif
  <!-- End pricing End -->

      <!--features Users Start -->
      @if ($bs->featured_users_section == 1)
      <section class="user-profile-area pb-100">
          <div class="container">
              <div class="row">
                  <div class="col-12">
                      <div class="section-title text-center" data-aos="fade-up">
                          <span class="subtitle">{{ $bs->featured_users_subtitle }}</span>
                          <h2 class="title"> {{ $bs->featured_users_title }}</h2>
                      </div>
                  </div>
                  @foreach ($users as $user)
                      <div class="col-lg-4 col-sm-6">
                          <div class="swiper-slide user-card mb-30">
                              <div class="card" data-aos="fade-up" data-aos-delay="100">
                                  <div class="icon">
                                      @if ($user->photo)
                                          <img class="lazyload lazy-image"
                                              data-src="{{ asset('assets/tenant/img/users/' . $user->photo) }}"
                                              alt="user">
                                      @else
                                          <img class="lazyload lazy-image"
                                              data-src="{{ asset('assets/admin/img/propics/blank_user.jpg') }}"
                                              alt="user">
                                      @endif
                                  </div>
                                  <div class="card-content green">
                                      <h3 class="card-title">{{ $user->first_name . ' ' . $user->last_name }}</h3>
                                      <div class="social-link">
                                          @foreach ($user->social_media as $social)
                                              <a href="{{ $social->url }}" target="_blank"><i
                                                      class="{{ $social->icon }}"></i></a>
                                          @endforeach
                                      </div>
                                      <div class="cta-btns">
                                          @php
                                              if (!empty($user)) {
                                                  $currentPackage = App\Http\Helpers\UserPermissionHelper::userPackage(
                                                      $user->id,
                                                  );
                                                  $preferences = App\Models\User\UserPermission::where([
                                                      ['user_id', $user->id],
                                                      ['package_id', $currentPackage->package_id],
                                                  ])->first();
                                                  $permissions = isset($preferences)
                                                      ? json_decode($preferences->permissions, true)
                                                      : [];
                                              }
                                          @endphp
                                          <a href="{{ detailsUrl($user) }}" class="btn btn-sm anim-btn secondary-btn"
                                              target="_blank">{{ __('Visit Website') }}</a>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  @endforeach
              </div>
          </div>
      </section>
  @endif

  <!-- features Users -->


  <!-- After features Section -->
  @if (count($after_featured_users) > 0)
      @foreach ($after_featured_users as $cusHero)
          @if (isset($additional_section_status[$cusHero->id]))
              @if ($additional_section_status[$cusHero->id] == 1)
                  @php
                      $cusHeroContent = App\Models\AdditionalSectionContent::where([
                          ['language_id', $language->id],
                          ['addition_section_id', $cusHero->id],
                      ])->first();

                  @endphp
                  @includeIf('front.additional-section', [
                      'data' => $cusHeroContent,
                      'possition' => $cusHero->possition,
                  ])
              @endif
          @endif
      @endforeach
  @endif
  <!-- End features End -->


  <!-- Testimonial Start -->
  @if ($bs->testimonial_section == 1)
    <section class="testimonial-area pb-120">
      <div class="container">
        <div class="row align-items-end">
          <div class="col-lg-6">
            <div class="testimonial-left">
              <div class="section-title ms-0" data-aos="fade-right">
                <h2 class="title">{{ $bs->testimonial_title }}</h2>
                <br>
                @if (!empty($bs->testimonial_subtitle))
                  <p>{{ $bs->testimonial_subtitle }}</p>
                @endif
              </div>
              <div class="swiper testimonial-slider" data-aos="fade-left">
                <div class="swiper-wrapper">
                  @foreach ($testimonials as $testimonial)
                    <div class="swiper-slide">
                      <div class="slider-item">
                        <div class="quote">
                          <span class="icon"><i class="fas fa-quote-right"></i></span>
                          <p class="text">
                            {{ $testimonial->comment }}
                          </p>
                        </div>
                        <div class="client">
                          <div class="image">
                            <div class="lazy-container aspect-ratio-1-1">
                              <img class="lazyload lazy-image"
                                data-src="{{ asset('assets/front/img/testimonials/' . $testimonial->image) }}"
                                alt="Person Image">
                            </div>
                          </div>
                          <div class="content">
                            <h6 class="name">{{ $testimonial->name }}</h6>
                            <span class="designation">{{ $testimonial->rank }}</span>
                          </div>
                        </div>
                      </div>
                    </div>
                  @endforeach
                </div>
              </div>
              <div class="testimonial-pagination"></div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="testi-image-right" data-aos="fade-right">
              <div class="testi-ratting">
                <img src="{{ asset('assets/front/img/ratting.png') }}" alt="Ratting">
                <b>4.50</b>
              </div>
              <img src="{{ asset('assets/front/img/testimonials/' . $be->testimonial_img) }}" alt="Banner Image">
            </div>
          </div>
        </div>
      </div>

    </section>
  @endif
  <!-- Testimonial End -->

  <!-- After Testimonial Section -->
  @if (count($after_testimonial) > 0)
    @foreach ($after_testimonial as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();

          @endphp
          @includeIf('front.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
        @endif
      @endif
    @endforeach
  @endif
  <!-- End Testimonial End -->


  <!-- Blog Start -->
  @if ($bs->news_section == 1)
    <section class="blog-area ptb-90">
      <div class="container">
        <div class="section-title text-center" data-aos="fade-up">
          <span class="subtitle">{{ $bs->blog_subtitle }}</span>

          @if (!empty($bs->blog_title))
            <h2 class="title">{{ $bs->blog_title }}</h2>
          @endif
        </div>
        <div class="row justify-content-center">
          @foreach ($blogs as $blog)
            <div class="col-md-6 col-lg-4">
              <article class="card mb-30" data-aos="fade-up" data-aos-delay="100">
                <div class="card-image">
                  <a href="{{ route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug]) }}"
                    class="lazy-container aspect-ratio-16-9">
                    <img class="lazyload lazy-image"
                      data-src="{{ asset('assets/front/img/blogs/' . $blog->main_image) }}" alt="Banner Image">
                  </a>
                  <ul class="info-list">
                    <li><i class="fal fa-user"></i>{{ __('Admin') }}</li>
                    <li><i class="fal fa-calendar"></i>{{ \Carbon\Carbon::parse($blog->created_at)->format('F j, Y') }}
                    </li>
                    <li><i class="fal fa-tag"></i>

                      {{ $blog->categoryName }}
                    </li>
                  </ul>
                </div>
                <div class="content">
                  <h3 class="card-title">
                    <a href="{{ route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug]) }}">
                      {{ strlen($blog->title) > 55 ? mb_substr($blog->title, 0, 55, 'utf-8') . '...' : $blog->title }}
                    </a>
                  </h3>
                  <p class="card-text">
                    {!! substr(strip_tags($blog->content), 0, 150) !!}

                  </p>
                  <a href="{{ route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug]) }}"
                    class="card-btn">{{ __('Read More') }}</a>
                </div>
              </article>
            </div>
          @endforeach
        </div>
      </div>
      <!-- Bg Shape -->
    </section>
  @endif
  <!-- Blog End -->

  <!-- After Blog Section -->
  @if (count($after_blog) > 0)
    @foreach ($after_blog as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();

          @endphp
          @includeIf('front.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
        @endif
      @endif
    @endforeach
  @endif
  <!-- End Blog End -->
@endsection
