@extends('front.layout')

@section('pagename')
    - {{ __('FAQ') }}
@endsection

@section('meta-description', !empty($seo) ? $seo->faqs_meta_description : '')
@section('meta-keywords', !empty($seo) ? $seo->faqs_meta_keywords : '')

@section('breadcrumb-title', !empty($heading) ? $heading->faq_title : __('FAQ'))
@section('breadcrumb-link', !empty($heading) ? $heading->faq_title : __('FAQ'))

@section('content')
    <!--====== Start faqs-section ======-->
    <div id="faq" class="faq-area pt-120 pb-90">
        <div class="container">
            <div class="accordion" id="faqAccordion">
                <div class="row justify-content-center">
                    <div class="col-lg-8 has-time-line" data-aos="fade-right">
                        <div class="row">
                            @forelse ($faqs as $key => $faq)
                                @if ($key == 0)
                                    <div class="col-12">
                                        <div class="accordion-item">
                                            <h6 class="accordion-header" id="heading{{ $key }}">
                                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapse{{ $key }}" aria-expanded="false"
                                                    aria-controls="collapse{{ $key }}">
                                                    {{ $faq->question }}
                                                </button>
                                            </h6>
                                            <div id="collapse{{ $key }}" class="accordion-collapse collapse"
                                                aria-labelledby="heading{{ $key }}" data-bs-parent="#faqAccordion">
                                                <div class="accordion-body">
                                                    <p>{{ $faq->answer }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @else
                                    <div class="col-12">
                                        <div class="accordion-item">
                                            <h6 class="accordion-header" id="heading{{ $key }}">
                                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapse{{ $key }}" aria-expanded="false"
                                                    aria-controls="collapse{{ $key }}">
                                                    {{ $faq->question }}
                                                </button>
                                            </h6>
                                            <div id="collapse{{ $key }}" class="accordion-collapse collapse "
                                                aria-labelledby="heading{{ $key }}"
                                                data-bs-parent="#faqAccordion">
                                                <div class="accordion-body">
                                                    <p>{{ $faq->answer }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @empty
                                <div class="bg-light text-center py-5 d-block w-100">
                                    <h3>{{ __('NO FAQ FOUND!') }}</h3>
                                </div>
                            @endforelse

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!--====== End faqs-section ======-->
@endsection
@section('scripts')
    <script>
        "use strict";
        $(document).ready(function() {
            var firstItem = $(".accordion-item:first .accordion-button").length;
            if (firstItem) {
                $(".accordion-item:first .accordion-button").trigger("click");
            }
        });
    </script>

@endsection
