@extends('front.layout')

@section('pagename')
    - {{ __('Blogs') }}
@endsection

@section('meta-description', !empty($seo) ? $seo->blogs_meta_description : '')
@section('meta-keywords', !empty($seo) ? $seo->blogs_meta_keywords : '')

@section('breadcrumb-title', !empty($heading) ? $heading->blog_title : '')
@section('breadcrumb-link', !empty($heading) ? $heading->blog_title : '')


@section('content')

    <!--====== Start saas-blog section ======-->


    <section class="blog-area pb-90 pt-120">
        <div class="container">
            <div class="row justify-content-center">
                @forelse($blogs as $blog)
                    <div class="col-md-6 col-lg-4">
                        <article class="card mb-30" data-aos="fade-up" data-aos-delay="100">
                            <div class="card-image">
                                <a href="{{ route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug]) }}"
                                    class="lazy-container aspect-ratio-16-9">
                                    <img class="lazyload lazy-image"
                                        data-src="{{ asset('assets/front/img/blogs/' . $blog->main_image) }}"
                                        alt="Banner Image">
                                </a>
                                <ul class="info-list">
                                    <li><i class="fal fa-user"></i>{{ __('Admin') }}</li>
                                    <li><i
                                            class="fal fa-calendar"></i>{{ \Carbon\Carbon::parse($blog->created_at)->format('F j, Y') }}
                                    </li>
                                    <li><i class="fal fa-tag"></i>{{ $blog->categoryName }}</li>
                                </ul>
                            </div>
                            <div class="content">
                                <h3 class="card-title">
                                    <a href="{{ route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug]) }}">
                                        {{ strlen($blog->title) > 55 ? mb_substr($blog->title, 0, 55, 'utf-8') . '...' : $blog->title }}
                                    </a>
                                </h3>
                                <p class="card-text">
                                    {!! substr(strip_tags($blog->content), 0, 150) !!}

                                </p>
                                <a href="{{ route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug]) }}"
                                    class="card-btn">{{ __('Read More') }}</a>
                            </div>
                        </article>
                    </div>
                @empty
                    <div class="bg-light text-center py-5 d-block w-100">
                        <h3>{{ __('No Post Found!') }}</h3>
                    </div>
                @endforelse
            </div>
            <div class="pagination mb-30 justify-content-center">
                {{ $blogs->appends(['category' => request()->input('category')])->links() }}
            </div>
        </div>

    </section>

    <!--====== End saas-blog section ======-->


@endsection
