@extends('front.layout')
@section('pagename', __('Reset Password'))
@section('meta-description', !empty($seo) ? $seo->forget_password_meta_description : '')
@section('meta-keywords', !empty($seo) ? $seo->forget_password_meta_keywords : '')

@section('breadcrumb-title', !empty($heading) ? $heading->forget_password_title : '')
@section('breadcrumb-link', !empty($heading) ? $heading->forget_password_title : '')

@section('content')
    <!--====== End Breadcrumbs section ======-->
    <div class="authentication-area pt-90 pb-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="user-form">
                        <div class="title">
                        </div>
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @endif
                        <form class="login-form" action="{{ route('user.forgot.password.submit') }}" method="post"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="form_group">
                                <span>{{ __('Email Address') }}*</span>
                                <input type="email" name="{{ __('email') }}" placeholder="{{ __('Email') }}"
                                    class="form-control" value="{{ Request::old('email') }}">
                                @error('email')
                                    <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div>
                            @if ($bs->is_recaptcha == 1)
                                <div class="form_group mt-4">
                                    <div class="d-block mb-4">
                                        {!! NoCaptcha::renderJs() !!}
                                        {!! NoCaptcha::display() !!}
                                        @if ($errors->has('g-recaptcha-response'))
                                            @php
                                                $errmsg = $errors->first('g-recaptcha-response');
                                            @endphp
                                            <p class="text-danger mb-0 mt-2">{{ __("$errmsg") }}</p>
                                        @endif
                                    </div>
                                </div>
                            @endif
                            <div class="form_group">
                                <button class="btn primary-btn w-100 anim-btn">{{ __('Send Password Reset Link') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
