@extends('front.layout')

@section('meta-keywords', !empty($seo) ? $seo->about_meta_keywords : '')
@section('meta-description', !empty($seo) ? $seo->about_meta_description : '')
@php
    $additional_section_status = json_decode($bs->about_additional_section_status, true);
@endphp
@section('pagename')
    - {{ __('About') }}
@endsection

@section('breadcrumb-title', __('About'))
@section('breadcrumb-link', __('About'))

@section('styles')
    <link rel="stylesheet" href="{{ asset('assets/front/css/odometer.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/about.css') }}">
@endsection

@section('content')

    @if ($bs->about_features_section_status == 1)
        <!-- Choose Start -->
        <section class="choose-area pt-120 pb-90">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-5">
                        <div class="choose-content mb-30" data-aos="fade-right">
                            <span class="subtitle">{{ $be->about_features_section_title }}</span>
                            <h2 class="title">{{ $be->about_features_section_subtitle }}</h2>
                            <p class="text">{!! nl2br($be->about_features_section_text) !!} </p>

                            <div class="content-botom d-flex gap-3 align-items-center">
                                @if ($bs->intro_section_button_url)
                                    <a href="{{ $bs->intro_section_button_url }}" class="btn anim-btn primary-btn"
                                        target="_blank">{{ $bs->intro_section_button_text }}
                                    </a>
                                @endif
                                @if ($be->about_features_section_video_url)
                                    <a href="{{ $bs->about_features_section_video_url }}" class="btn video-btn youtube-popup"><i
                                            class="fas fa-play"></i>
                                    </a>
                                @endif
                            </div>

                        </div>
                    </div>
                    <div class="col-lg-7">
                        <div class="row">
                            @foreach ($features as $feature)
                                <div class="col-lg-4 col-sm-6" data-aos="fade-up">
                                    <div class="card">
                                        <div class="card-icon">
                                            <img class="lazyload lazy-image"
                                                data-src="{{ asset('assets/front/img/feature/' . $feature->icon) }}"
                                                alt="Icon">
                                        </div>
                                        <div class="card-content">
                                            <a href="#">
                                                <h6 class="card-title">{{ $feature->title }}</h6>
                                            </a>
                                            <p class="card-text">{{ $feature->text }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Choose End -->
    @endif

    @if (count($after_features) > 0)
        @foreach ($after_features as $cusFeatures)
            @if (isset($additional_section_status[$cusFeatures->id]))
                @if ($additional_section_status[$cusFeatures->id] == 1)
                    @php
                        $cusFeaturesContent = App\Models\AdditionalSectionContent::where([
                            ['language_id', $lang_id],
                            ['addition_section_id', $cusFeatures->id],
                        ])->first();
                    @endphp
                    @includeIf('front.additional-section', [
                        'data' => $cusFeaturesContent,
                        'possition' => $cusFeatures->possition,
                    ]);
                @endif
            @endif
        @endforeach
    @endif


    @if ($bs->about_work_process_section_status == 1)
        <!-- Store Start -->
        <section class="store-area">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="section-title d-flex align-items-center mb-0 justify-content-between mw-100"
                            data-aos="fade-up" data-aos-delay="100">
                            <h2 class="title">{{ $be->about_process_section_title }}</h2>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row justify-content-center">
                            @foreach ($processes as $process)
                                <div class="col-sm-6 col-lg-6 col-xl-3" data-aos="fade-up" data-aos-delay="100">
                                    <div class="card mb-30">
                                        <div class="card-icon" style="background-color: #{{ $process->color }}">
                                            <i class=" {{ $process->icon }}"></i>
                                        </div>
                                        <div class="card-content">
                                            <h3 class="card-title"> {{ $process->title }}</h3>
                                            <p class="card-text"> {{ $process->text }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
            <!-- Bg Overlay -->
            <img class="bg-overlay lazyload lazy-image" data-src="{{ asset('assets/front/img/shadow-bg-1.png') }}"
                alt="Bg">
        </section>
        <!-- Store End -->
    @endif

    @if (count($after_work_process) > 0)
        @foreach ($after_work_process as $cusWorkProcess)
            @if (isset($additional_section_status[$cusWorkProcess->id]))
                @if ($additional_section_status[$cusWorkProcess->id] == 1)
                    @php
                        $cusWorkProcessContent = App\Models\AdditionalSectionContent::where([
                            ['language_id', $lang_id],
                            ['addition_section_id', $cusWorkProcess->id],
                        ])->first();
                    @endphp
                    @includeIf('front.additional-section', [
                        'data' => $cusWorkProcessContent,
                        'possition' => $cusWorkProcess->possition,
                    ]);
                @endif
            @endif
        @endforeach
    @endif

    @if ($bs->about_counter_section_status == 1)
        <!-- ========= START Achievements ========= -->
        <section class="section-achievement pt-90">
            <div class="container">
                <div class="row gx-xl-5 align-items-center">
                    <div class="col-lg-6">
                        <div class="acrivment-image mb-20">
                            <img class="lazyload lazy-image"
                                data-src="{{ asset('assets/front/img/' . $be->about_counter_image) }}" alt="achievement">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="acrivment-heading px-20 px-lg-0">
                            <h2 class="mb-14">{{ @$be->about_counter_title }}</h2>
                            <P class="mb-30">{{ @$be->about_counter_text }}</P>
                        </div>
                        <div class="achievement-grid">
                            @foreach ($counters as $counter)
                                <!-- achievement-item -->
                                <div class="achievement-item-style-1" style="background: #{{ $counter->color }}">
                                    <div class="achievement-body">
                                        <div class="d-flex align-items-center justify-content-center direction-ltr">
                                            <h2 class="odometer mb-0 fw-bold" data-count="{{ $counter->amount }}">0</h2>
                                            <h6 class="fs-2 fw-bold"><i class="{{ $counter->icon }}"></i></h6>
                                        </div>
                                        <p class="mb-0">{{ $counter->title }}</p>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- ========= END Achievements ========= -->
    @endif

    @if (count($after_counter) > 0)
        @foreach ($after_counter as $cusCounter)
            @if (isset($additional_section_status[$cusCounter->id]))
                @if ($additional_section_status[$cusCounter->id] == 1)
                    @php
                        $cusCounterContent = App\Models\AdditionalSectionContent::where([
                            ['language_id', $lang_id],
                            ['addition_section_id', $cusCounter->id],
                        ])->first();
                    @endphp
                    @includeIf('front.additional-section', [
                        'data' => $cusCounterContent,
                        'possition' => $cusCounter->possition,
                    ]);
                @endif
            @endif
        @endforeach
    @endif

    <!-- Testimonial Start -->
    @if ($bs->testimonial_section == 1)
        <section class="testimonial-area pt-120 pb-120">
            <div class="container">
                <div class="row align-items-end">
                    <div class="col-lg-6">
                        <div class="testimonial-left">
                            <div class="section-title ms-0" data-aos="fade-right">
                                <h2 class="title">{{ $bs->testimonial_title }}</h2>
                                <br>
                                @if (!empty($bs->testimonial_subtitle))
                                    <p>{{ $bs->testimonial_subtitle }}</p>
                                @endif
                            </div>
                            <div class="swiper testimonial-slider" data-aos="fade-left">
                                <div class="swiper-wrapper">
                                    @foreach ($testimonials as $testimonial)
                                        <div class="swiper-slide">
                                            <div class="slider-item">
                                                <div class="quote">
                                                    <span class="icon"><i class="fas fa-quote-right"></i></span>
                                                    <p class="text">
                                                        {{ $testimonial->comment }}
                                                    </p>
                                                </div>
                                                <div class="client">
                                                    <div class="image">
                                                        <div class="lazy-container aspect-ratio-1-1">
                                                            <img class="lazyload lazy-image"
                                                                data-src="{{ asset('assets/front/img/testimonials/' . $testimonial->image) }}"
                                                                alt="Person Image">
                                                        </div>
                                                    </div>
                                                    <div class="content">
                                                        <h6 class="name">{{ $testimonial->name }}</h6>
                                                        <span class="designation">{{ $testimonial->rank }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="testimonial-pagination"></div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="testi-image-right" data-aos="fade-right">
                            <img class="border_style"
                                src="{{ asset('assets/front/img/' . $be->about_testimonial_section_image) }}"
                                alt="Banner Image">
                        </div>
                    </div>
                </div>
            </div>

        </section>
    @endif
    <!-- Testimonial End -->

    @if (count($after_testimonial) > 0)
        @foreach ($after_testimonial as $cusTestimonial)
            @if (isset($additional_section_status[$cusTestimonial->id]))
                @if ($additional_section_status[$cusTestimonial->id] == 1)
                    @php
                        $cusTestimonialContent = App\Models\AdditionalSectionContent::where([
                            ['language_id', $lang_id],
                            ['addition_section_id', $cusTestimonial->id],
                        ])->first();
                    @endphp
                    @includeIf('front.additional-section', [
                        'data' => $cusTestimonialContent,
                        'possition' => $cusTestimonial->possition,
                    ]);
                @endif
            @endif
        @endforeach
    @endif

    @if ($bs->about_blog_section_status == 1)
        <!-- Blog Start -->
        <section class="blog-area pb-90">
            <div class="container">
                <div class="section-title text-center" data-aos="fade-up">
                    @if (!empty(@$be->about_blog_section_title))
                        <h2 class="title">{{ @$be->about_blog_section_title }}</h2>
                    @endif
                </div>
                <div class="row justify-content-center">

                    @foreach ($blogs as $blog)
                        <div class="col-md-6 col-lg-4">
                            <article class="card mb-30" data-aos="fade-up" data-aos-delay="100">
                                <div class="card-image">
                                    <a href="{{ route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug]) }}"
                                        class="lazy-container aspect-ratio-16-9">
                                        <img class="lazyload lazy-image"
                                            data-src="{{ asset('assets/front/img/blogs/' . $blog->main_image) }}"
                                            alt="Banner Image">
                                    </a>
                                    <ul class="info-list">
                                        <li><i class="fal fa-user"></i>{{ __('Admin') }}</li>
                                        <li><i
                                                class="fal fa-calendar"></i>{{ \Carbon\Carbon::parse($blog->created_at)->format('F j, Y') }}
                                        </li>
                                        <li><a href="{{ route('front.blogs', ['category' => $blog->bcategory_id]) }}"><i
                                                    class="fal fa-tag"></i>{{ $blog->bcategory->name }}</a></li>
                                    </ul>
                                </div>
                                <div class="content">
                                    <h3 class="card-title">
                                        <a
                                            href="{{ route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug]) }}">
                                            {{ $blog->title }}
                                        </a>
                                    </h3>
                                    <p class="card-text">
                                        {!! substr(strip_tags($blog->content), 0, 150) !!}

                                    </p>
                                    <a href="{{ route('front.blogdetails', ['id' => $blog->id, 'slug' => $blog->slug]) }}"
                                        class="card-btn">{{ __('Read More') }}</a>
                                </div>
                            </article>
                        </div>
                    @endforeach
                </div>
            </div>
            <!-- Bg Overlay -->
            <img class="bg-overlay lazyload lazy-image" data-src="{{ asset('assets/front/img/shadow-bg-2.png') }}"
                alt="Bg">
            <img class="bg-overlay lazyload lazy-image" data-src="{{ asset('assets/front/img/shadow-bg-1.png') }}"
                alt="Bg">
        </section>
        <!-- Blog End -->
    @endif

    @if (count($after_blog) > 0)
        @foreach ($after_blog as $cusBlog)
            @if (isset($additional_section_status[$cusBlog->id]))
                @if ($additional_section_status[$cusBlog->id] == 1)
                    @php
                        $cusBlogContent = App\Models\AdditionalSectionContent::where([
                            ['language_id', $lang_id],
                            ['addition_section_id', $cusBlog->id],
                        ])->first();
                    @endphp
                    @includeIf('front.additional-section', [
                        'data' => $cusBlogContent,
                        'possition' => $cusBlog->possition,
                    ]);
                @endif
            @endif
        @endforeach
    @endif

@endsection
@section('scripts')
    <script src="{{ asset('assets/front/js/appear.min.js') }}"></script>
    <script src="{{ asset('assets/front/js/odometer.min.js') }}"></script>
    <script>
        "use script"
        // odometer CountDown
        if ($('.odometer').length > 0) {
            $('.odometer').appear(function(e) {
                var odo = $(".odometer");
                odo.each(function() {
                    var countNumber = $(this).attr("data-count");
                    var odometer = new Odometer({
                        el: this,
                        value: 0,
                        format: '',
                        duration: 1500,
                    });
                    odometer.update(countNumber);
                });
            });
        };
    </script>

@endsection
