<html dir="{{ isset($rtl) ? ($rtl == 1 ? 'rtl' : 'ltr') : '' }}">

<head>
    <title>{{ $bs->website_title }}</title>
    <!-- favicon -->
    <link rel="shortcut icon" href="{{ asset('assets/front/img/' . $bs->favicon) }}" type="image/x-icon">
    <!-- bootstrap css -->
    <link rel="stylesheet" href="{{ asset('assets/front/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/503.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/style.css') }}">
    @php
        if (isset($currentLang)) {
            app()->setLocale($currentLang->code);
        }
    @endphp

    <style>
        :root {
            --color-primary: #{{ @$bs->base_color }};
            --color-primary-shade: #{{ @$bs->base_color2 }};
            --gradient-bg: linear-gradient(135deg, #{{ $bs->base_color2 }}14 0%, #{{ $bs->base_color }} 100%);
        }

        .page-title-area {
            background-image: url({{ asset('assets/front/img/' . $bs->breadcrumb) }});
        }
    </style>
</head>

<body>
    <!--    Error section start   -->
    <div class="container ptb-90">
        <div class="row align-items-center g">
            <div class="col-md-12 mx-auto text-center">
                <div class="payment-img mb-50">
                    <img class=""
                        src="{{ !empty($be->page_not_found_image) ? asset('assets/front/img/' . $be->page_not_found_image) : asset('assets/front/img/404.svg') }}"
                        alt="404 Image">
                </div>
            </div>
        </div>
        <div class="row align-items-center ">
            <div class="col-md-12 mx-auto text-center" id="mt">
                <div class="payment mb-30">
                    <div class="payment_header">
                        <div class="check color-primary">
                            <i class="fa fa-exclamation-circle text-warning"></i>
                        </div>
                    </div>
                    <div class="content">
                        <h2 class="mb-4">
                            {{ $be->page_not_found_title }}
                        </h2>
                        <p class="paragraph-text mb-4"></p>
                        <p>
                            {{ $be->page_not_found_subtitle }}
                        </p>
                        <a href="{{ route('front.index') }}"
                            class="btn primary-btn">{{ __('Go to Home') }}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--    Error section end   -->
</body>

</html>
