@extends('admin.layout')
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Edit User') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('admin.dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Users Management') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Registered Users') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('User Details') }}</a>
            </li>
        </ul>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <form id="ajaxEditForm" action="{{ route('update.register.user') }}" method="post">
                    @csrf
                    <input type="hidden" name="user_id" value="{{ $user->id }}">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-6">
                                <div class="card-title">{{ __('Update User info') }} ({{ $user->username }})</div>
                            </div>
                            <div class="col-6 text-right">
                                <a href="{{ route('admin.register.user') }}"
                                    class="btn btn-sm btn-primary float-right">
                                    <i class="fas fa-backward"></i>
                                     {{ __('Back') }}
                                    </a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-6 mx-auto">
                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="">{{ __('First Name') }}</label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ __('First Name') }}" name="first_name"
                                                    value="{{ $user->first_name }}">
                                                <p id="eerrfirst_name" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Last Name') }}</label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ __('Last Name') }}" name="last_name"
                                                    value="{{ $user->last_name }}">
                                                <p id="eerrlast_name" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Company Name') }}</label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ __('Company Name') }}" name="company_name"
                                                    value="{{ $user->company_name }}">
                                                <p id="eerrcompany_name" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Email') }} **</label>
                                                <input type="email" class="form-control"
                                                    placeholder="{{ __('Email') }}" name="email"
                                                    value="{{ $user->email }}">
                                                <p id="eerremail" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Phone') }}</label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ __('Phone') }}" name="phone"
                                                    value="{{ $user->phone }}">
                                                <p id="eerrphone" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="">{{ __('State') }}</label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ __('State') }}" name="state"
                                                    value="{{ $user->state }}">
                                                <p id="eerrstate" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="">{{ __('City') }}</label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ __('City') }}" name="city"
                                                    value="{{ $user->city }}">
                                                <p id="eerrcity" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Country') }}</label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ __('Country') }}" name="country"
                                                    value="{{ $user->country }}">
                                                <p id="eerrcountry" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Address') }}</label>
                                                <input type="text" class="form-control"
                                                    placeholder="{{ __('Address') }}" name="address"
                                                    value="{{ $user->address }}">
                                                <p id="eerraddress" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <button type="submit" id="updateBtn"
                                    class="btn btn-success">{{ __('Submit') }}</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
