@extends('admin.layout')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Announcement Popup') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('admin.dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Basic Settings') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Announcement Popup') }}</a>
            </li>
        </ul>
    </div>
    @php
        $type = request()->input('type');
    @endphp
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-9">
                            <div class="card-title">{{ __('Add Popup') }} ({{ __('Type') }} - {{ $type }})</div>
                        </div>
                        <div class="col-lg-3">
                            <a class="btn btn-primary float-right btn-sm"
                                href="{{ route('admin.popup.index', ['language' => $default->code]) }}">{{ __('All Popups') }}</a>
                        </div>
                    </div>
                </div>
                <div class="card-body pt-5 pb-5">
                    <div class="row">
                        <div class="col-lg-6 mx-auto">

                            <form id="ajaxForm" class="modal-form" action="{{ route('admin.popup.store') }}" method="post"
                                enctype="multipart/form-data">
                                @csrf

                                <input type="hidden" name="type" value="{{ $type }}">

                                @if ($type == 1 || $type == 4 || $type == 5 || $type == 7)
                                    {{-- Image --}}
                                    <div class="form-group">
                                        <div class="col-12 mb-2 pl-0">
                                            <label for="image"><strong>{{ __('Image') }}</strong></label>
                                        </div>
                                        <div class="col-md-12 showImage mb-3 pl-0">
                                            <img src="{{ asset('assets/admin/img/noimage.jpg') }}" alt="..."
                                                class="img-thumbnail">
                                        </div>
                                        <br>
                                        <div class="col-12 mb-2 pl-0">
                                        <div role="button" class="btn btn-primary btn-sm upload-btn" id="image">
                                            <i class="fas fa-images"></i>
                                            {{ __('Choose Image') }}
                                            <input type="file" class="img-input" name="image">
                                        </div>
                                        </div>

                                        <p class="mb-0 text-warning">{{ __('Only png, jpg, jpeg image is allowed') }}</p>
                                        <p id="errimage" class="mb-0 text-danger em"></p>
                                        @if ($type == 1)
                                            <p class="text-warning mb-0">
                                                {{ __('Upload 960 X 600 image for best quality') }}</p>
                                        @elseif ($type == 2 || $type == 3)
                                            <p class="text-warning mb-0">
                                                {{ __('Upload 1145 X 765 image for best quality') }}</p>
                                        @elseif ($type == 4 || $type == 5)
                                            <p class="text-warning mb-0">
                                                {{ __('Upload 517 X 689 image for best quality') }}</p>
                                        @elseif ($type == 6)
                                            <p class="text-warning mb-0">
                                                {{ __('Upload 960 X 660 image for best quality') }}</p>
                                        @elseif ($type == 7)
                                            <p class="text-warning mb-0">
                                                {{ __('Upload 550 X 765 image for best quality') }}</p>
                                        @endif
                                    </div>
                                @endif

                                @if ($type == 2 || $type == 3 || $type == 6)
                                    {{-- Background Image --}}
                                    <div class="form-group">
                                        <div class="col-12 mb-2 pl-0">
                                            <label for="image"><strong>{{ __('Background Image') }}</strong></label>
                                        </div>
                                        <div class="col-md-12 showImage2 pl-0">
                                            <img src="{{ asset('assets/admin/img/noimage.jpg') }}" alt="..."
                                                class="img-thumbnail">
                                        </div>
                                        <br>
                                        <div role="button" class="btn btn-primary btn-sm upload-btn" id="image2">
                                            {{ __('Choose Image') }}
                                            <input type="file" class="img-input" name="background_image">
                                        </div>
                                        <p class="mb-0 text-warning">{{ __('Only png, jpg, jpeg image is allowed') }}</p>
                                        <p id="errbackground_image" class="mb-0 text-danger em"></p>
                                    </div>
                                @endif

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Language') }} <span
                                                    class="text-danger">**</span></label>
                                            <select name="language_id" class="form-control">
                                                <option value="" selected disabled>{{ __('Select a language') }}
                                                </option>
                                                @foreach ($langs as $lang)
                                                    <option value="{{ $lang->id }}">{{ $lang->name }}</option>
                                                @endforeach
                                            </select>
                                            <p id="errlanguage_id" class="mb-0 text-danger em"></p>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Popup Name') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control" name="name" value=""
                                                placeholder="{{ __('Enter Name') }}">
                                            <p class="text-warning mb-0">
                                                {{ __('This will not be shown in the popup in Website, it will help you to indentify the popup in Admin Panel') }}
                                            </p>
                                            <p id="errname" class="mb-0 text-danger em"></p>
                                        </div>
                                    </div>
                                </div>

                                @if ($type == 2 || $type == 3 || $type == 4 || $type == 5 || $type == 6 || $type == 7)
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Title') }} </label>
                                                <input type="text" class="form-control" name="title" value=""
                                                    placeholder="{{ __('Enter Title') }}">
                                                <p id="errtitle" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Text') }} </label>
                                                <textarea class="form-control" name="text" cols="30" rows="3" placeholder="{{ __('Enter Text') }}"></textarea>
                                                <p id="errtext" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($type == 6 || $type == 7)
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="">{{ __('End Date') }} <span
                                                        class="text-danger">**</span></label>
                                                <input type="text" class="form-control ltr datepicker" name="end_date"
                                                    value="" placeholder="{{ __('Enter End Date') }}" readonly
                                                    autocomplete="off">
                                                <p id="errend_date" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="">{{ __('End Time') }} <span
                                                        class="text-danger">**</span></label>
                                                <input type="text" class="form-control ltr timepicker" name="end_time"
                                                    value="" placeholder="{{ __('Enter End Time') }}" readonly
                                                    autocomplete="off">
                                                <p id="errend_time" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($type == 2 || $type == 3)
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>{{ __('Background Color Code') }} <span
                                                        class="text-danger">**</span></label>
                                                <input class="jscolor form-control ltr" name="background_color"
                                                    value="451d53">
                                                <p class="em text-danger mb-0" id="errbackground_color"></p>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="">{{ __('Background Color Opacity') }} <span
                                                        class="text-danger">**</span></label>
                                                <input type="number" class="form-control ltr" name="background_opacity"
                                                    value="" placeholder="{{ __('Enter Opacity Value') }}">
                                                <p id="errbackground_opacity" class="mb-0 text-danger em"></p>
                                                <ul class="mb-0">
                                                    <li class="text-warning mb-0">{{ __('Value must be between 0 to 1') }}
                                                    </li>
                                                    <li class="text-warning mb-0">
                                                        {{ __('The more the opacity value is, the less the trnsparency level will be') }}
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($type == 7)
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label>{{ __('Background Color Code') }} <span
                                                        class="text-danger">**</span></label>
                                                <input class="jscolor form-control ltr" name="background_color"
                                                    value="451d53">
                                                <p class="em text-danger mb-0" id="errbackground_color"></p>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($type == 2 || $type == 3 || $type == 4 || $type == 5 || $type == 6 || $type == 7)
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="">{{ __('Button Text') }} </label>
                                                <input type="text" class="form-control" name="button_text"
                                                    value="" placeholder="{{ __('Enter Button Text') }}">
                                                <p id="errbutton_text" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="">{{ __('Button Color') }} </label>
                                                <input type="text" class="form-control jscolor ltr"
                                                    name="button_color" value="451d53"
                                                    placeholder="{{ __('Enter Button Color') }}">
                                                <p id="errbutton_color" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if ($type == 2 || $type == 4 || $type == 6 || $type == 7)
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Button URL') }} </label>
                                                <input type="text" class="form-control ltr" name="button_url"
                                                    value="" placeholder="{{ __('Enter Button URL') }}">
                                                <p id="errbutton_url" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                <div class="form-group">
                                    <label for="">{{ __('Delay') }} ({{ __('miliseconds') }}) <span
                                            class="text-danger">**</span></label>
                                    <input type="number" class="form-control ltr" name="delay" value=""
                                        placeholder="{{ __('Enter Serial Number') }}">
                                    <p id="errdelay" class="mb-0 text-danger em"></p>
                                    <p class="text-warning mb-0">
                                        {{ __('This will decide the delay time to show the popup') }}</p>
                                </div>
                                <div class="form-group">
                                    <label for="">{{ __('Serial Number') }} <span
                                            class="text-danger">**</span></label>
                                    <input type="number" class="form-control ltr" name="serial_number" value=""
                                        placeholder="{{ __('Enter Serial Number') }}">
                                    <p id="errserial_number" class="mb-0 text-danger em"></p>
                                    <ul>
                                        <li class="text-warning mb-0">{{ __('If there are') }} <strong
                                                class="text-info">{{ __('Multiple Active Popups') }}</strong>,
                                            {{ __('then the popups will be shown in the website according to') }} <strong
                                                class="text-info">{{ __('Serial Number') }}</strong></li>
                                        <li class="text-warning">
                                            {{ __('The higher the serial number, the later the popups will be visible in Website') }}
                                        </li>
                                    </ul>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="form-group from-show-notify row">
                        <div class="col-12 text-center">
                            <button id="submitBtn" type="button" class="btn btn-primary">{{ __('Submit') }}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
