@extends('admin.layout')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Settings') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('admin.dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Packages Management') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Settings') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block">{{ __('Settings') }}</div>
                </div>
                <div class="card-body pt-5 pb-5">
                    <div class="row">
                        <div class="col-lg-6 mx-auto">
                            <form id="settingsForm" action="{{ route('admin.package.settings') }}" method="POST">
                                @csrf
                                <div id="recurringBilling">
                                    <div class="form-group">
                                        <label>{{ __('Remind Before (Days)') }} <span class="text-danger">**</span></label>
                                        <input type="number" name="expiration_reminder" class="form-control"
                                            value="{{ $abe->expiration_reminder }}">
                                        @error('expiration_reminder')
                                            <p class="text-danger">{{ $message }}</p>
                                        @enderror
                                        <p class="text-warning mb-0">
                                            {{ __('Specify how many days before you want to remind your customers about subscription expiration. (via mail)') }}
                                        </p>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="form">
                        <div class="form-group from-show-notify row">
                            <div class="col-12 text-center">
                                <button type="submit" form="settingsForm"
                                    class="btn btn-success">{{ __('Update') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
