@extends('admin.layout')
@if (!empty($abs->language) && $abs->language->rtl == 1)
    <link rel="stylesheet" href="{{ asset('assets/admin/css/rtl.css') }}">
@endif

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Images & Texts') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('admin.dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>

            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Home Page') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Images & Texts') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 mb-3 mb-lg-0">
                            <div class="card-title">{{ __('Update Images & Texts') }}</div>
                        </div>
                        <div class="col-lg-2">
                            @if (!empty($langs))
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text"><i class="fas fa-language" style="color: #1572E8 ; font-size:20px "></i></div>
                                </div>
                                <select name="language" class="form-control"
                                    onchange="window.location='{{ url()->current() . '?language=' }}'+this.value">
                                    <option value="" selected disabled>{{ __('Select a Language') }}</option>
                                    @foreach ($langs as $lang)
                                        <option value="{{ $lang->code }}"
                                            {{ $lang->code == request()->input('language') ? 'selected' : '' }}>
                                            {{ $lang->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="card-body pt-5 pb-4">
                    <form id="ajaxForm" action="{{ route('admin.herosection.update', $lang_id) }}" method="post">
                        @csrf
                        <div class="row">
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <h3 class="text-warning">{{ __('Hero Section') }}</h3>
                                    <hr class="divider m-0"><br>
                                </div>
                            </div>
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <div class="mb-2">
                                                <label for="image"><strong>{{ __('Image Left') }}</strong></label>
                                            </div>
                                            <div class="showImage mb-3">
                                                <img src="{{ !empty($abe->hero_img) ? asset('assets/front/img/' . $abe->hero_img) : asset('assets/admin/img/noimage.jpg') }}"
                                                    alt="..." class="img-thumbnail">
                                            </div>

                                            <br>
                                            <div role="button" class="btn btn-primary btn-sm upload-btn" id="image">
                                                {{ __('Choose Image') }}
                                                <input type="file" class="img-input" name="image">
                                            </div>

                                            <p id="errimage" class="mb-0 text-danger em"></p>
                                            <p class="text-warning mb-0">
                                                {{ __('Recommended image size:Upload 2000 X 1333 image for best quality') }}</p>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <div class="mb-2">
                                                <label for="image"><strong>{{ __('Image Right') }}</strong></label>
                                            </div>
                                            <div class="showImage4 mb-3">
                                                <img src="{{ !empty($abe->hero_img_right) ? asset('assets/front/img/' . $abe->hero_img_right) : asset('assets/admin/img/noimage.jpg') }}"
                                                    alt="..." class="img-thumbnail">
                                            </div>

                                            <br>
                                            <div role="button" class="btn btn-primary btn-sm upload-btn" id="image4">
                                                {{ __('Choose Image') }}
                                                <input type="file" class="img-input" name="hero_img_right">
                                            </div>

                                            <p id="errhero_img_right" class="mb-0 text-danger em"></p>
                                            <p class="text-warning mb-0">
                                                {{ __('Recommended image size:Upload 628 X 770 image for best quality') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Title') }}</label>
                                            <input name="hero_section_title" class="form-control"
                                                value="{{ $abe->hero_section_title }}">
                                            <p id="errhero_section_title" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Subtitle') }}</label>
                                            <input name="hero_section_subtitle" class="form-control"
                                                value="{{ $abe->hero_section_subtitle }}">
                                            <p id="errhero_section_subtitle" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Text') }}</label>
                                            <input name="hero_section_text" class="form-control"
                                                value="{{ $abe->hero_section_text }}">
                                            <p id="errhero_section_text" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Button Text') }} </label>
                                            <input type="text" class="form-control" name="hero_section_button_text"
                                                value="{{ $abe->hero_section_button_text }}">
                                            <p id="errhero_section_button_text" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Button URL') }} </label>
                                            <input type="url" class="form-control ltr" name="hero_section_button_url"
                                                value="{{ $abe->hero_section_button_url }}">
                                            <p id="errhero_section_button_url" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <h3 class="text-warning">{{ __('Intro Section') }}</h3>
                                    <hr class="divider m-0"><br>
                                </div>
                            </div>
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <label for="">{{ __('Title') }} </label>
                                    <input type="text" class="form-control" name="intro_title"
                                        value="{{ $abs->intro_title }}">
                                    <p id="errintro_title" class="em text-danger mb-0"></p>
                                </div>

                                <div class="form-group">
                                    <label for="">{{ __('Subtitle') }}</label>
                                    <input type="text" class="form-control" name="intro_subtitle"
                                        value="{{ $abs->intro_subtitle }}">
                                    <p id="errintro_subtitle" class="em text-danger mb-0"></p>
                                </div>

                                <div class="form-group">
                                    <label for="">{{ __('Text') }} </label>
                                    <textarea name="intro_text" class="form-control" rows="4">{{ $abs->intro_text }}</textarea>
                                    <p id="errintro_text" class="em text-danger mb-0"></p>
                                </div>

                                <div class="form-group">
                                    <label for="">{{ __('Button Text') }} </label>
                                    <input type="text" class="form-control" name="intro_section_button_text"
                                        value="{{ $abs->intro_section_button_text }}">
                                    <p id="errintro_section_button_text" class="em text-danger mb-0"></p>
                                </div>

                                <div class="form-group">
                                    <label for="">{{ __('Button URL') }} </label>
                                    <input type="url" class="form-control ltr" name="intro_section_button_url"
                                        value="{{ $abs->intro_section_button_url }}">
                                    <p id="errintro_section_button_url" class="em text-danger mb-0"></p>
                                </div>

                                <div class="form-group">
                                    <label for="">{{ __('Video URL') }} </label>
                                    <input type="url" class="form-control ltr" name="intro_section_video_url"
                                        value="{{ $abs->intro_section_video_url }}">
                                    <p id="errintro_section_video_url" class="em text-danger mb-0"></p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <h3 class="text-warning">{{ __('Section Titles') }}</h3>
                                    <hr class="divider m-0"><br>
                                </div>
                            </div>
                            <div class="col-12 col-lg-8 mx-auto">

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Work Process Section Title') }}</label>
                                            <input name="work_process_title" class="form-control"
                                                value="{{ $abs->work_process_title }}">
                                            <p id="errwork_process_title" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Work Process Section Subtitle') }}</label>

                                            <input name="work_process_subtitle" class="form-control"
                                                value="{{ $abs->work_process_subtitle }}">
                                            <p id="errwork_process_subtitle" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Preview Templates Section Title') }}</label>

                                            <input name="preview_templates_title" class="form-control"
                                                value="{{ $abs->preview_templates_title }}">
                                            <p id="errpreview_templates_title" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Preview Templates Section Subtitle') }}</label>

                                            <input name="preview_templates_subtitle" class="form-control"
                                                value="{{ $abs->preview_templates_subtitle }}">
                                            <p id="errpreview_templates_subtitle" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Featured Users Section Title') }}</label>

                                            <input name="featured_users_title" class="form-control"
                                                value="{{ $abs->featured_users_title }}">
                                            <p id="errfeatured_users_title" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Featured Users Section Subtitle') }}</label>

                                            <input name="featured_users_subtitle" class="form-control"
                                                value="{{ $abs->featured_users_subtitle }}">
                                            <p id="errfeatured_users_subtitle" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Partner Section Title') }} </label>

                                            <input name="partner_title" class="form-control"
                                                value="{{ $abs->partner_title }}">
                                            <p id="errpartner_title" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Partner Section Subtitle') }} </label>

                                            <input name="partner_subtitle" class="form-control"
                                                value="{{ $abs->partner_subtitle }}">
                                            <p id="errpartner_subtitle" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Pricing Section Title') }} </label>

                                            <input name="pricing_title" class="form-control"
                                                value="{{ $abs->pricing_title }}">
                                            <p id="errpricing_title" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Pricing Section Subtitle') }} </label>

                                            <input name="pricing_subtitle" class="form-control"
                                                value="{{ $abs->pricing_subtitle }}">
                                            <p id="errpricing_subtitle" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Testimonial Section Title') }} </label>

                                            <input name="testimonial_title" class="form-control"
                                                value="{{ $abs->testimonial_title }}">
                                            <p id="errtestimonial_title" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Testimonial Section Subtitle') }} </label>

                                            <input name="testimonial_subtitle" class="form-control"
                                                value="{{ $abs->testimonial_subtitle }}">
                                            <p id="errtestimonial_subtitle" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Blog Section Title') }} </label>

                                            <input name="blog_title" class="form-control"
                                                value="{{ $abs->blog_title }}">
                                            <p id="errblog_title" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Blog Section Subtitle') }} </label>

                                            <input name="blog_subtitle" class="form-control"
                                                value="{{ $abs->blog_subtitle }}">
                                            <p id="errblog_subtitle" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </form>
                </div>

                <div class="card-footer">
                    <div class="form">
                        <div class="form-group from-show-notify row">
                            <div class="col-12 text-center">
                                <button type="submit" id="submitBtn"
                                    class="btn btn-success">{{ __('Update') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
