@extends('admin.layout')
@if (!empty($abs->language) && $abs->language->rtl == 1)
    <link rel="stylesheet" href="{{ asset('assets/admin/css/rtl.css') }}">
@endif

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Images & Texts') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('admin.dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>

            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('About Us') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Images & Texts') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 mb-3 mb-lg-0">
                            <div class="card-title">{{ __('Update Images & Texts') }}</div>
                        </div>
                        <div class="col-lg-2">
                            @if (!empty($langs))
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <div class="input-group-text"><i class="fas fa-language" style="color: #1572E8 ; font-size:20px "></i></div>
                                </div>
                                <select name="language" class="form-control"
                                    onchange="window.location='{{ url()->current() . '?language=' }}'+this.value">
                                    <option value="" selected disabled>{{ __('Select a Language') }}</option>
                                    @foreach ($langs as $lang)
                                        <option value="{{ $lang->code }}"
                                            {{ $lang->code == request()->input('language') ? 'selected' : '' }}>
                                            {{ $lang->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="card-body pt-5 pb-4">
                    <form id="ajaxForm" action="{{ route('admin.aboutpage.update', $lang_id) }}" method="post">
                        @csrf
                        <div class="row">
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <h3 class="text-warning">{{ __('Features Section') }}</h3>
                                    <hr class="divider m-0"><br>
                                </div>
                            </div>
                            <div class="col-12 col-lg-8  mx-auto">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Title') }}</label>
                                            <input name="about_features_section_title" class="form-control"
                                                value="{{ $abe->about_features_section_title }}"
                                                placeholder="{{ __('Enter Title') }}">
                                            <p id="errabout_features_section_title" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Subtitle') }}</label>
                                            <input name="about_features_section_subtitle" class="form-control"
                                                value="{{ $abe->about_features_section_subtitle }}"
                                                placeholder="{{ __('Enter subtitle') }}">
                                            <p id="errabout_features_section_subtitle" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Text') }}</label>
                                            <textarea name="about_features_section_text" id="" cols="30" rows="5"
                                                placeholder="{{ __('Enter Text') }}" class="form-control">{{ $abe->about_features_section_text }}</textarea>
                                            <p id="errabout_features_section_text" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Button Text') }} </label>
                                            <input name="about_features_section_button_text" class="form-control"
                                                value="{{ $abe->about_features_section_button_text }}"
                                                placeholder="{{ __('Enter Text') }}">
                                            <p id="errabout_features_section_button_text" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Button URL') }} </label>
                                            <input type="url" class="form-control ltr"
                                                name="about_features_section_url"
                                                value="{{ $abe->about_features_section_url }}"
                                                style="direction: ltr !important"
                                                placeholder="{{ __('Button URL') }}">
                                            <p id="errabout_features_section_url" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Video URL') }} </label>
                                            <input type="url" class="form-control ltr"
                                                name="about_features_section_video_url"
                                                value="{{ $abe->about_features_section_video_url }}"
                                                style="direction: ltr !important"
                                                placeholder="{{ __('Video URL') }}">
                                            <p id="errabout_features_section_video_url" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <h3 class="text-warning">{{ __('Counter Section') }}</h3>
                                    <hr class="divider m-0"><br>
                                </div>
                            </div>
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <div class="mb-2">
                                                <label for="image"><strong>{{ __('Image') }}</strong></label>
                                            </div>
                                            <div class="showImage3 mb-3">
                                                <img src="{{ !empty($abe->about_counter_image) ? asset('assets/front/img/' . $abe->about_counter_image) : asset('assets/admin/img/noimage.jpg') }}"
                                                    alt="..." class="img-thumbnail w-100px">
                                            </div>

                                            <br>
                                            <div role="button" class="btn btn-primary btn-sm upload-btn" id="image3">
                                                {{ __('Choose Image') }}
                                                <input type="file" class="img-input"
                                                    name="about_counter_image">
                                            </div>

                                            <p id="errabout_counter_image" class="mb-0 text-danger em"></p>
                                            <p class="text-warning mb-0">
                                                {{ __('Upload 743 X 518 image for best quality') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Title') }}</label>
                                            <input name="about_counter_title" class="form-control"
                                                value="{{ $abe->about_counter_title }}"
                                                placeholder="{{ __('Enter Title') }}">
                                            <p id="errabout_counter_title" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Text') }}</label>
                                            <textarea name="about_counter_text" id="" cols="30" rows="5"
                                                placeholder="{{ __('Enter Text') }}" class="form-control">{{ $abe->about_counter_text }}</textarea>
                                            <p id="errabout_counter_text" class="em text-danger mb-0"></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <h3 class="text-warning">{{ __('Testimonial Section') }}</h3>
                                    <hr class="divider m-0"><br>
                                </div>
                            </div>
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <label for="">{{ __('Title') }} </label>
                                    <input type="text" class="form-control" name="about_testimonial_section_title"
                                        value="{{ $abe->about_testimonial_section_title }}"
                                        placeholder="{{ __('Enter Title') }}">
                                    <p id="errabout_testimonial_section_title" class="em text-danger mb-0"></p>
                                </div>
                                <div class="form-group">
                                    <div class="mb-2">
                                        <label for="image"><strong>{{ __('Image') }}</strong></label>
                                    </div>
                                    <div class="showImage2 mb-3">
                                        <img src="{{ !empty($abe->about_testimonial_section_image) ? asset('assets/front/img/' . $abe->about_testimonial_section_image) : asset('assets/admin/img/noimage.jpg') }}"
                                            alt="..." class="img-thumbnail w-100px">
                                    </div>

                                    <br>
                                    <div role="button" class="btn btn-primary btn-sm upload-btn" id="image2">
                                        {{ __('Choose Image') }}
                                        <input type="file" class="img-input" name="about_testimonial_section_image">
                                    </div>

                                    <p id="errimage" class="mb-0 text-danger em"></p>
                                    <p class="text-warning mb-0">
                                        {{ __('Upload 743 X 518 image for best quality') }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <h3 class="text-warning">{{ __('Work Process Section') }}</h3>
                                    <hr class="divider m-0"><br>
                                </div>
                            </div>
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <label for="">{{ __('Title') }} </label>
                                    <input type="text" class="form-control" name="about_process_section_title"
                                        value="{{ $abe->about_process_section_title }}"
                                        placeholder="{{ __('Enter Title') }}">
                                    <p id="errabout_process_section_title" class="em text-danger mb-0"></p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <h3 class="text-warning">{{ __('Blog Section') }}</h3>
                                    <hr class="divider m-0"><br>
                                </div>
                            </div>
                            <div class="col-12 col-lg-8 mx-auto">
                                <div class="form-group">
                                    <label for="">{{ __('Title') }} </label>
                                    <input type="text" class="form-control" name="about_blog_section_title"
                                        value="{{ $abe->about_blog_section_title }}"
                                        placeholder="{{ __('Enter Title') }}">
                                    <p id="errabout_blog_section_title" class="em text-danger mb-0"></p>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="card-footer">
                    <div class="form">
                        <div class="form-group from-show-notify row">
                            <div class="col-12 text-center">
                                <button type="submit" id="submitBtn"
                                    class="btn btn-success">{{ __('Update') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
