<?php

declare(strict_types=1);

return [
    'accepted'             => ':Attribute måste accepteras.',
    'accepted_if'          => ':Attribute måste accepteras när :other är :value.',
    'active_url'           => ':Attribute är inte en giltig webbadress.',
    'after'                => ':Attribute måste vara ett datum efter :date.',
    'after_or_equal'       => ':Attribute måste vara ett datum senare eller samma dag som :date.',
    'alpha'                => ':Attribute får endast innehålla bokstäver.',
    'alpha_dash'           => ':Attribute får endast innehålla bokstäver, siffror och bindestreck.',
    'alpha_num'            => ':Attribute får endast innehålla bokstäver och siffror.',
    'array'                => ':Attribute måste vara en array.',
    'ascii'                => ':Attribute:an får bara innehålla enbyte alfanumeriska tecken och symboler.',
    'before'               => ':Attribute måste vara ett datum innan :date.',
    'before_or_equal'      => ':Attribute måste vara ett datum före eller samma dag som :date.',
    'between'              => [
        'array'   => ':Attribute måste innehålla mellan :min - :max objekt.',
        'file'    => ':Attribute måste vara mellan :min till :max kilobyte stor.',
        'numeric' => ':Attribute måste vara en siffra mellan :min och :max.',
        'string'  => ':Attribute måste innehålla :min till :max tecken.',
    ],
    'boolean'              => ':Attribute måste vara sant eller falskt.',
    'can'                  => 'Fältet :attribute innehåller ett obehörigt värde.',
    'confirmed'            => ':Attribute bekräftelsen matchar inte.',
    'contains'             => 'Fältet :attribute saknar ett obligatoriskt värde.',
    'current_password'     => 'Lösenordet är felaktigt.',
    'date'                 => ':Attribute är inte ett giltigt datum.',
    'date_equals'          => ':Attribute måste vara ett datum lika med :date.',
    'date_format'          => ':Attribute matchar inte formatet :format.',
    'decimal'              => 'De :attribute måste ha :decimal decimaler.',
    'declined'             => ':Attribute måste vara avaktiverat.',
    'declined_if'          => ':Attribute måste vara avaktiverat när :other är :value.',
    'different'            => ':Attribute och :other får inte vara lika.',
    'digits'               => ':Attribute måste vara :digits tecken.',
    'digits_between'       => ':Attribute måste vara mellan :min och :max tecken.',
    'dimensions'           => ':Attribute har felaktiga bilddimensioner.',
    'distinct'             => ':Attribute innehåller fler än en repetition av samma element.',
    'doesnt_end_with'      => ':Attribute får inte sluta med det följande värden: :values.',
    'doesnt_start_with'    => ':Attribute får inte börja med följande värden: :values.',
    'email'                => ':Attribute måste innehålla en korrekt e-postadress.',
    'ends_with'            => ':Attribute måste sluta med en av följande: :values.',
    'enum'                 => ':Attribute är ogiltigt.',
    'exists'               => ':Attribute existerar ej i databasen och är därför ogiltigt.',
    'extensions'           => 'Fältet :attribute måste ha en av följande tillägg: :values.',
    'file'                 => ':Attribute måste vara en fil.',
    'filled'               => ':Attribute är obligatoriskt.',
    'gt'                   => [
        'array'   => ':Attribute måste innehålla fler än :value objekt.',
        'file'    => ':Attribute måste vara större än :value kilobyte stor.',
        'numeric' => ':Attribute måste vara större än :value.',
        'string'  => ':Attribute måste vara längre än :value tecken.',
    ],
    'gte'                  => [
        'array'   => ':Attribute måste innehålla lika många eller fler än :value objekt.',
        'file'    => ':Attribute måste vara lika med eller större än :value kilobyte stor.',
        'numeric' => ':Attribute måste vara lika med eller större än :value.',
        'string'  => ':Attribute måste vara lika med eller längre än :value tecken.',
    ],
    'hex_color'            => 'Fältet :attribute måste vara en giltig hexadecimal färg.',
    'image'                => ':Attribute måste vara en bild.',
    'in'                   => ':Attribute är ogiltigt.',
    'in_array'             => ':Attribute finns inte i :other.',
    'integer'              => ':Attribute måste vara en siffra.',
    'ip'                   => ':Attribute måste vara en giltig IP-adress.',
    'ipv4'                 => ':Attribute måste vara en giltig IPv4-adress.',
    'ipv6'                 => ':Attribute måste vara en giltig IPv6-adress.',
    'json'                 => ':Attribute måste vara en giltig JSON-sträng.',
    'list'                 => 'Fältet :attribute måste vara en lista.',
    'lowercase'            => ':Attribute måste vara i små bokstäver.',
    'lt'                   => [
        'array'   => ':Attribute måste innehålla färre än :value objekt.',
        'file'    => ':Attribute måste vara mindre än :value kilobyte stor.',
        'numeric' => ':Attribute måste vara mindre än :value.',
        'string'  => ':Attribute måste vara kortare än :value tecken.',
    ],
    'lte'                  => [
        'array'   => ':Attribute måste innehålla lika många eller färre än :value objekt.',
        'file'    => ':Attribute måste vara lika med eller mindre än :value kilobyte stor.',
        'numeric' => ':Attribute måste vara lika med eller mindre än :value.',
        'string'  => ':Attribute måste vara lika med eller kortare än :value tecken.',
    ],
    'mac_address'          => ':Attribute måste vara en giltig MAC adress.',
    'max'                  => [
        'array'   => ':Attribute får inte innehålla mer än :max objekt.',
        'file'    => ':Attribute får max vara :max kilobyte stor.',
        'numeric' => ':Attribute får inte vara större än :max.',
        'string'  => ':Attribute får max innehålla :max tecken.',
    ],
    'max_digits'           => ':Attribute får inte innehålla mer än :max siffror.',
    'mimes'                => ':Attribute måste vara en fil av typen: :values.',
    'mimetypes'            => ':Attribute måste vara en fil av typen: :values.',
    'min'                  => [
        'array'   => ':Attribute måste innehålla minst :min objekt.',
        'file'    => ':Attribute måste vara minst :min kilobyte stor.',
        'numeric' => ':Attribute måste vara större än :min.',
        'string'  => ':Attribute måste innehålla minst :min tecken.',
    ],
    'min_digits'           => ':Attribute måste innehålla ett minimum av :min siffror.',
    'missing'              => ':Attribute-fältet måste saknas.',
    'missing_if'           => ':Attribute-fältet måste saknas när :other är :value.',
    'missing_unless'       => ':Attribute-fältet måste saknas om inte :other är :value.',
    'missing_with'         => ':Attribute-fältet måste saknas när :values finns.',
    'missing_with_all'     => ':Attribute-fältet måste saknas när :values finns.',
    'multiple_of'          => ':Attribute måste vara en multipel av :value',
    'not_in'               => ':Attribute är ogiltigt.',
    'not_regex'            => 'Formatet för :attribute är ogiltigt.',
    'numeric'              => ':Attribute måste vara en siffra.',
    'password'             => [
        'letters'       => ':Attribute måste innehålla minst en bokstav.',
        'mixed'         => ':Attribute måste innehålla minst en lite och en stor bokstav.',
        'numbers'       => ':Attribute måste innehålla minst en siffra.',
        'symbols'       => ':Attribute måste innehålla minst en symbol.',
        'uncompromised' => 'Det angivna :attribute återfinns i läkta källor på internet. Byt :attribute så fort som möjligt.',
    ],
    'present'              => ':Attribute måste finnas med.',
    'present_if'           => 'Fältet :attribute måste finnas när :other är :value.',
    'present_unless'       => 'Fältet :attribute måste finnas om inte :other är :value.',
    'present_with'         => 'Fältet :attribute måste finnas när :values är närvarande.',
    'present_with_all'     => 'Fältet :attribute måste finnas när :values är närvarande.',
    'prohibited'           => 'Fältet :attribute är förbjudet.',
    'prohibited_if'        => ':Attribute är förbjudet när :other är :value.',
    'prohibited_unless'    => ':Attribute är förbjudet om inte :other är :values.',
    'prohibits'            => ':Attribute fältet förhindrar :other att ha ett värde.',
    'regex'                => ':Attribute har ogiltigt format.',
    'required'             => ':Attribute är obligatoriskt.',
    'required_array_keys'  => ':Attribute måste innehålla listnamn för :values.',
    'required_if'          => ':Attribute är obligatoriskt när :other är :value.',
    'required_if_accepted' => 'Fältet :attribute är ett krav när fält :other är accepterat.',
    'required_if_declined' => ':attribute-fältet krävs när :other avvisas.',
    'required_unless'      => ':Attribute är obligatoriskt när inte :other finns bland :values.',
    'required_with'        => ':Attribute är obligatoriskt när :values är ifyllt.',
    'required_with_all'    => ':Attribute är obligatoriskt när :values är ifyllt.',
    'required_without'     => ':Attribute är obligatoriskt när :values ej är ifyllt.',
    'required_without_all' => ':Attribute är obligatoriskt när ingen av :values är ifyllt.',
    'same'                 => ':Attribute och :other måste vara lika.',
    'size'                 => [
        'array'   => ':Attribute måste innehålla :size objekt.',
        'file'    => ':Attribute får endast vara :size kilobyte stor.',
        'numeric' => ':Attribute måste vara :size.',
        'string'  => ':Attribute måste innehålla :size tecken.',
    ],
    'starts_with'          => ':Attribute måste börja med en av följande: :values',
    'string'               => ':Attribute måste vara en sträng.',
    'timezone'             => ':Attribute måste vara en giltig tidszon.',
    'ulid'                 => ':Attribute:an måste vara ett giltigt ULID.',
    'unique'               => ':Attribute används redan.',
    'uploaded'             => ':Attribute kunde inte laddas upp.',
    'uppercase'            => ':Attribute måste vara versaler.',
    'url'                  => ':Attribute har ett ogiltigt format.',
    'uuid'                 => ':Attribute måste vara ett giltigt UUID.',
];
