var objOfData = { minimumFractionDigits: 2, maximumFractionDigits: 2 };

(function ($) {
  "use strict";
  package_fee = parseFloat(package_fee);
  package_tax = parseFloat(package_tax);
  // show or hide the attachment input field for offline payment gateway
  $('#payment-gateways').on('change', function () {
    // get the selected offline payment gateway id
    var gatewayId = $(this).val();
    if (gatewayId == 'authorize.net') {
      $("#tab-anet").removeClass('d-none');
      $("#tab-anet").addClass('d-block');
      $("#tab-anet input").removeAttr('disabled');
      $("#tab-stripe").removeClass('d-block');
      $("#tab-stripe").addClass('d-none');

    }
    else if (gatewayId == 'stripe') {
      $("#tab-stripe").removeClass('d-none');
      $("#tab-stripe").addClass('d-block');
      $("#tab-anet").removeClass('d-block');
      $("#tab-anet").addClass('d-none');

      $('#gateway-description').removeClass('d-block');
      $('#gateway-description').addClass('d-none');
      $('#gateway-instruction').removeClass('d-block');
      $('#gateway-instruction').addClass('d-none');
      $('#gateway-attachment').removeClass('d-block');
      $('#gateway-attachment').addClass('d-none');
    } else {
      $("#tab-stripe").removeClass('d-block');
      $("#tab-stripe").addClass('d-none');
      $("#tab-anet").removeClass('d-block');
      $("#tab-anet").addClass('d-none');

      // change string type to integer type
      gatewayId = parseInt(gatewayId);

      // loop to check which element's id match with selected offline payment's id
      for (var key in offlineGateways) {
        if (Object.hasOwnProperty.call(offlineGateways, key)) {
          var elementId = offlineGateways[key].id;

          if (elementId == gatewayId) {
            if (offlineGateways[key].is_receipt == 1) {
              $('#gateway-attachment').removeClass('d-none');
            } else {
              $('#gateway-attachment').addClass('d-none');
            }

            if (offlineGateways[key].short_description.length > 0) {
              $('#gateway-description').removeClass('d-none');
              $('#gateway-description').html(offlineGateways[key].short_description);
            } else {
              $('#gateway-description').addClass('d-none');
            }

            if (offlineGateways[key].instructions.length > 0) {
              $('#gateway-instruction').removeClass('d-none');
              $('#gateway-instruction').html(offlineGateways[key].instructions);
            } else {
              $('#gateway-instruction').addClass('d-none');
            }
            break;
          } else {
            $('#gateway-description').addClass('d-none');
            $('#gateway-instruction').addClass('d-none');
            $('#gateway-attachment').addClass('d-none');
          }
        }
      }
    }
  });


  // get the rating (star) value in integer
  $('.review-value li a').on('click', function () {
    var ratingValue = $(this).attr('data-ratingVal');

    // first, remove star color from all the 'review-value' class
    $('.review-value li a i').removeClass('text-warning');

    // second, add star color to the selected parent class
    var parentClass = 'review-' + ratingValue;
    $('.' + parentClass + ' li a i').addClass('text-warning');

    // finally, set the rating value to a hidden input field
    $('#ratingId').val(ratingValue);
  });


  if (pricingType == 'per-person') {
    $('input[name="visitors"]').on('input', function () {
      removeCoupon();
      let discount_price = 0.00;
      var visitors = $(this).val();
      var rent_price = visitors != "" ? parseInt(visitors) * parseFloat(initialPrice) : initialPrice ;
      let package_rent_price = parseFloat(rent_price);
      let newSubtotal = calculateSubtotal(package_rent_price,discount_price);
      let calculatedTax = calculateTax(newSubtotal, package_tax);
      let newGrandTotal = calculateGrandTotal(newSubtotal + calculatedTax + package_fee);
      showPriceFront(package_rent_price, newSubtotal, newGrandTotal, discount_price, package_fee, calculatedTax)
    });
  }

  if (pricingType == 'fixed') {
    $('input[name="visitors"]').on('input', function () {
      removeCoupon();
      let discount_price = 0.00;
      var visitors = $(this).val();
      var rent_price = visitors != "" ? 1 * parseFloat(initialPrice) : initialPrice;
      let package_rent_price = parseFloat(rent_price);
      let newSubtotal = calculateSubtotal(package_rent_price, discount_price);
      let calculatedTax = calculateTax(newSubtotal, package_tax);
      let newGrandTotal = calculateGrandTotal(newSubtotal + calculatedTax + package_fee);
      showPriceFront(package_rent_price, newSubtotal, newGrandTotal, discount_price, package_fee, calculatedTax)
    });
  }

  $('#coupon-code').on('keypress', function (e) {
    let key = e.which;

    if (key == 13) {
      applyCoupon(e);
    }
  });
})(jQuery);

function applyCoupon(event) {
  event.preventDefault();

  let code = $('#coupon-code').val();
  let subtotal = $('#subtotal-amount').text();
  let id = $('#package-id').text();

  if (code) {
    let url = baseURL +'/'+ getUser.username + '/packages/user/package_booking/apply_coupon';

    let data = {
      coupon: code,
      initTotal: subtotal,
      packageId : id,
      _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
    };

    $.post(url, data, function (response) {
      if ('success' in response) {
        $('#coupon-code').val('');
        let package_rent_price = parseFloat(subtotal);
        let discount_price = response.discount;
        let newSubtotal = calculateSubtotal(package_rent_price,discount_price);
        let calculatedTax = calculateTax(newSubtotal, package_tax);
        let newGrandTotal = calculateGrandTotal(newSubtotal + calculatedTax + package_fee);
        showPriceFront(package_rent_price, newSubtotal, newGrandTotal, discount_price, package_fee, calculatedTax)

        toastr['success'](response.success);
      } else if ('error' in response) {
        toastr['error'](response.error);
      }
    });
  } else {
    alert('Please enter your coupon code.');
  }
}
function calculateSubtotal(price, discount) {
  return (parseFloat(price) || 0) - (parseFloat(discount) || 0);
}
function calculateTax(amount, percentage) {
  return (parseFloat(amount) || 0) * (parseFloat(percentage) || 0) / 100;
}
function calculateGrandTotal(subtotal, tax, fee) {
  return (parseFloat(subtotal) || 0) + (parseFloat(tax) || 0) + (parseFloat(fee) || 0);
}
function showPriceFront(package_rent_price, subtotal, grandTotal, discount = 0.00, fee = 0.00, tax = 0.00) {
 
  const data = {
    package_rent_amount: parseFloat(package_rent_price),
    package_subtotal: parseFloat(subtotal),
    package_grand_total: parseFloat(grandTotal),
    package_discount: parseFloat(discount),
    package_fee: parseFloat(fee),
    package_tax: parseFloat(tax)
  };

  for (const [key, value] of Object.entries(data)) {
    sessionStorage.setItem(key, value);
  }

  $('#rent-price').text(data.package_rent_amount.toFixed(2));
  $('#tax-amount').text(data.package_tax.toFixed(2));
  $('#fee-amount').text(data.package_fee.toFixed(2));
  $('#subtotal-amount').text(data.package_subtotal.toFixed(2));
  $('#discount-amount').text(data.package_discount.toFixed(2));
  $('#total-amount').text(data.package_grand_total.toFixed(2));
}

function showExitingPrice() {
  const package_rent_amount = sessionStorage.getItem('package_rent_amount') || 0;
  const package_discount_amount = sessionStorage.getItem('package_discount') || 0;
  const package_subtotal = sessionStorage.getItem('package_subtotal') || 0;
  const package_fee_amount = sessionStorage.getItem('package_fee') || 0;
  const package_tax_amount = sessionStorage.getItem('package_tax') || 0;
  const package_grand_total_amount = sessionStorage.getItem('package_grand_total') || 0;

  showPriceFront(
    package_rent_amount,
    package_subtotal,
    package_grand_total_amount,
    package_discount_amount,
    package_fee_amount,
    package_tax_amount
  );
}

function removeCoupon() {
  let url = baseURL + '/' + getUser.username + '/packages/user/package_booking/remove_coupon';
  $.get(url);
}
