"use strict";
/*============================================
    popup annoucement
    ============================================*/
function popupAnnouncement($this) {
  let closedPopups = [];
  if (sessionStorage.getItem('closedPopups')) {
    closedPopups = JSON.parse(sessionStorage.getItem('closedPopups'));
  }

  // if the popup is not in closedPopups Array
  if (closedPopups.indexOf($this.data('popup_id')) == -1) {
    $('#' + $this.attr('id')).show();
    let popupDelay = $this.data('popup_delay');

    setTimeout(function () {
      jQuery.magnificPopup.open({
        items: {
          src: '#' + $this.attr('id')
        },
        type: 'inline',
        callbacks: {
          afterClose: function () {
            // after the popup is closed, store it in the sessionStorage & show next popup
            closedPopups.push($this.data('popup_id'));
            sessionStorage.setItem('closedPopups', JSON.stringify(closedPopups));


            if ($this.next('.popup-wrapper').length > 0) {
              popupAnnouncement($this.next('.popup-wrapper'));
            }
          }
        }
      }, 0);
    }, popupDelay);
  } else {
    if ($this.next('.popup-wrapper').length > 0) {
      popupAnnouncement($this.next('.popup-wrapper'));
    }
  }
}

// Preloader
$(window).on('load', function (event) {
  if ($(".popup-wrapper").length > 0) {
    let $firstPopup = $(".popup-wrapper").eq(0);
    popupAnnouncement($firstPopup);
  }

  $('#preLoader').fadeOut(500);
});

/*============================================
Nice select
============================================*/
$(".header-select").niceSelect();

var selectList = $(".nice-select .list")
$(".nice-select .list").each(function () {
  var list = $(this).children();
  if (list.length > 5) {
    $(this).css({
      "height": "160px",
      "overflow-y": "scroll"
    })
  }
})

$('.offer-timer').each(function () {
  let $this = $(this);
  let d = new Date($this.data('end_date'));
  let ye = parseInt(new Intl.DateTimeFormat('en', { year: 'numeric' }).format(d));
  let mo = parseInt(new Intl.DateTimeFormat('en', { month: 'numeric' }).format(d));
  let da = parseInt(new Intl.DateTimeFormat('en', { day: '2-digit' }).format(d));
  let t = $this.data('end_time');
  let time = t.split(":");
  let hr = parseInt(time[0]);
  let min = parseInt(time[1]);
  $this.syotimer({
    year: ye,
    month: mo,
    day: da,
    hour: hr,
    minute: min,
  });
});


/*--------------------------------------------------------
   /  04. password Toggle
   /--------------------------------------------------------*/
if ($(".show-password-field").length > 0) {

  $(".show-password-field").on("click", function () {
    var showIcon = $(this).find(".show-icon");
    var passwordField = $($(this).attr("toggle"));
    showIcon.toggleClass("show");
    if (passwordField.attr("type") == "password") {
      passwordField.attr("type", "text");
    } else {
      passwordField.attr("type", "password");
    }
  });
}


$(document).on('change', '#image', function (event) {
  let file = event.target.files[0];
  let reader = new FileReader();
  reader.onload = function (e) {
    $('.showImage img').attr('src', e.target.result);
  };
  reader.readAsDataURL(file);
})


/*============================================
   Image to background image
   ============================================*/
$(".img-to-bg.blur-up").parent().addClass('blur-up lazyload');

$(".img-to-bg").each(function () {
  var el = $(this),
    src = el.attr("src"),
    parent = el.parent();

  parent.css({
    "background-image": "url(" + src + ")",
    "background-size": "cover",
    "background-position": "center",
    "display": "block"
  });

  el.hide();
});


/*============================================
        Image upload
    ============================================*/
var fileReader = function (input) {
  var regEx = new RegExp(/\.(gif|jpe?g|tiff?|png|webp|bmp)$/i);
  var errorMsg = $("#errorMsg");

  if (input.files && input.files[0] && regEx.test(input.value)) {
    var reader = new FileReader();

    reader.onload = function (e) {
      $('#imagePreview').css('background-image', 'url(' + e.target.result + ')');
      $('#imagePreview').hide();
      $('#imagePreview').fadeIn(650);
    };
    reader.readAsDataURL(input.files[0]);
  } else {
    errorMsg.html("Please upload a valid file type")
  }
}
$("#imageUpload").on("change", function () {
  fileReader(this);
});
