(function ($) {
  "use strict";
  var roomBookinglineChart = document.getElementById('roomBookinglineChart').getContext('2d');
  var myLineChart = new Chart(roomBookinglineChart, {
    type: 'line',
    data: {
      labels: months,
      datasets: [{
        label: "Monthly Room Bookings",
        borderColor: "#1d7af3",
        pointBorderColor: "#FFF",
        pointBackgroundColor: "#1d7af3",
        pointBorderWidth: 2,
        pointHoverRadius: 4,
        pointHoverBorderWidth: 1,
        pointRadius: 4,
        backgroundColor: 'transparent',
        fill: true,
        borderWidth: 2,
        data: inTotalRoomBookings
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      legend: {
        position: 'bottom',
        labels: {
          padding: 10,
          fontColor: '#1d7af3',
        }
      },
      tooltips: {
        bodySpacing: 4,
        mode: "nearest",
        intersect: 0,
        position: "nearest",
        xPadding: 10,
        yPadding: 10,
        caretPadding: 10
      },
      layout: {
        padding: { left: 15, right: 15, top: 15, bottom: 15 }
      }
    }
  });

  var roomBookingIncomelineChart = document.getElementById('roomBookingIncomelineChart').getContext('2d');
  var myUsersChart = new Chart(roomBookingIncomelineChart, {
    type: 'line',
    data: {
      labels: months,
      datasets: [{
        label: "Monthly Room Booking Income",
        borderColor: "#1d7af3",
        pointBorderColor: "#FFF",
        pointBackgroundColor: "#1d7af3",
        pointBorderWidth: 2,
        pointHoverRadius: 4,
        pointHoverBorderWidth: 1,
        pointRadius: 4,
        backgroundColor: 'transparent',
        fill: true,
        borderWidth: 2,
        data: roomIncomeTotals
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      legend: {
        position: 'bottom',
        labels: {
          padding: 10,
          fontColor: '#1d7af3',
        }
      },
      tooltips: {
        bodySpacing: 4,
        mode: "nearest",
        intersect: 0,
        position: "nearest",
        xPadding: 10,
        yPadding: 10,
        caretPadding: 10
      },
      layout: {
        padding: { left: 15, right: 15, top: 15, bottom: 15 }
      }
    }
  });

  //package booking
  if (package_permission == 1){
  var packageBookinglineChart = document.getElementById('packageBookinglineChart').getContext('2d');
  var myLineChart = new Chart(packageBookinglineChart, {
    type: 'line',
    data: {
      labels: months,
      datasets: [{
        label: "Monthly Package Bookings",
        borderColor: "#1d7af3",
        pointBorderColor: "#FFF",
        pointBackgroundColor: "#1d7af3",
        pointBorderWidth: 2,
        pointHoverRadius: 4,
        pointHoverBorderWidth: 1,
        pointRadius: 4,
        backgroundColor: 'transparent',
        fill: true,
        borderWidth: 2,
        data: inTotalPackageBookings
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      legend: {
        position: 'bottom',
        labels: {
          padding: 10,
          fontColor: '#1d7af3',
        }
      },
      tooltips: {
        bodySpacing: 4,
        mode: "nearest",
        intersect: 0,
        position: "nearest",
        xPadding: 10,
        yPadding: 10,
        caretPadding: 10
      },
      layout: {
        padding: { left: 15, right: 15, top: 15, bottom: 15 }
      }
    }
  });

  var packageBookingIncomelineChart = document.getElementById('packageBookingIncomelineChart').getContext('2d');
  var myUsersChart = new Chart(packageBookingIncomelineChart, {
    type: 'line',
    data: {
      labels: months,
      datasets: [{
        label: "Monthly Package Booking Income",
        borderColor: "#1d7af3",
        pointBorderColor: "#FFF",
        pointBackgroundColor: "#1d7af3",
        pointBorderWidth: 2,
        pointHoverRadius: 4,
        pointHoverBorderWidth: 1,
        pointRadius: 4,
        backgroundColor: 'transparent',
        fill: true,
        borderWidth: 2,
        data: packageBookingIncomeTotals
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      legend: {
        position: 'bottom',
        labels: {
          padding: 10,
          fontColor: '#1d7af3',
        }
      },
      tooltips: {
        bodySpacing: 4,
        mode: "nearest",
        intersect: 0,
        position: "nearest",
        xPadding: 10,
        yPadding: 10,
        caretPadding: 10
      },
      layout: {
        padding: { left: 15, right: 15, top: 15, bottom: 15 }
      }
    }
  });
}

})(jQuery);
