(function ($) {
    "use strict";
        let status = $("input[name='details_page_status']:checked").val();

        if (status == 0) {
        $('.service-content').addClass('d-none');
        } else {
        $('.service-content').removeClass('d-none');
        }
        
      // toggle the content field by changing the details page status option
      $("input[type='radio']").on('click', function() {
        let radioValue = $("input[name='details_page_status']:checked").val();

        if (radioValue == 0) {
          $('.service-content').addClass('d-none');
        } else {
          $('.service-content').removeClass('d-none');
        }
      });


      // submit the service form using ajax
      $('#serviceForm').on('submit', function(e) {
        $('.request-loader').addClass('show');
        e.preventDefault();

        if ($('.iconpicker-component').length > 0) {
          $('#inputIcon').val($('.iconpicker-component').find('i').attr('class'));
        }

        let action = $('#serviceForm').attr('action');
        let fd = new FormData(document.querySelector('#serviceForm'));
        
        $('.form-control').each(function (i) {
          let index = i;
          let $toInput = $('.form-control').eq(index);
          if ($(this).hasClass('summernote')) {
            let tmcId = $toInput.attr('id');
            let content = tinyMCE.get(tmcId).getContent();
            fd.delete($(this).attr('name'));
            fd.append($(this).attr('name'), content);
          }
        });

        $.ajax({
          url: action,
          method: 'POST',
          data: fd,
          contentType: false,
          processData: false,
          success: function(data) {
            $('.request-loader').removeClass('show');

            if (data == 'success') {
              location.reload(true);
            }

            if (data == "downgrade") {
              $('.modal').modal('hide');
              "use strict";
              var content = {};
              content.message = your_feature_limit_is_over_or_down_graded;
              content.title = warning;
              content.icon = 'fa fa-bell';
              $.notify(content, {
                type: 'warning',
                placement: {
                  from: 'top',
                  align: 'right'
                },
                showProgressbar: true,
                time: 1000,
                delay: 4000,
              });
              $("#limitModal").modal('show');
            }
          },
          error: function(error) {
            $('#serviceErrors').show();
            let errors = ``;

            for (let x in error.responseJSON.errors) {
              errors += `<li>
                <p class="text-danger mb-0">${ error.responseJSON.errors[x][0] }</p>
              </li>`;
            }

            $('#serviceErrors ul').html(errors);

            $('.request-loader').removeClass('show');

            $('html, body').animate({
              scrollTop: $('#serviceErrors').offset().top - 100
            }, 1000);
          }
        });
      });
  
   
  })(jQuery);
  