(function ($) {
  'use strict';

  let selected_dates;
  let num_of_nights;
  let subtotal;
  let discount;
  let total;
  room_fee = parseFloat(room_fee);
  room_tax = parseFloat(room_tax);

  $(window).on('load', function () {
    if ($('#date-range').length > 0) {
      selected_dates = $('#date-range').val();
    }

    if ($('#night').length > 0) {
      num_of_nights = $('#night').val();
    }

    if ($('#subtotal').length > 0) {
      subtotal = $('#subtotal').val();
    }

    if ($('#discount').length > 0) {
      discount = $('#discount').val();
    }

    if ($('#total').length > 0) {
      total = $('#total').val();
    }
  });


  $('#roomForm').on('submit', function (e) {
    $('.request-loader').addClass('show');
    e.preventDefault();

    let action = $('#roomForm').attr('action');
    let fd = new FormData(document.querySelector('#roomForm'));
    //if summernote has then get summernote content
    $('.form-control').each(function (i) {
      let index = i;

      let $toInput = $('.form-control').eq(index);

      if ($(this).hasClass('summernote')) {
        let tmcId = $toInput.attr('id');
        let content = tinyMCE.get(tmcId).getContent();

        fd.delete($(this).attr('name'));
        fd.append($(this).attr('name'), content);
      }
    });

    $.ajax({
      url: action,
      method: 'POST',
      data: fd,
      contentType: false,
      processData: false,
      success: function (data) {
        $('.request-loader').removeClass('show');

        if (data == 'success') {
          location.reload(true);
        }
      },
      error: function (error) {
        $('#roomErrors').show();
        let errors = ``;

        for (let x in error.responseJSON.errors) {
          errors += `<li>
                <p class="text-danger mb-0">${error.responseJSON.errors[x][0]}</p>
              </li>`;
        }

        $('#roomErrors ul').html(errors);

        $('.request-loader').removeClass('show');

        $('html, body').animate({
          scrollTop: $('#roomErrors').offset().top - 100
        }, 1000);
      }
    });
  });


  /*******************************************************
  ==========Room Booking with AJAX Request Start==========
  *******************************************************/
  $('#roomBookingNextBtn').on('click', function (e) {
    $(e.target).attr('disabled', true);
    $('.request-loader').addClass('show');

    let action = $('#roomSelectForm').attr('action');
    let roomId = $('#selected-room').val();

    $.get(action, { room_id: roomId }, function (response) {
      if ('success' in response) {
        $('.request-loader').removeClass('show');
        $(e.target).attr('disabled', false);

        $('.em').each(function () {
          $(this).html('');
        });

        let url = response.success;

        window.location = url;
      } else if ('error' in response) {
        $('.em').each(function () {
          $(this).html('');
        });

        let errMsg = response.error.room_id[0];

        $('#err_room_id').text(errMsg);

        $('.request-loader').removeClass('show');
        $(e.target).attr('disabled', false);
      }
    });
  });
  /*****************************************************
  ==========Room Booking with AJAX Request End==========
  *****************************************************/


  // initialize date range picker
  let dateArray;

  if (typeof bookedDates != 'undefined') {
    dateArray = bookedDates;
  } else {
    dateArray = [];
  }

  $('#date-range').daterangepicker({
    minDate: new Date(),
    opens: 'left',
    autoUpdateInput: false,
    autoApply: true,
    locale: {
      format: 'YYYY-MM-DD'
    },
    isCustomDate: function (date) {
      for (let index = 0; index < dateArray.length; index++) {
        if (date.format('YYYY-MM-DD') == dateArray[index]) {
          return ['room-booked-date', 'text-white'];
        }
      }
    }
  });

  // show the dates and number of nights in input field when user select a date range
  $('#date-range').on('apply.daterangepicker', function (event, picker) {
    $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD'));

    // get the difference of two dates, date should be in 'YYYY-MM-DD' format
    let dates = $(this).val();

    // first, slice the string and get the arrival_date & departure_date
    let arrOfDate = dates.split(' ');
    let arrival_date = arrOfDate[0];
    let departure_date = arrOfDate[2];

    // parse the strings into date using Date constructor
    arrival_date = new Date(arrival_date);
    departure_date = new Date(departure_date);

    // get the time difference (in millisecond) of two dates
    let difference_in_time = departure_date.getTime() - arrival_date.getTime();

    // finally, get the night difference of two dates (convert time to night)
    let difference_in_night = difference_in_time / (1000 * 60 * 60 * 24);

    $('#night').val(difference_in_night);

    // rent calculation
    let totalRent = difference_in_night * parseFloat(roomRentPerNight);

    let room_rent_price = parseFloat(totalRent);
    let discount_price = 0;
    let newSubtotal = parseFloat(totalRent) - parseFloat(discount_price);
    let calculatedTax = calculation_tax(newSubtotal, room_tax);
    let newGrandTotal = newSubtotal + calculatedTax + room_fee;
    showPriceFront(room_rent_price, newSubtotal, newGrandTotal, discount_price, room_fee, calculatedTax);
    
  });

  // remove the dates and number of nights when user click on cancel button
  $('#date-range').on('cancel.daterangepicker', function (event, picker) {
    $(this).val(selected_dates);
    $('#night').val(num_of_nights);
    $('#subtotal').val(subtotal);
    $('#discount').val(discount);
    $('#total').val(total);
  });

  function showPriceFront(room_rent_price, subtotal, grandTotal, discount = 0, fee = 0, tax = 0) {
   

    grandTotal = parseFloat(grandTotal);
    subtotal = parseFloat(subtotal);
    discount = parseFloat(discount);
    fee = parseFloat(fee);
    tax = parseFloat(tax);
    room_rent_price = parseFloat(room_rent_price);

    $('#price').val(room_rent_price.toFixed(2));
    $('#tax').val(tax.toFixed(2));
    $('#fee').val(fee.toFixed(2));
    $('#discount').val(discount.toFixed(2));
    $('#subtotal').val(subtotal.toFixed(2));
    $('#total').val(grandTotal.toFixed(2));
  }
})(jQuery);


function applyTaxFee(event) {

  let subtotal = parseFloat($('#subtotal').val()) || 0.00;
  let fee = $('#fee').length ? parseFloat($('#fee').val()) || 0.00 : 0.00;
  let tax = $('#tax').length ? parseFloat($('#tax').val()) || 0.00 : 0.00;

  let total = subtotal + fee + tax;

  if (isNaN(total)) {
    $('#total').val('0.00');
  } else {
    $('#total').val(total.toFixed(2));
  }
}


function applyDiscount(event) {

  let roomPrice = parseFloat($('#price').val()) || 0.00;
  let discount = parseFloat($('#discount').val()) || 0.00;
  let fee = $('#fee').length ? parseFloat($('#fee').val()) || 0.00 : 0.00;
  let tax = $('#tax').length ? parseFloat($('#tax').val()) || 0.00 : 0.00;

  let subtotal = roomPrice - discount;
  let total = subtotal + fee + tax;
  if (isNaN(subtotal) || isNaN(total)) {
    $('#subtotal').val('0.00');
    $('#total').val('0.00');
  } else {
    $('#subtotal').val(subtotal.toFixed(2));
    $('#total').val(total.toFixed(2));
  }
}


function calculation_tax($amount, $per) {
  let tax = ($amount * $per) / 100;
  return tax;
}

//room booking form
$('#roomBookingForm').on('submit', function (e) {
  $('.request-loader').addClass('show');
  e.preventDefault();

  let action = $('#roomBookingForm').attr('action');
  let fd = new FormData(document.querySelector('#roomBookingForm'));

  $('.form-control').each(function (i) {
    let index = i;

    let $toInput = $('.form-control').eq(index);

    if ($(this).hasClass('summernote')) {
      let tmcId = $toInput.attr('id');
      let content = tinyMCE.get(tmcId).getContent();
      fd.delete($(this).attr('name'));
      fd.append($(this).attr('name'), content);
    }
  });

  $.ajax({
    url: action,
    method: 'POST',
    data: fd,
    contentType: false,
    processData: false,
    success: function (data) {
      $('.request-loader').removeClass('show');

      if (data == 'success') {
        location.reload(true);
      }
      if (data == "downgrade") {
        $('.modal').modal('hide');
        "use strict";
        var content = {};
        content.message = 'Your feature limit is over or down graded!';
        content.title = "Warning";
        content.icon = 'fa fa-bell';
        $.notify(content, {
          type: 'warning',
          placement: {
            from: 'top',
            align: 'right'
          },
          showProgressbar: true,
          time: 1000,
          delay: 4000,
        });
        $("#limitModal").modal('show');
      }
    },
    error: function (error) {
      $('.em').each(function () {
        $(this).html('');
      });

      for (let x in error.responseJSON.errors) {
        document.getElementById('er_' + x).innerHTML = error.responseJSON.errors[x][0];
      }

      $('.request-loader').removeClass('show');
      $(e.target).attr('disabled', false);
    }
  });
});

