
!(function ($) {
    "use strict";

    // Preloader
    $("#preLoader").delay(1000).queue(function () {
        $(this).remove();
    });

    // Sticky Header
    $(window).on("scroll", function () {
        var header = $(".header-area");
        // If window scroll down .is-sticky class will added to header
        if ($(window).scrollTop() >= 100) {
            header.addClass("is-sticky");
        } else {
            header.removeClass("is-sticky");
        }
    });

    // Mobile Menu
    var mobileMenu = function () {
        // Variables
        var mainNavbar = $(".main-navbar"),
            cloneInto = $(".mobile-menu-wrapper"),
            cloneItem = $(".mobile-item"),
            cloneBlank = "",
            menuToggler = $(".menu-toggler")

        menuToggler.on("click", function () {
            $(this).toggleClass("active");
            $("body").toggleClass("mobile-menu-active")
        })
        mainNavbar.find(cloneItem).clone(!0).appendTo(cloneInto);
        cloneInto.find("#mainMenu .toggle").on("click", function (e) {
            // e.preventDefault();
            $(this)
                .parent("li")
                .children("ul")
                .stop(true, true)
                .slideToggle(350);
            $(this).parent("li").toggleClass("show");
        });
    }
    mobileMenu();

    // Sponsor Slider
    new Swiper(".sponsor-slider", {
        speed: 300,
        spaceBetween: 30,
        autoplay: true,
        loop: true,
        pagination: {
            el: ".swiper-pagination",
            clickable: true,
        },
        breakpoints: {
            // when window width is >= 320px
            320: {
                slidesPerView: 1,
                spaceBetween: 20
            },
            // when window width is >= 400px
            400: {
                slidesPerView: 2,
                spaceBetween: 10
            },
            // when window width is >= 640px
            768: {
                slidesPerView: 3,
                spaceBetween: 30
            },
            // when window width is >= 640px
            1200: {
                slidesPerView: 4,
                spaceBetween: 30
            }
        }
    });

    // User Slider
    new Swiper(".user-slider", {
        speed: 400,
        spaceBetween: 70,
        loop: true,
        breakpoints: {
            // when window width is >= 320px
            320: {
                slidesPerView: 1,
                spaceBetween: 20
            },
            // when window width is >= 576px
            576: {
                slidesPerView: 2,
                spaceBetween: 30
            },
            // when window width is >= 640px
            992: {
                slidesPerView: 3,
                spaceBetween: 30
            },
            1200: {
                slidesPerView: 3,
                spaceBetween: 70
            }
        }
    });

    // Testimonial Slider
    new Swiper(".testimonial-slider", {
        speed: 400,
        autoplay: true,
        spaceBetween: 15,
        slidesPerView: 1,
        autoHeight: true,
        loop: true,
        // Pagination bullets
        pagination: {
            el: ".testimonial-pagination",
            clickable: true,
        },
    });

    // Youtube Popup
    $(".youtube-popup").magnificPopup({
        disableOn: 300,
        type: "iframe",
        mainClass: "mfp-fade",
        removalDelay: 160,
        preloader: false,
        fixedContentPos: false
    })

    // Go to Top
    $(window).on("scroll", function () {
        // If window scroll down .active class will added to go-top
        var goTop = $(".go-top");
        if ($(window).scrollTop() >= 200) {
            goTop.addClass("active");
        } else {
            goTop.removeClass("active")
        }
    })
    

    $(".go-top").on("click", function (e) {
        $("html, body").animate({
            scrollTop: 0,
        }, 0);
    });

    /*=========================
    // Animate Button  
    ===========================*/
    document.querySelectorAll(".anim-btn").forEach(button => {
        // Create a span element dynamically if it doesn't exist
        let span = button.querySelector("span");
        if (!span) {
            span = document.createElement("span");
            button.appendChild(span);
        }

        // Add the mousemove event listener
        button.addEventListener("mousemove", e => {
            const rect = button.getBoundingClientRect();
            span.style.position = "absolute"; // Ensure the span is positioned correctly
            span.style.top = `${e.clientY - rect.top}px`;
            span.style.left = `${e.clientX - rect.left}px`;
        });
    });

    // Lazy-load Image
    function lazyLoad() {
        window.lazySizesConfig = window.lazySizesConfig || {};
        window.lazySizesConfig.loadMode = 2;
        lazySizesConfig.preloadAfterLoad = true;
    }

    // AOS Init
    AOS.init({
        easing: "ease-out",
        duration: 600
    });

    // Nice Select
    $("select").niceSelect();

    // Magic Cursor
    var cursor = function () {
        // Variables Declaration
        var cursor = $('.cursor');
        if (window.innerWidth > 1199) {
            // Adding cursor effect
            $(window).on('mousemove', function (e) {
                cursor.css({
                    'transform': "translate(" + e.clientX + "px," + e.clientY + "px)"
                })
            })
            // Add hover class
            $('a, button, .cursor-pointer').on('mouseenter', function () {
                cursor.addClass('hover');
            })
            // Remove hover class
            $('a, button, .cursor-pointer').on('mouseleave', function () {
                cursor.removeClass('hover');
            })
        } else {
            cursor.remove();
        }
    }

    //offer time
    $('.offer-timer').each(function () {
        let $this = $(this);
        let d = new Date($this.data('end_date'));
        let ye = parseInt(new Intl.DateTimeFormat('en', {
            year: 'numeric'
        }).format(d));
        let mo = parseInt(new Intl.DateTimeFormat('en', {
            month: 'numeric'
        }).format(d));
        let da = parseInt(new Intl.DateTimeFormat('en', {
            day: '2-digit'
        }).format(d));
        let t = $this.data('end_time');
        let time = t.split(":");
        let hr = parseInt(time[0]);
        let min = parseInt(time[1]);
        $this.syotimer({
            year: ye,
            month: mo,
            day: da,
            hour: hr,
            minute: min,
        });
    });

    $(document).ready(function () {
        lazyLoad()
        cursor()
    })

    $('#newsletterForm').on('submit', function (e) {
        e.preventDefault();
        var url = $(this).attr('action');
        var method = $(this).attr('method');
        var fd = new FormData($(this)[0]);

        $.ajax({
            url: url,
            method: method,
            data: fd,
            processData: false,
            contentType: false,
            success: function (response) {
                $('input[name="subscriber_email"]').val('');
                toastr['success'](response.success);
            },
            error: function (errorData) {
                toastr['error'](errorData.responseJSON.error.subscriber_email[0]);
            }
        });
    })

    /*============================================
    Toggle List
============================================*/
    var show_more = show_more_text;
    var show_less = show_less_text;

    $("[data-toggle-list]").each(function () {
        var list = $(this).children();
        var listShow = $(this).data("toggle-show");
        var listShowBtn = $(this).next("[data-toggle-btn]");

        var showMoreText = show_more + ' +';
        var showLessText = show_less + ' -';

        if (list.length > listShow) {
            listShowBtn.show();
            list.slice(listShow).hide();
            listShowBtn.on("click", function () {
                var isExpanded = listShowBtn.text() === showLessText;
                list.slice(listShow).slideToggle(300);
                listShowBtn.text(isExpanded ? showMoreText : showLessText);
            });
        } else {
            listShowBtn.hide();
        }
    });



})(jQuery);

$(window).on('load', function (event) {
    if ($(".popup-wrapper").length > 0) {
        let $firstPopup = $(".popup-wrapper").eq(0);
        popupAnnouncement($firstPopup);
    }
    $('.preloader').fadeOut('500');
});
function popupAnnouncement($this) {
    let closedPopups = [];
    if (sessionStorage.getItem('closedPopups')) {
        closedPopups = JSON.parse(sessionStorage.getItem('closedPopups'));
    }

    // if the popup is not in closedPopups Array
    if (closedPopups.indexOf($this.data('popup_id')) == -1) {
        $('#' + $this.attr('id')).show();
        let popupDelay = $this.data('popup_delay');

        setTimeout(function () {
            jQuery.magnificPopup.open({
                items: { src: '#' + $this.attr('id') },
                type: 'inline',
                callbacks: {
                    afterClose: function () {
                        // after the popup is closed, store it in the sessionStorage & show next popup
                        closedPopups.push($this.data('popup_id'));
                        sessionStorage.setItem('closedPopups', JSON.stringify(closedPopups));
                        if ($this.next('.popup-wrapper').length > 0) {
                            popupAnnouncement($this.next('.popup-wrapper'));
                        }
                    }
                }
            }, 0);
        }, popupDelay);
    } else {
        if ($this.next('.popup-wrapper').length > 0) {
            popupAnnouncement($this.next('.popup-wrapper'));
        }
    }
}

