<?php

namespace App\Traits;

use App\Models\User\PageHeading;
use App\Models\User\Language;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;

trait MiscellaneousTrait
{   
  public static function getLanguage()
  {
    $user = getUser();
    // get the current locale of this system
    if (Session::has('user_front_lang')) {
      $locale = Session::get('user_front_lang');
    }

    if (empty($locale)) {
      $language = Language::where('is_default', 1)->where('user_id',$user->id)->first();
    } else {
      $language = Language::where('code', $locale)->where('user_id',$user->id)->first();
    }
    if (empty($language)) {
        $language = Language::where('is_default', 1)->where('user_id',$user->id)->first();
    }

    return $language;
  }

  public static function getBreadcrumb()
  {
    $user = getUser();
    $breadcrumb = DB::table('user_basic_settings')->select('breadcrumb')
      ->where('user_id',$user->id)
      ->where('uniqid', '=', 12345)
      ->first();

    return $breadcrumb;
  }

  public static function getPageHeading($language)
  {
    $user = getUser();
    if (URL::current() == Route::is('rooms')) {
      $pageHeading = PageHeading::select('rooms_title')
        ->where('language_id', $language->id)
        ->where('user_id',$user->id)
        ->first();
    } else if (URL::current() == Route::is('services')) {
      $pageHeading = PageHeading::select('services_title')
      ->where('user_id',$user->id)
        ->where('language_id', $language->id)
        ->first();
    } else if (URL::current() == Route::is('blogs')) {
      $pageHeading = PageHeading::select('blog_page_title')
      ->where('user_id',$user->id)
        ->where('language_id', $language->id)
        ->first();
    } else if (URL::current() == Route::is('gallery')) {
      $pageHeading = PageHeading::select('gallery_title')
      ->where('user_id',$user->id)
        ->where('language_id', $language->id)
        ->first();
    } else if (URL::current() == Route::is('packages')) {
      $pageHeading = PageHeading::select('packages_title')
      ->where('user_id',$user->id)
        ->where('language_id', $language->id)
        ->first();
    } else if (URL::current() == Route::is('faqs')) {
      $pageHeading = PageHeading::select('faqs_title')
      ->where('user_id',$user->id)
        ->where('language_id', $language->id)
        ->first();
    } else if (URL::current() == Route::is('contact')) {
      $pageHeading = PageHeading::select('contact_page_title')
      ->where('user_id',$user->id)
        ->where('language_id', $language->id)
        ->first();
    }

    return $pageHeading;
  }

  public static function getCurrencyInfoUser()
  {
    $user = Auth::guard('web')->user();
    $baseCurrencyInfo = DB::table('user_basic_settings')->where('user_id', $user->id)
      ->select('base_currency_symbol', 'base_currency_symbol_position', 'base_currency_text', 'base_currency_text_position', 'base_currency_rate')
      ->first();

    return $baseCurrencyInfo;
  }
  public static function getCurrencyInfo()
  {
    $user = getUser();
    $baseCurrencyInfo = DB::table('user_basic_settings')->where('user_id', $user->id)
      ->select('base_currency_symbol', 'base_currency_symbol_position', 'base_currency_text', 'base_currency_text_position', 'base_currency_rate')
      ->first();

    return $baseCurrencyInfo;
  }


}
