<?php

namespace App\Traits;

use App\Http\Helpers\UserPermissionHelper;
use Illuminate\Support\Facades\Auth;

trait CustomSection
{

    public static function AdminFrontHomePage()
    {
        return [
            'hero_section',
            'work_process_section',
            'features_section',
            'featured_users_section',
            'template_section',
            'pricing_section',
            'partner_section',
            'blog_section',
            'testimonial_section',
        ];
    }
    public static function AdminFrontAboutPage()
    {
        return [
            'features_section',
            'work_process_section',
            'counter_section',
            'testimonial_section',
            'blog_section',
        ];
    }
    public static function TenantFrontThemeOne($userId)
    {
        $packageFeatures = UserPermissionHelper::currentPackageFeatures($userId);
        $sections = [
            'search_section',
            'intro_section',
            'video_section',
            'featured_rooms_section',
            'featured_services_section',
            'facilities_section',
            'testimonials_section',
            'brand_section',
        ];
        if (in_array('Tour Package', $packageFeatures)) {
            array_push($sections, 'featured_package_section');
        }
        return $sections;
    }
    public static function TenantFrontThemeTwo($userId)
    {
        $packageFeatures = UserPermissionHelper::currentPackageFeatures($userId);
        $sections = [
            'search_section',
            'intro_section',
            'featured_rooms_section',
            'featured_services_section',
            'statistics_section',
            'video_section',
            'testimonials_section',
            'brand_section',
        ];
        if (in_array('Tour Package', $packageFeatures)) {
            array_push($sections, 'featured_package_section');
        }
        if (in_array('Blog', $packageFeatures)) {
            array_push($sections, 'blogs_section');
        }
        return $sections;
    }
    public static function TenantFrontThemeThree($userId)
    {
        $packageFeatures = UserPermissionHelper::currentPackageFeatures($userId);
        $sections = [
            'search_section',
            'intro_section',
            'rooms_category_section',
            'featured_rooms_section',
            'latest_rooms_section',
            'testimonials_section',
            'featured_services_section',
            'statistics_section',
        ];
        return $sections;
    }
    public static function TenantFrontThemeFour($userId)
    {
        $packageFeatures = UserPermissionHelper::currentPackageFeatures($userId);
        $sections = [
            'search_section',
            'packages_category_section',
            'intro_section',
            'video_section',
            'facilities_section',
        ];

        if (in_array('Tour Package', $packageFeatures)) {
            array_push($sections, 'featured_package_section');
        }
        if (in_array('Tour Package', $packageFeatures)) {
            array_push($sections, 'latest_packages_section');
        }
        if (in_array('Blog', $packageFeatures)) {
            array_push($sections, 'blogs_section');
        }
        return $sections;
    }
    public static function TenantFrontThemeFive($userId)
    {
        $packageFeatures = UserPermissionHelper::currentPackageFeatures($userId);
        $sections = [
            'search_section',
            'intro_section',
            'featured_rooms_section',
            'facilities_section',
            'brand_section',
        ];

        if (in_array('Tour Package', $packageFeatures)) {
            array_push($sections, 'latest_packages_section');
        }
        return $sections;
    }

    public static function AboutUsPage()
    {
        return [
            'about_info_section',
            'facility_section',
            'testimonial_section',
        ];
    }
}
