<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceContent extends Model
{
  use HasFactory;
  protected $table = 'user_service_contents';
  protected $fillable = [
    'language_id',
    'service_id',
    'title',
    'slug',
    'summary',
    'content',
    'meta_keywords',
    'meta_description',
    'user_id'
  ];

  public function service()
  {
    return $this->belongsTo('App\Models\User\Service');
  }

  public function serviceContentLang()
  {
    return $this->belongsTo('App\Models\User\Language');
  }
}
