<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;

class RoomCategory extends Model
{
  use HasFactory;
  protected $table = 'user_room_categories';
  protected $fillable = [
    'language_id',
    'name',
    'slug',
    'status',
    'user_id',
    'serial_number',
    'indx'
  ];

  public function roomCategoryLang()
  {
    return $this->belongsTo('App\Models\User\Language');
  }
  
  public function roomContentList(){
    return $this->hasMany('App\Models\User\Room', 'category_index', 'indx');
  }
  
  public function scopeActive(Builder $query)
  {
    return $query->where('status', 1);
  }
  
  public function scopeOwnedByUser(Builder $query)
  {
    return $query->where('user_id', Auth::guard('web')->user()->id);
  }
  
  public function languagewiseCategories()
  {
    return $this->hasMany(RoomCategory::class, 'indx', 'indx');
  }
  
  protected static function boot()
  {
    parent::boot();
    static::deleting(function ($category) {
      $category->languagewiseCategories()->delete();
    });
  }
}
