<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
  use HasFactory;
  protected $table= 'user_rooms';

  protected $fillable = [
    'slider_imgs',
    'featured_img',
    'status',
    'max_guests',
    'bed',
    'bath',
    'rent',
    'latitude',
    'longitude',
    'address',
    'email',
    'phone',
    'is_featured',
    'avg_rating',
    'quantity',
    'user_id',
    'amenities_index',
    'category_index'
  ];

  public function roomContent()
  {
    return $this->hasMany('App\Models\User\RoomContent');
  }

  public function roomBooking()
  {
    return $this->hasMany('App\Models\User\RoomBooking');
  }
  public function roomCategory(){
    return $this->hasOne(RoomCategory::class,'indx', 'category_index');
  }

  public function roomReview()
  {
    return $this->hasMany('App\Models\User\RoomReview');
  }

  /**
   * scope a query to only those rooms whose status is show.
   *
   * @param  \Illuminate\Database\Eloquent\Builder  $query
   * @return \Illuminate\Database\Eloquent\Builder
   */
  public function scopeStatus($query)
  {
    return $query->where('status', 1);
  }
}
